/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.recyclerview.widget.RecyclerView;

public class LinearSmoothScroller
extends RecyclerView.SmoothScroller {
    private static final boolean DEBUG = false;
    private static final float MILLISECONDS_PER_INCH = 25.0f;
    private static final int TARGET_SEEK_SCROLL_DISTANCE_PX = 10000;
    public static final int SNAP_TO_START = -1;
    public static final int SNAP_TO_END = 1;
    public static final int SNAP_TO_ANY = 0;
    private static final float TARGET_SEEK_EXTRA_SCROLL_RATIO = 1.2f;
    protected final LinearInterpolator mLinearInterpolator = new LinearInterpolator();
    protected final DecelerateInterpolator mDecelerateInterpolator = new DecelerateInterpolator();
    @SuppressLint(value={"UnknownNullness"})
    protected PointF mTargetVector;
    private final DisplayMetrics mDisplayMetrics;
    private boolean mHasCalculatedMillisPerPixel = false;
    private float mMillisPerPixel;
    protected int mInterimTargetDx = 0;
    protected int mInterimTargetDy = 0;

    @SuppressLint(value={"UnknownNullness"})
    public LinearSmoothScroller(Context context) {
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
    }

    @Override
    protected void onStart() {
    }

    @Override
    @SuppressLint(value={"UnknownNullness"})
    protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        int dy;
        int dx = this.calculateDxToMakeVisible(targetView, this.getHorizontalSnapPreference());
        int distance = (int)Math.sqrt(dx * dx + (dy = this.calculateDyToMakeVisible(targetView, this.getVerticalSnapPreference())) * dy);
        int time = this.calculateTimeForDeceleration(distance);
        if (time > 0) {
            action.update(-dx, -dy, time, (Interpolator)this.mDecelerateInterpolator);
        }
    }

    @Override
    @SuppressLint(value={"UnknownNullness"})
    protected void onSeekTargetStep(int dx, int dy, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        if (this.getChildCount() == 0) {
            this.stop();
            return;
        }
        this.mInterimTargetDx = this.clampApplyScroll(this.mInterimTargetDx, dx);
        this.mInterimTargetDy = this.clampApplyScroll(this.mInterimTargetDy, dy);
        if (this.mInterimTargetDx == 0 && this.mInterimTargetDy == 0) {
            this.updateActionForInterimTarget(action);
        }
    }

    @Override
    protected void onStop() {
        this.mInterimTargetDy = 0;
        this.mInterimTargetDx = 0;
        this.mTargetVector = null;
    }

    @SuppressLint(value={"UnknownNullness"})
    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return 25.0f / (float)displayMetrics.densityDpi;
    }

    private float getSpeedPerPixel() {
        if (!this.mHasCalculatedMillisPerPixel) {
            this.mMillisPerPixel = this.calculateSpeedPerPixel(this.mDisplayMetrics);
            this.mHasCalculatedMillisPerPixel = true;
        }
        return this.mMillisPerPixel;
    }

    protected int calculateTimeForDeceleration(int dx) {
        return (int)Math.ceil((double)this.calculateTimeForScrolling(dx) / 0.3356);
    }

    protected int calculateTimeForScrolling(int dx) {
        return (int)Math.ceil((float)Math.abs(dx) * this.getSpeedPerPixel());
    }

    protected int getHorizontalSnapPreference() {
        return this.mTargetVector == null || this.mTargetVector.x == 0.0f ? 0 : (this.mTargetVector.x > 0.0f ? 1 : -1);
    }

    protected int getVerticalSnapPreference() {
        return this.mTargetVector == null || this.mTargetVector.y == 0.0f ? 0 : (this.mTargetVector.y > 0.0f ? 1 : -1);
    }

    @SuppressLint(value={"UnknownNullness"})
    protected void updateActionForInterimTarget(RecyclerView.SmoothScroller.Action action) {
        PointF scrollVector = this.computeScrollVectorForPosition(this.getTargetPosition());
        if (scrollVector == null || scrollVector.x == 0.0f && scrollVector.y == 0.0f) {
            int target = this.getTargetPosition();
            action.jumpTo(target);
            this.stop();
            return;
        }
        this.normalize(scrollVector);
        this.mTargetVector = scrollVector;
        this.mInterimTargetDx = (int)(10000.0f * scrollVector.x);
        this.mInterimTargetDy = (int)(10000.0f * scrollVector.y);
        int time = this.calculateTimeForScrolling(10000);
        action.update((int)((float)this.mInterimTargetDx * 1.2f), (int)((float)this.mInterimTargetDy * 1.2f), (int)((float)time * 1.2f), (Interpolator)this.mLinearInterpolator);
    }

    private int clampApplyScroll(int tmpDt, int dt) {
        int before = tmpDt;
        if (before * (tmpDt -= dt) <= 0) {
            return 0;
        }
        return tmpDt;
    }

    public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
        switch (snapPreference) {
            case -1: {
                return boxStart - viewStart;
            }
            case 1: {
                return boxEnd - viewEnd;
            }
            case 0: {
                int dtStart = boxStart - viewStart;
                if (dtStart > 0) {
                    return dtStart;
                }
                int dtEnd = boxEnd - viewEnd;
                if (dtEnd >= 0) break;
                return dtEnd;
            }
            default: {
                throw new IllegalArgumentException("snap preference should be one of the constants defined in SmoothScroller, starting with SNAP_");
            }
        }
        return 0;
    }

    @SuppressLint(value={"UnknownNullness"})
    public int calculateDyToMakeVisible(View view, int snapPreference) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollVertically()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int top = layoutManager.getDecoratedTop(view) - params.topMargin;
        int bottom = layoutManager.getDecoratedBottom(view) + params.bottomMargin;
        int start = layoutManager.getPaddingTop();
        int end = layoutManager.getHeight() - layoutManager.getPaddingBottom();
        return this.calculateDtToFit(top, bottom, start, end, snapPreference);
    }

    @SuppressLint(value={"UnknownNullness"})
    public int calculateDxToMakeVisible(View view, int snapPreference) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollHorizontally()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
        int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
        int start = layoutManager.getPaddingLeft();
        int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
        return this.calculateDtToFit(left, right, start, end, snapPreference);
    }
}

