/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityNodeProviderCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Map;
import java.util.WeakHashMap;

public class RecyclerViewAccessibilityDelegate
extends AccessibilityDelegateCompat {
    final RecyclerView mRecyclerView;
    private final ItemDelegate mItemDelegate;

    public RecyclerViewAccessibilityDelegate(@NonNull RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        AccessibilityDelegateCompat itemDelegate = this.getItemDelegate();
        this.mItemDelegate = itemDelegate != null && itemDelegate instanceof ItemDelegate ? (ItemDelegate)itemDelegate : new ItemDelegate(this);
    }

    boolean shouldIgnore() {
        return this.mRecyclerView.hasPendingAdapterUpdates();
    }

    public boolean performAccessibilityAction(@SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull View host, int action, @SuppressLint(value={"InvalidNullabilityOverride"}) @Nullable Bundle args) {
        if (super.performAccessibilityAction(host, action, args)) {
            return true;
        }
        if (!this.shouldIgnore() && this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().performAccessibilityAction(action, args);
        }
        return false;
    }

    public void onInitializeAccessibilityNodeInfo(@SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull View host, @SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull AccessibilityNodeInfoCompat info) {
        super.onInitializeAccessibilityNodeInfo(host, info);
        if (!this.shouldIgnore() && this.mRecyclerView.getLayoutManager() != null) {
            this.mRecyclerView.getLayoutManager().onInitializeAccessibilityNodeInfo(info);
        }
    }

    public void onInitializeAccessibilityEvent(@SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull View host, @SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull AccessibilityEvent event) {
        RecyclerView rv;
        super.onInitializeAccessibilityEvent(host, event);
        if (host instanceof RecyclerView && !this.shouldIgnore() && (rv = (RecyclerView)host).getLayoutManager() != null) {
            rv.getLayoutManager().onInitializeAccessibilityEvent(event);
        }
    }

    @NonNull
    public AccessibilityDelegateCompat getItemDelegate() {
        return this.mItemDelegate;
    }

    public static class ItemDelegate
    extends AccessibilityDelegateCompat {
        final RecyclerViewAccessibilityDelegate mRecyclerViewDelegate;
        private Map<View, AccessibilityDelegateCompat> mOriginalItemDelegates = new WeakHashMap<View, AccessibilityDelegateCompat>();

        public ItemDelegate(@NonNull RecyclerViewAccessibilityDelegate recyclerViewDelegate) {
            this.mRecyclerViewDelegate = recyclerViewDelegate;
        }

        void saveOriginalDelegate(View itemView) {
            AccessibilityDelegateCompat delegate = ViewCompat.getAccessibilityDelegate((View)itemView);
            if (delegate != null && delegate != this) {
                this.mOriginalItemDelegates.put(itemView, delegate);
            }
        }

        AccessibilityDelegateCompat getAndRemoveOriginalDelegateForItem(View itemView) {
            return this.mOriginalItemDelegates.remove(itemView);
        }

        public void onInitializeAccessibilityNodeInfo(@SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull View host, @SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull AccessibilityNodeInfoCompat info) {
            if (!this.mRecyclerViewDelegate.shouldIgnore() && this.mRecyclerViewDelegate.mRecyclerView.getLayoutManager() != null) {
                this.mRecyclerViewDelegate.mRecyclerView.getLayoutManager().onInitializeAccessibilityNodeInfoForItem(host, info);
                AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
                if (originalDelegate != null) {
                    originalDelegate.onInitializeAccessibilityNodeInfo(host, info);
                } else {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                }
            } else {
                super.onInitializeAccessibilityNodeInfo(host, info);
            }
        }

        public boolean performAccessibilityAction(@SuppressLint(value={"InvalidNullabilityOverride"}) @NonNull View host, int action, @SuppressLint(value={"InvalidNullabilityOverride"}) @Nullable Bundle args) {
            if (!this.mRecyclerViewDelegate.shouldIgnore() && this.mRecyclerViewDelegate.mRecyclerView.getLayoutManager() != null) {
                AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
                if (originalDelegate != null ? originalDelegate.performAccessibilityAction(host, action, args) : super.performAccessibilityAction(host, action, args)) {
                    return true;
                }
                return this.mRecyclerViewDelegate.mRecyclerView.getLayoutManager().performAccessibilityActionForItem(host, action, args);
            }
            return super.performAccessibilityAction(host, action, args);
        }

        public void sendAccessibilityEvent(@NonNull View host, int eventType) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                originalDelegate.sendAccessibilityEvent(host, eventType);
            } else {
                super.sendAccessibilityEvent(host, eventType);
            }
        }

        public void sendAccessibilityEventUnchecked(@NonNull View host, @NonNull AccessibilityEvent event) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                originalDelegate.sendAccessibilityEventUnchecked(host, event);
            } else {
                super.sendAccessibilityEventUnchecked(host, event);
            }
        }

        public boolean dispatchPopulateAccessibilityEvent(@NonNull View host, @NonNull AccessibilityEvent event) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                return originalDelegate.dispatchPopulateAccessibilityEvent(host, event);
            }
            return super.dispatchPopulateAccessibilityEvent(host, event);
        }

        public void onPopulateAccessibilityEvent(@NonNull View host, @NonNull AccessibilityEvent event) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                originalDelegate.onPopulateAccessibilityEvent(host, event);
            } else {
                super.onPopulateAccessibilityEvent(host, event);
            }
        }

        public void onInitializeAccessibilityEvent(@NonNull View host, @NonNull AccessibilityEvent event) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                originalDelegate.onInitializeAccessibilityEvent(host, event);
            } else {
                super.onInitializeAccessibilityEvent(host, event);
            }
        }

        public boolean onRequestSendAccessibilityEvent(@NonNull ViewGroup host, @NonNull View child, @NonNull AccessibilityEvent event) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                return originalDelegate.onRequestSendAccessibilityEvent(host, child, event);
            }
            return super.onRequestSendAccessibilityEvent(host, child, event);
        }

        @Nullable
        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(@NonNull View host) {
            AccessibilityDelegateCompat originalDelegate = this.mOriginalItemDelegates.get(host);
            if (originalDelegate != null) {
                return originalDelegate.getAccessibilityNodeProvider(host);
            }
            return super.getAccessibilityNodeProvider(host);
        }
    }
}

