/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.result;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class ActivityResultRegistry {
    private static final String KEY_COMPONENT_ACTIVITY_REGISTERED_RCS = "KEY_COMPONENT_ACTIVITY_REGISTERED_RCS";
    private static final String KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS = "KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS";
    private static final String KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS = "KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS";
    private static final String KEY_COMPONENT_ACTIVITY_PENDING_RESULTS = "KEY_COMPONENT_ACTIVITY_PENDING_RESULT";
    private static final String KEY_COMPONENT_ACTIVITY_RANDOM_OBJECT = "KEY_COMPONENT_ACTIVITY_RANDOM_OBJECT";
    private static final String LOG_TAG = "ActivityResultRegistry";
    private static final int INITIAL_REQUEST_CODE_VALUE = 65536;
    private Random mRandom = new Random();
    private final Map<Integer, String> mRcToKey = new HashMap<Integer, String>();
    final Map<String, Integer> mKeyToRc = new HashMap<String, Integer>();
    private final Map<String, LifecycleContainer> mKeyToLifecycleContainers = new HashMap<String, LifecycleContainer>();
    ArrayList<String> mLaunchedKeys = new ArrayList();
    final transient Map<String, CallbackAndContract<?>> mKeyToCallback = new HashMap();
    final Map<String, Object> mParsedPendingResults = new HashMap<String, Object>();
    final Bundle mPendingResults = new Bundle();

    @MainThread
    public abstract <I, O> void onLaunch(int var1, @NonNull ActivityResultContract<I, O> var2, @SuppressLint(value={"UnknownNullness"}) I var3, @Nullable ActivityOptionsCompat var4);

    @NonNull
    public final <I, O> ActivityResultLauncher<I> register(final @NonNull String key, @NonNull LifecycleOwner lifecycleOwner, final @NonNull ActivityResultContract<I, O> contract, final @NonNull ActivityResultCallback<O> callback2) {
        Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        if (lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
            throw new IllegalStateException("LifecycleOwner " + lifecycleOwner + " is attempting to register while current state is " + lifecycle.getCurrentState() + ". LifecycleOwners must call register before they are STARTED.");
        }
        this.registerKey(key);
        LifecycleContainer lifecycleContainer = this.mKeyToLifecycleContainers.get(key);
        if (lifecycleContainer == null) {
            lifecycleContainer = new LifecycleContainer(lifecycle);
        }
        LifecycleEventObserver observer = new LifecycleEventObserver(){

            public void onStateChanged(@NonNull LifecycleOwner lifecycleOwner, @NonNull Lifecycle.Event event) {
                if (Lifecycle.Event.ON_START.equals((Object)event)) {
                    ActivityResult pendingResult;
                    ActivityResultRegistry.this.mKeyToCallback.put(key, new CallbackAndContract(callback2, contract));
                    if (ActivityResultRegistry.this.mParsedPendingResults.containsKey(key)) {
                        Object parsedPendingResult = ActivityResultRegistry.this.mParsedPendingResults.get(key);
                        ActivityResultRegistry.this.mParsedPendingResults.remove(key);
                        callback2.onActivityResult(parsedPendingResult);
                    }
                    if ((pendingResult = (ActivityResult)ActivityResultRegistry.this.mPendingResults.getParcelable(key)) != null) {
                        ActivityResultRegistry.this.mPendingResults.remove(key);
                        callback2.onActivityResult(contract.parseResult(pendingResult.getResultCode(), pendingResult.getData()));
                    }
                } else if (Lifecycle.Event.ON_STOP.equals((Object)event)) {
                    ActivityResultRegistry.this.mKeyToCallback.remove(key);
                } else if (Lifecycle.Event.ON_DESTROY.equals((Object)event)) {
                    ActivityResultRegistry.this.unregister(key);
                }
            }
        };
        lifecycleContainer.addObserver(observer);
        this.mKeyToLifecycleContainers.put(key, lifecycleContainer);
        return new ActivityResultLauncher<I>(){

            @Override
            public void launch(I input, @Nullable ActivityOptionsCompat options) {
                Integer innerCode = ActivityResultRegistry.this.mKeyToRc.get(key);
                if (innerCode == null) {
                    throw new IllegalStateException("Attempting to launch an unregistered ActivityResultLauncher with contract " + contract + " and input " + input + ". You must ensure the ActivityResultLauncher is registered before calling launch().");
                }
                ActivityResultRegistry.this.mLaunchedKeys.add(key);
                try {
                    ActivityResultRegistry.this.onLaunch(innerCode, contract, input, options);
                }
                catch (Exception e) {
                    ActivityResultRegistry.this.mLaunchedKeys.remove(key);
                    throw e;
                }
            }

            @Override
            public void unregister() {
                ActivityResultRegistry.this.unregister(key);
            }

            @Override
            @NonNull
            public ActivityResultContract<I, ?> getContract() {
                return contract;
            }
        };
    }

    @NonNull
    public final <I, O> ActivityResultLauncher<I> register(final @NonNull String key, final @NonNull ActivityResultContract<I, O> contract, @NonNull ActivityResultCallback<O> callback2) {
        ActivityResult pendingResult;
        this.registerKey(key);
        this.mKeyToCallback.put(key, new CallbackAndContract<O>(callback2, contract));
        if (this.mParsedPendingResults.containsKey(key)) {
            Object parsedPendingResult = this.mParsedPendingResults.get(key);
            this.mParsedPendingResults.remove(key);
            callback2.onActivityResult(parsedPendingResult);
        }
        if ((pendingResult = (ActivityResult)this.mPendingResults.getParcelable(key)) != null) {
            this.mPendingResults.remove(key);
            callback2.onActivityResult(contract.parseResult(pendingResult.getResultCode(), pendingResult.getData()));
        }
        return new ActivityResultLauncher<I>(){

            @Override
            public void launch(I input, @Nullable ActivityOptionsCompat options) {
                Integer innerCode = ActivityResultRegistry.this.mKeyToRc.get(key);
                if (innerCode == null) {
                    throw new IllegalStateException("Attempting to launch an unregistered ActivityResultLauncher with contract " + contract + " and input " + input + ". You must ensure the ActivityResultLauncher is registered before calling launch().");
                }
                ActivityResultRegistry.this.mLaunchedKeys.add(key);
                try {
                    ActivityResultRegistry.this.onLaunch(innerCode, contract, input, options);
                }
                catch (Exception e) {
                    ActivityResultRegistry.this.mLaunchedKeys.remove(key);
                    throw e;
                }
            }

            @Override
            public void unregister() {
                ActivityResultRegistry.this.unregister(key);
            }

            @Override
            @NonNull
            public ActivityResultContract<I, ?> getContract() {
                return contract;
            }
        };
    }

    @MainThread
    final void unregister(@NonNull String key) {
        LifecycleContainer lifecycleContainer;
        Integer rc;
        if (!this.mLaunchedKeys.contains(key) && (rc = this.mKeyToRc.remove(key)) != null) {
            this.mRcToKey.remove(rc);
        }
        this.mKeyToCallback.remove(key);
        if (this.mParsedPendingResults.containsKey(key)) {
            Log.w((String)LOG_TAG, (String)("Dropping pending result for request " + key + ": " + this.mParsedPendingResults.get(key)));
            this.mParsedPendingResults.remove(key);
        }
        if (this.mPendingResults.containsKey(key)) {
            Log.w((String)LOG_TAG, (String)("Dropping pending result for request " + key + ": " + this.mPendingResults.getParcelable(key)));
            this.mPendingResults.remove(key);
        }
        if ((lifecycleContainer = this.mKeyToLifecycleContainers.get(key)) != null) {
            lifecycleContainer.clearObservers();
            this.mKeyToLifecycleContainers.remove(key);
        }
    }

    public final void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putIntegerArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_RCS, new ArrayList<Integer>(this.mKeyToRc.values()));
        outState.putStringArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS, new ArrayList<String>(this.mKeyToRc.keySet()));
        outState.putStringArrayList(KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS, new ArrayList<String>(this.mLaunchedKeys));
        outState.putBundle(KEY_COMPONENT_ACTIVITY_PENDING_RESULTS, (Bundle)this.mPendingResults.clone());
        outState.putSerializable(KEY_COMPONENT_ACTIVITY_RANDOM_OBJECT, (Serializable)this.mRandom);
    }

    public final void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ArrayList rcs = savedInstanceState.getIntegerArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_RCS);
        ArrayList keys = savedInstanceState.getStringArrayList(KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS);
        if (keys == null || rcs == null) {
            return;
        }
        this.mLaunchedKeys = savedInstanceState.getStringArrayList(KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS);
        this.mRandom = (Random)savedInstanceState.getSerializable(KEY_COMPONENT_ACTIVITY_RANDOM_OBJECT);
        this.mPendingResults.putAll(savedInstanceState.getBundle(KEY_COMPONENT_ACTIVITY_PENDING_RESULTS));
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (this.mKeyToRc.containsKey(key)) {
                Integer newRequestCode = this.mKeyToRc.remove(key);
                if (!this.mPendingResults.containsKey(key)) {
                    this.mRcToKey.remove(newRequestCode);
                }
            }
            this.bindRcKey((Integer)rcs.get(i), (String)keys.get(i));
        }
    }

    @MainThread
    public final boolean dispatchResult(int requestCode, int resultCode, @Nullable Intent data) {
        String key = this.mRcToKey.get(requestCode);
        if (key == null) {
            return false;
        }
        this.doDispatch(key, resultCode, data, this.mKeyToCallback.get(key));
        return true;
    }

    @MainThread
    public final <O> boolean dispatchResult(int requestCode, @SuppressLint(value={"UnknownNullness"}) O result) {
        String key = this.mRcToKey.get(requestCode);
        if (key == null) {
            return false;
        }
        CallbackAndContract<?> callbackAndContract = this.mKeyToCallback.get(key);
        if (callbackAndContract == null || callbackAndContract.mCallback == null) {
            this.mPendingResults.remove(key);
            this.mParsedPendingResults.put(key, result);
        } else {
            ActivityResultCallback<O> callback2 = callbackAndContract.mCallback;
            if (this.mLaunchedKeys.remove(key)) {
                callback2.onActivityResult(result);
            }
        }
        return true;
    }

    private <O> void doDispatch(String key, int resultCode, @Nullable Intent data, @Nullable CallbackAndContract<O> callbackAndContract) {
        if (callbackAndContract != null && callbackAndContract.mCallback != null && this.mLaunchedKeys.contains(key)) {
            ActivityResultCallback callback2 = callbackAndContract.mCallback;
            ActivityResultContract contract = callbackAndContract.mContract;
            callback2.onActivityResult(contract.parseResult(resultCode, data));
            this.mLaunchedKeys.remove(key);
        } else {
            this.mParsedPendingResults.remove(key);
            this.mPendingResults.putParcelable(key, (Parcelable)new ActivityResult(resultCode, data));
        }
    }

    private void registerKey(String key) {
        Integer existing = this.mKeyToRc.get(key);
        if (existing != null) {
            return;
        }
        int rc = this.generateRandomNumber();
        this.bindRcKey(rc, key);
    }

    private int generateRandomNumber() {
        int number = this.mRandom.nextInt(0x7FFF0000) + 65536;
        while (this.mRcToKey.containsKey(number)) {
            number = this.mRandom.nextInt(0x7FFF0000) + 65536;
        }
        return number;
    }

    private void bindRcKey(int rc, String key) {
        this.mRcToKey.put(rc, key);
        this.mKeyToRc.put(key, rc);
    }

    private static class LifecycleContainer {
        final Lifecycle mLifecycle;
        private final ArrayList<LifecycleEventObserver> mObservers;

        LifecycleContainer(@NonNull Lifecycle lifecycle) {
            this.mLifecycle = lifecycle;
            this.mObservers = new ArrayList();
        }

        void addObserver(@NonNull LifecycleEventObserver observer) {
            this.mLifecycle.addObserver((LifecycleObserver)observer);
            this.mObservers.add(observer);
        }

        void clearObservers() {
            for (LifecycleEventObserver observer : this.mObservers) {
                this.mLifecycle.removeObserver((LifecycleObserver)observer);
            }
            this.mObservers.clear();
        }
    }

    private static class CallbackAndContract<O> {
        final ActivityResultCallback<O> mCallback;
        final ActivityResultContract<?, O> mContract;

        CallbackAndContract(ActivityResultCallback<O> callback2, ActivityResultContract<?, O> contract) {
            this.mCallback = callback2;
            this.mContract = contract;
        }
    }
}

