/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.graphics.Matrix;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.transition.GhostView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=21)
class GhostViewPlatform
implements GhostView {
    private static final String TAG = "GhostViewApi21";
    private static Class<?> sGhostViewClass;
    private static boolean sGhostViewClassFetched;
    private static Method sAddGhostMethod;
    private static boolean sAddGhostMethodFetched;
    private static Method sRemoveGhostMethod;
    private static boolean sRemoveGhostMethodFetched;
    private final View mGhostView;

    static GhostView addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        GhostViewPlatform.fetchAddGhostMethod();
        if (sAddGhostMethod != null) {
            try {
                return new GhostViewPlatform((View)sAddGhostMethod.invoke(null, view, viewGroup, matrix));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return null;
    }

    static void removeGhost(View view) {
        GhostViewPlatform.fetchRemoveGhostMethod();
        if (sRemoveGhostMethod != null) {
            try {
                sRemoveGhostMethod.invoke(null, view);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    private GhostViewPlatform(@NonNull View ghostView) {
        this.mGhostView = ghostView;
    }

    @Override
    public void setVisibility(int visibility) {
        this.mGhostView.setVisibility(visibility);
    }

    @Override
    public void reserveEndViewTransition(ViewGroup viewGroup, View view) {
    }

    private static void fetchGhostViewClass() {
        if (!sGhostViewClassFetched) {
            try {
                sGhostViewClass = Class.forName("android.view.GhostView");
            }
            catch (ClassNotFoundException e) {
                Log.i((String)TAG, (String)"Failed to retrieve GhostView class", (Throwable)e);
            }
            sGhostViewClassFetched = true;
        }
    }

    private static void fetchAddGhostMethod() {
        if (!sAddGhostMethodFetched) {
            try {
                GhostViewPlatform.fetchGhostViewClass();
                sAddGhostMethod = sGhostViewClass.getDeclaredMethod("addGhost", View.class, ViewGroup.class, Matrix.class);
                sAddGhostMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve addGhost method", (Throwable)e);
            }
            sAddGhostMethodFetched = true;
        }
    }

    private static void fetchRemoveGhostMethod() {
        if (!sRemoveGhostMethodFetched) {
            try {
                GhostViewPlatform.fetchGhostViewClass();
                sRemoveGhostMethod = sGhostViewClass.getDeclaredMethod("removeGhost", View.class);
                sRemoveGhostMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve removeGhost method", (Throwable)e);
            }
            sRemoveGhostMethodFetched = true;
        }
    }
}

