/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

class EmojiExclusions {
    private EmojiExclusions() {
    }

    @NonNull
    static Set<int[]> getEmojiExclusions() {
        if (Build.VERSION.SDK_INT >= 34) {
            return EmojiExclusions_Api34.getExclusions();
        }
        return EmojiExclusions_Reflections.getExclusions();
    }

    @RequiresApi(value=34)
    private static class EmojiExclusions_Api34 {
        private EmojiExclusions_Api34() {
        }

        @NonNull
        @DoNotInline
        static Set<int[]> getExclusions() {
            return EmojiExclusions_Reflections.getExclusions();
        }
    }

    private static class EmojiExclusions_Reflections {
        private EmojiExclusions_Reflections() {
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        @NonNull
        static Set<int[]> getExclusions() {
            try {
                Class<?> clazz = Class.forName("android.text.EmojiConsistency");
                Method method = clazz.getMethod("getEmojiConsistencySet", new Class[0]);
                Object result = method.invoke(null, new Object[0]);
                if (result == null) {
                    return Collections.emptySet();
                }
                Set resultList = (Set)result;
                for (Object item : resultList) {
                    if (item instanceof int[]) continue;
                    return Collections.emptySet();
                }
                return resultList;
            }
            catch (Throwable ignore) {
                return Collections.emptySet();
            }
        }
    }
}

