/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.drawable.DrawableCompat;

public class DrawableContainerCompat
extends Drawable
implements Drawable.Callback {
    private static final boolean DEBUG = false;
    private static final String TAG = "DrawableContainerCompat";
    private static final boolean DEFAULT_DITHER = true;
    private DrawableContainerState mDrawableContainerState;
    private Rect mHotspotBounds;
    private Drawable mCurrDrawable;
    private Drawable mLastDrawable;
    private int mAlpha = 255;
    private boolean mHasAlpha;
    private int mCurIndex = -1;
    private boolean mMutated;
    private Runnable mAnimationRunnable;
    private long mEnterAnimationEnd;
    private long mExitAnimationEnd;
    private BlockInvalidateCallback mBlockInvalidateCallback;

    public void draw(@NonNull Canvas canvas) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.draw(canvas);
        }
        if (this.mLastDrawable != null) {
            this.mLastDrawable.draw(canvas);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mDrawableContainerState.getChangingConfigurations();
    }

    private boolean needsMirroring() {
        return this.isAutoMirrored() && DrawableCompat.getLayoutDirection((Drawable)this) == 1;
    }

    public boolean getPadding(@NonNull Rect padding) {
        boolean result;
        Rect r = this.mDrawableContainerState.getConstantPadding();
        if (r != null) {
            padding.set(r);
            result = (r.left | r.top | r.bottom | r.right) != 0;
        } else {
            result = this.mCurrDrawable != null ? this.mCurrDrawable.getPadding(padding) : super.getPadding(padding);
        }
        if (this.needsMirroring()) {
            int left = padding.left;
            padding.left = padding.right;
            padding.right = left;
        }
        return result;
    }

    @RequiresApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        if (this.mCurrDrawable != null) {
            Api21Impl.getOutline(this.mCurrDrawable, outline);
        }
    }

    public void setAlpha(int alpha) {
        if (!this.mHasAlpha || this.mAlpha != alpha) {
            this.mHasAlpha = true;
            this.mAlpha = alpha;
            if (this.mCurrDrawable != null) {
                if (this.mEnterAnimationEnd == 0L) {
                    this.mCurrDrawable.setAlpha(alpha);
                } else {
                    this.animate(false);
                }
            }
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setDither(boolean dither) {
        if (this.mDrawableContainerState.mDither != dither) {
            this.mDrawableContainerState.mDither = dither;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setDither(this.mDrawableContainerState.mDither);
            }
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mDrawableContainerState.mHasColorFilter = true;
        if (this.mDrawableContainerState.mColorFilter != colorFilter) {
            this.mDrawableContainerState.mColorFilter = colorFilter;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setColorFilter(colorFilter);
            }
        }
    }

    public void setTint(@ColorInt int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setTintList(ColorStateList tint) {
        this.mDrawableContainerState.mHasTintList = true;
        if (this.mDrawableContainerState.mTintList != tint) {
            this.mDrawableContainerState.mTintList = tint;
            DrawableCompat.setTintList((Drawable)this.mCurrDrawable, (ColorStateList)tint);
        }
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mDrawableContainerState.mHasTintMode = true;
        if (this.mDrawableContainerState.mTintMode != tintMode) {
            this.mDrawableContainerState.mTintMode = tintMode;
            DrawableCompat.setTintMode((Drawable)this.mCurrDrawable, (PorterDuff.Mode)tintMode);
        }
    }

    public void setEnterFadeDuration(int ms) {
        this.mDrawableContainerState.mEnterFadeDuration = ms;
    }

    public void setExitFadeDuration(int ms) {
        this.mDrawableContainerState.mExitFadeDuration = ms;
    }

    protected void onBoundsChange(Rect bounds) {
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setBounds(bounds);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setBounds(bounds);
        }
    }

    public boolean isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    public void setAutoMirrored(boolean mirrored) {
        if (this.mDrawableContainerState.mAutoMirrored != mirrored) {
            this.mDrawableContainerState.mAutoMirrored = mirrored;
            if (this.mCurrDrawable != null) {
                DrawableCompat.setAutoMirrored((Drawable)this.mCurrDrawable, (boolean)this.mDrawableContainerState.mAutoMirrored);
            }
        }
    }

    public boolean isAutoMirrored() {
        return this.mDrawableContainerState.mAutoMirrored;
    }

    public void jumpToCurrentState() {
        boolean changed = false;
        if (this.mLastDrawable != null) {
            this.mLastDrawable.jumpToCurrentState();
            this.mLastDrawable = null;
            changed = true;
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.jumpToCurrentState();
            if (this.mHasAlpha) {
                this.mCurrDrawable.setAlpha(this.mAlpha);
            }
        }
        if (this.mExitAnimationEnd != 0L) {
            this.mExitAnimationEnd = 0L;
            changed = true;
        }
        if (this.mEnterAnimationEnd != 0L) {
            this.mEnterAnimationEnd = 0L;
            changed = true;
        }
        if (changed) {
            this.invalidateSelf();
        }
    }

    public void setHotspot(float x, float y) {
        if (this.mCurrDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mCurrDrawable, (float)x, (float)y);
        }
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
        if (this.mCurrDrawable != null) {
            DrawableCompat.setHotspotBounds((Drawable)this.mCurrDrawable, (int)left, (int)top, (int)right, (int)bottom);
        }
    }

    public void getHotspotBounds(@NonNull Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    protected boolean onStateChange(@NonNull int[] state) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setState(state);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setState(state);
        }
        return false;
    }

    protected boolean onLevelChange(int level) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setLevel(level);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setLevel(level);
        }
        return false;
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        return this.mDrawableContainerState.setLayoutDirection(layoutDirection, this.getCurrentIndex());
    }

    public int getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicWidth() : -1;
    }

    public int getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicHeight() : -1;
    }

    public int getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumWidth() : 0;
    }

    public int getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumHeight() : 0;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        if (this.mDrawableContainerState != null) {
            this.mDrawableContainerState.invalidateCache();
        }
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable((Drawable)this, what);
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setVisible(visible, restart);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    public int getOpacity() {
        return this.mCurrDrawable == null || !this.mCurrDrawable.isVisible() ? -2 : this.mDrawableContainerState.getOpacity();
    }

    void setCurrentIndex(int index) {
        this.selectDrawable(index);
    }

    int getCurrentIndex() {
        return this.mCurIndex;
    }

    boolean selectDrawable(int index) {
        if (index == this.mCurIndex) {
            return false;
        }
        long now = SystemClock.uptimeMillis();
        if (this.mDrawableContainerState.mExitFadeDuration > 0) {
            if (this.mLastDrawable != null) {
                this.mLastDrawable.setVisible(false, false);
            }
            if (this.mCurrDrawable != null) {
                this.mLastDrawable = this.mCurrDrawable;
                this.mExitAnimationEnd = now + (long)this.mDrawableContainerState.mExitFadeDuration;
            } else {
                this.mLastDrawable = null;
                this.mExitAnimationEnd = 0L;
            }
        } else if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(false, false);
        }
        if (index >= 0 && index < this.mDrawableContainerState.mNumChildren) {
            Drawable d;
            this.mCurrDrawable = d = this.mDrawableContainerState.getChild(index);
            this.mCurIndex = index;
            if (d != null) {
                if (this.mDrawableContainerState.mEnterFadeDuration > 0) {
                    this.mEnterAnimationEnd = now + (long)this.mDrawableContainerState.mEnterFadeDuration;
                }
                this.initializeDrawableForDisplay(d);
            }
        } else {
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        if (this.mEnterAnimationEnd != 0L || this.mExitAnimationEnd != 0L) {
            if (this.mAnimationRunnable == null) {
                this.mAnimationRunnable = new Runnable(){

                    @Override
                    public void run() {
                        DrawableContainerCompat.this.animate(true);
                        DrawableContainerCompat.this.invalidateSelf();
                    }
                };
            } else {
                this.unscheduleSelf(this.mAnimationRunnable);
            }
            this.animate(true);
        }
        this.invalidateSelf();
        return true;
    }

    private void initializeDrawableForDisplay(Drawable d) {
        if (this.mBlockInvalidateCallback == null) {
            this.mBlockInvalidateCallback = new BlockInvalidateCallback();
        }
        d.setCallback((Drawable.Callback)this.mBlockInvalidateCallback.wrap(d.getCallback()));
        try {
            if (this.mDrawableContainerState.mEnterFadeDuration <= 0 && this.mHasAlpha) {
                d.setAlpha(this.mAlpha);
            }
            if (this.mDrawableContainerState.mHasColorFilter) {
                d.setColorFilter(this.mDrawableContainerState.mColorFilter);
            } else {
                if (this.mDrawableContainerState.mHasTintList) {
                    DrawableCompat.setTintList((Drawable)d, (ColorStateList)this.mDrawableContainerState.mTintList);
                }
                if (this.mDrawableContainerState.mHasTintMode) {
                    DrawableCompat.setTintMode((Drawable)d, (PorterDuff.Mode)this.mDrawableContainerState.mTintMode);
                }
            }
            d.setVisible(this.isVisible(), true);
            d.setDither(this.mDrawableContainerState.mDither);
            d.setState(this.getState());
            d.setLevel(this.getLevel());
            d.setBounds(this.getBounds());
            if (Build.VERSION.SDK_INT >= 23) {
                DrawableCompat.setLayoutDirection((Drawable)d, (int)DrawableCompat.getLayoutDirection((Drawable)this));
            }
            if (Build.VERSION.SDK_INT >= 19) {
                DrawableCompat.setAutoMirrored((Drawable)d, (boolean)this.mDrawableContainerState.mAutoMirrored);
            }
            Rect hotspotBounds = this.mHotspotBounds;
            if (Build.VERSION.SDK_INT >= 21 && hotspotBounds != null) {
                DrawableCompat.setHotspotBounds((Drawable)d, (int)hotspotBounds.left, (int)hotspotBounds.top, (int)hotspotBounds.right, (int)hotspotBounds.bottom);
            }
        }
        finally {
            d.setCallback(this.mBlockInvalidateCallback.unwrap());
        }
    }

    void animate(boolean schedule) {
        int animAlpha;
        this.mHasAlpha = true;
        long now = SystemClock.uptimeMillis();
        boolean animating = false;
        if (this.mCurrDrawable != null) {
            if (this.mEnterAnimationEnd != 0L) {
                if (this.mEnterAnimationEnd <= now) {
                    this.mCurrDrawable.setAlpha(this.mAlpha);
                    this.mEnterAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mEnterAnimationEnd - now) * 255L) / this.mDrawableContainerState.mEnterFadeDuration;
                    this.mCurrDrawable.setAlpha((255 - animAlpha) * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mEnterAnimationEnd = 0L;
        }
        if (this.mLastDrawable != null) {
            if (this.mExitAnimationEnd != 0L) {
                if (this.mExitAnimationEnd <= now) {
                    this.mLastDrawable.setVisible(false, false);
                    this.mLastDrawable = null;
                    this.mExitAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mExitAnimationEnd - now) * 255L) / this.mDrawableContainerState.mExitFadeDuration;
                    this.mLastDrawable.setAlpha(animAlpha * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mExitAnimationEnd = 0L;
        }
        if (schedule && animating) {
            this.scheduleSelf(this.mAnimationRunnable, now + 16L);
        }
    }

    @NonNull
    public Drawable getCurrent() {
        return this.mCurrDrawable;
    }

    final void updateDensity(Resources res) {
        this.mDrawableContainerState.updateDensity(res);
    }

    @RequiresApi(value=21)
    public void applyTheme(@NonNull Resources.Theme theme) {
        this.mDrawableContainerState.applyTheme(theme);
    }

    @RequiresApi(value=21)
    public boolean canApplyTheme() {
        return this.mDrawableContainerState.canApplyTheme();
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.mDrawableContainerState.canConstantState()) {
            this.mDrawableContainerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mDrawableContainerState;
        }
        return null;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            DrawableContainerState clone = this.cloneConstantState();
            clone.mutate();
            this.setConstantState(clone);
            this.mMutated = true;
        }
        return this;
    }

    DrawableContainerState cloneConstantState() {
        return this.mDrawableContainerState;
    }

    void clearMutated() {
        this.mDrawableContainerState.clearMutated();
        this.mMutated = false;
    }

    void setConstantState(DrawableContainerState state) {
        this.mDrawableContainerState = state;
        if (this.mCurIndex >= 0) {
            this.mCurrDrawable = state.getChild(this.mCurIndex);
            if (this.mCurrDrawable != null) {
                this.initializeDrawableForDisplay(this.mCurrDrawable);
            }
        }
        this.mLastDrawable = null;
    }

    static int resolveDensity(@Nullable Resources r, int parentDensity) {
        int densityDpi = r == null ? parentDensity : r.getDisplayMetrics().densityDpi;
        return densityDpi == 0 ? 160 : densityDpi;
    }

    @RequiresApi(value=21)
    private static class Api21Impl {
        private Api21Impl() {
        }

        public static boolean canApplyTheme(Drawable.ConstantState constantState) {
            return constantState.canApplyTheme();
        }

        public static Resources getResources(Resources.Theme theme) {
            return theme.getResources();
        }

        public static void getOutline(Drawable drawable2, Outline outline) {
            drawable2.getOutline(outline);
        }
    }

    static class BlockInvalidateCallback
    implements Drawable.Callback {
        private Drawable.Callback mCallback;

        BlockInvalidateCallback() {
        }

        public BlockInvalidateCallback wrap(Drawable.Callback callback) {
            this.mCallback = callback;
            return this;
        }

        public Drawable.Callback unwrap() {
            Drawable.Callback callback = this.mCallback;
            this.mCallback = null;
            return callback;
        }

        public void invalidateDrawable(@NonNull Drawable who) {
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            if (this.mCallback != null) {
                this.mCallback.scheduleDrawable(who, what, when);
            }
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            if (this.mCallback != null) {
                this.mCallback.unscheduleDrawable(who, what);
            }
        }
    }

    static abstract class DrawableContainerState
    extends Drawable.ConstantState {
        final DrawableContainerCompat mOwner;
        Resources mSourceRes;
        int mDensity;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        SparseArray<Drawable.ConstantState> mDrawableFutures;
        Drawable[] mDrawables;
        int mNumChildren;
        boolean mVariablePadding = false;
        boolean mCheckedPadding;
        Rect mConstantPadding;
        boolean mConstantSize = false;
        boolean mCheckedConstantSize;
        int mConstantWidth;
        int mConstantHeight;
        int mConstantMinimumWidth;
        int mConstantMinimumHeight;
        boolean mCheckedOpacity;
        int mOpacity;
        boolean mCheckedStateful;
        boolean mStateful;
        boolean mCheckedConstantState;
        boolean mCanConstantState;
        boolean mDither = true;
        boolean mMutated;
        int mLayoutDirection;
        int mEnterFadeDuration = 0;
        int mExitFadeDuration = 0;
        boolean mAutoMirrored;
        ColorFilter mColorFilter;
        boolean mHasColorFilter;
        ColorStateList mTintList;
        PorterDuff.Mode mTintMode;
        boolean mHasTintList;
        boolean mHasTintMode;

        DrawableContainerState(DrawableContainerState orig, DrawableContainerCompat owner, Resources res) {
            this.mOwner = owner;
            this.mSourceRes = res != null ? res : (orig != null ? orig.mSourceRes : null);
            this.mDensity = DrawableContainerCompat.resolveDensity(res, orig != null ? orig.mDensity : 0);
            if (orig != null) {
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
                this.mVariablePadding = orig.mVariablePadding;
                this.mConstantSize = orig.mConstantSize;
                this.mDither = orig.mDither;
                this.mMutated = orig.mMutated;
                this.mLayoutDirection = orig.mLayoutDirection;
                this.mEnterFadeDuration = orig.mEnterFadeDuration;
                this.mExitFadeDuration = orig.mExitFadeDuration;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mColorFilter = orig.mColorFilter;
                this.mHasColorFilter = orig.mHasColorFilter;
                this.mTintList = orig.mTintList;
                this.mTintMode = orig.mTintMode;
                this.mHasTintList = orig.mHasTintList;
                this.mHasTintMode = orig.mHasTintMode;
                if (orig.mDensity == this.mDensity) {
                    if (orig.mCheckedPadding) {
                        this.mConstantPadding = orig.mConstantPadding != null ? new Rect(orig.mConstantPadding) : null;
                        this.mCheckedPadding = true;
                    }
                    if (orig.mCheckedConstantSize) {
                        this.mConstantWidth = orig.mConstantWidth;
                        this.mConstantHeight = orig.mConstantHeight;
                        this.mConstantMinimumWidth = orig.mConstantMinimumWidth;
                        this.mConstantMinimumHeight = orig.mConstantMinimumHeight;
                        this.mCheckedConstantSize = true;
                    }
                }
                if (orig.mCheckedOpacity) {
                    this.mOpacity = orig.mOpacity;
                    this.mCheckedOpacity = true;
                }
                if (orig.mCheckedStateful) {
                    this.mStateful = orig.mStateful;
                    this.mCheckedStateful = true;
                }
                Drawable[] origDr = orig.mDrawables;
                this.mDrawables = new Drawable[origDr.length];
                this.mNumChildren = orig.mNumChildren;
                SparseArray<Drawable.ConstantState> origDf = orig.mDrawableFutures;
                this.mDrawableFutures = origDf != null ? origDf.clone() : new SparseArray(this.mNumChildren);
                int count = this.mNumChildren;
                for (int i = 0; i < count; ++i) {
                    if (origDr[i] == null) continue;
                    Drawable.ConstantState cs = origDr[i].getConstantState();
                    if (cs != null) {
                        this.mDrawableFutures.put(i, (Object)cs);
                        continue;
                    }
                    this.mDrawables[i] = origDr[i];
                }
            } else {
                this.mDrawables = new Drawable[10];
                this.mNumChildren = 0;
            }
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public final int addChild(Drawable dr) {
            int pos = this.mNumChildren;
            if (pos >= this.mDrawables.length) {
                this.growArray(pos, pos + 10);
            }
            dr.mutate();
            dr.setVisible(false, true);
            dr.setCallback((Drawable.Callback)this.mOwner);
            this.mDrawables[pos] = dr;
            ++this.mNumChildren;
            this.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
            this.invalidateCache();
            this.mConstantPadding = null;
            this.mCheckedPadding = false;
            this.mCheckedConstantSize = false;
            this.mCheckedConstantState = false;
            return pos;
        }

        void invalidateCache() {
            this.mCheckedOpacity = false;
            this.mCheckedStateful = false;
        }

        final int getCapacity() {
            return this.mDrawables.length;
        }

        private void createAllFutures() {
            if (this.mDrawableFutures != null) {
                int futureCount = this.mDrawableFutures.size();
                for (int keyIndex = 0; keyIndex < futureCount; ++keyIndex) {
                    int index = this.mDrawableFutures.keyAt(keyIndex);
                    Drawable.ConstantState cs = (Drawable.ConstantState)this.mDrawableFutures.valueAt(keyIndex);
                    this.mDrawables[index] = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                }
                this.mDrawableFutures = null;
            }
        }

        private Drawable prepareDrawable(Drawable child) {
            if (Build.VERSION.SDK_INT >= 23) {
                DrawableCompat.setLayoutDirection((Drawable)child, (int)this.mLayoutDirection);
            }
            child = child.mutate();
            child.setCallback((Drawable.Callback)this.mOwner);
            return child;
        }

        public final int getChildCount() {
            return this.mNumChildren;
        }

        public final Drawable getChild(int index) {
            int keyIndex;
            Drawable result = this.mDrawables[index];
            if (result != null) {
                return result;
            }
            if (this.mDrawableFutures != null && (keyIndex = this.mDrawableFutures.indexOfKey(index)) >= 0) {
                Drawable prepared;
                Drawable.ConstantState cs = (Drawable.ConstantState)this.mDrawableFutures.valueAt(keyIndex);
                this.mDrawables[index] = prepared = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                this.mDrawableFutures.removeAt(keyIndex);
                if (this.mDrawableFutures.size() == 0) {
                    this.mDrawableFutures = null;
                }
                return prepared;
            }
            return null;
        }

        final boolean setLayoutDirection(int layoutDirection, int currentIndex) {
            boolean changed = false;
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < count; ++i) {
                if (drawables[i] == null) continue;
                boolean childChanged = false;
                if (Build.VERSION.SDK_INT >= 23) {
                    childChanged = DrawableCompat.setLayoutDirection((Drawable)drawables[i], (int)layoutDirection);
                }
                if (i != currentIndex) continue;
                changed = childChanged;
            }
            this.mLayoutDirection = layoutDirection;
            return changed;
        }

        final void updateDensity(Resources res) {
            if (res != null) {
                this.mSourceRes = res;
                int targetDensity = DrawableContainerCompat.resolveDensity(res, this.mDensity);
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                if (sourceDensity != targetDensity) {
                    this.mCheckedConstantSize = false;
                    this.mCheckedPadding = false;
                }
            }
        }

        @RequiresApi(value=21)
        final void applyTheme(Resources.Theme theme) {
            if (theme != null) {
                this.createAllFutures();
                int count = this.mNumChildren;
                Drawable[] drawables = this.mDrawables;
                for (int i = 0; i < count; ++i) {
                    if (drawables[i] == null || !DrawableCompat.canApplyTheme((Drawable)drawables[i])) continue;
                    DrawableCompat.applyTheme((Drawable)drawables[i], (Resources.Theme)theme);
                    this.mChildrenChangingConfigurations |= drawables[i].getChangingConfigurations();
                }
                this.updateDensity(Api21Impl.getResources(theme));
            }
        }

        @RequiresApi(value=21)
        public boolean canApplyTheme() {
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < count; ++i) {
                Drawable.ConstantState future;
                Drawable d = drawables[i];
                if (!(d != null ? DrawableCompat.canApplyTheme((Drawable)d) : (future = (Drawable.ConstantState)this.mDrawableFutures.get(i)) != null && Api21Impl.canApplyTheme(future))) continue;
                return true;
            }
            return false;
        }

        void mutate() {
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < count; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].mutate();
            }
            this.mMutated = true;
        }

        final void clearMutated() {
            this.mMutated = false;
        }

        public final void setVariablePadding(boolean variable) {
            this.mVariablePadding = variable;
        }

        public final Rect getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null || this.mCheckedPadding) {
                return this.mConstantPadding;
            }
            this.createAllFutures();
            Rect r = null;
            Rect t = new Rect();
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < count; ++i) {
                if (!drawables[i].getPadding(t)) continue;
                if (r == null) {
                    r = new Rect(0, 0, 0, 0);
                }
                if (t.left > r.left) {
                    r.left = t.left;
                }
                if (t.top > r.top) {
                    r.top = t.top;
                }
                if (t.right > r.right) {
                    r.right = t.right;
                }
                if (t.bottom <= r.bottom) continue;
                r.bottom = t.bottom;
            }
            this.mCheckedPadding = true;
            this.mConstantPadding = r;
            return this.mConstantPadding;
        }

        public final void setConstantSize(boolean constant) {
            this.mConstantSize = constant;
        }

        public final boolean isConstantSize() {
            return this.mConstantSize;
        }

        public final int getConstantWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        public final int getConstantHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        public final int getConstantMinimumWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        public final int getConstantMinimumHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        protected void computeConstantSize() {
            this.mCheckedConstantSize = true;
            this.createAllFutures();
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            this.mConstantHeight = -1;
            this.mConstantWidth = -1;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            for (int i = 0; i < count; ++i) {
                Drawable dr = drawables[i];
                int s = dr.getIntrinsicWidth();
                if (s > this.mConstantWidth) {
                    this.mConstantWidth = s;
                }
                if ((s = dr.getIntrinsicHeight()) > this.mConstantHeight) {
                    this.mConstantHeight = s;
                }
                if ((s = dr.getMinimumWidth()) > this.mConstantMinimumWidth) {
                    this.mConstantMinimumWidth = s;
                }
                if ((s = dr.getMinimumHeight()) <= this.mConstantMinimumHeight) continue;
                this.mConstantMinimumHeight = s;
            }
        }

        public final void setEnterFadeDuration(int duration) {
            this.mEnterFadeDuration = duration;
        }

        public final int getEnterFadeDuration() {
            return this.mEnterFadeDuration;
        }

        public final void setExitFadeDuration(int duration) {
            this.mExitFadeDuration = duration;
        }

        public final int getExitFadeDuration() {
            return this.mExitFadeDuration;
        }

        public final int getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            this.createAllFutures();
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            int op = count > 0 ? drawables[0].getOpacity() : -2;
            for (int i = 1; i < count; ++i) {
                op = Drawable.resolveOpacity((int)op, (int)drawables[i].getOpacity());
            }
            this.mOpacity = op;
            this.mCheckedOpacity = true;
            return op;
        }

        public final boolean isStateful() {
            if (this.mCheckedStateful) {
                return this.mStateful;
            }
            this.createAllFutures();
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            boolean isStateful = false;
            for (int i = 0; i < count; ++i) {
                if (!drawables[i].isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mStateful = isStateful;
            this.mCheckedStateful = true;
            return isStateful;
        }

        public void growArray(int oldSize, int newSize) {
            Drawable[] newDrawables = new Drawable[newSize];
            if (this.mDrawables != null) {
                System.arraycopy(this.mDrawables, 0, newDrawables, 0, oldSize);
            }
            this.mDrawables = newDrawables;
        }

        public boolean canConstantState() {
            if (this.mCheckedConstantState) {
                return this.mCanConstantState;
            }
            this.createAllFutures();
            this.mCheckedConstantState = true;
            int count = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < count; ++i) {
                if (drawables[i].getConstantState() != null) continue;
                this.mCanConstantState = false;
                return false;
            }
            this.mCanConstantState = true;
            return true;
        }
    }
}

