/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.Menu;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialToolbar
extends Toolbar {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Toolbar;
    private static final ImageView.ScaleType[] LOGO_SCALE_TYPE_ARRAY = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    @Nullable
    private Integer navigationIconTint;
    private boolean titleCentered;
    private boolean subtitleCentered;
    @Nullable
    private ImageView.ScaleType logoScaleType;
    @Nullable
    private Boolean logoAdjustViewBounds;

    public MaterialToolbar(@NonNull Context context) {
        this(context, null);
    }

    public MaterialToolbar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.toolbarStyle);
    }

    public MaterialToolbar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialToolbar, defStyleAttr, DEF_STYLE_RES, new int[0]);
        if (a.hasValue(R.styleable.MaterialToolbar_navigationIconTint)) {
            this.setNavigationIconTint(a.getColor(R.styleable.MaterialToolbar_navigationIconTint, -1));
        }
        this.titleCentered = a.getBoolean(R.styleable.MaterialToolbar_titleCentered, false);
        this.subtitleCentered = a.getBoolean(R.styleable.MaterialToolbar_subtitleCentered, false);
        int index = a.getInt(R.styleable.MaterialToolbar_logoScaleType, -1);
        if (index >= 0 && index < LOGO_SCALE_TYPE_ARRAY.length) {
            this.logoScaleType = LOGO_SCALE_TYPE_ARRAY[index];
        }
        if (a.hasValue(R.styleable.MaterialToolbar_logoAdjustViewBounds)) {
            this.logoAdjustViewBounds = a.getBoolean(R.styleable.MaterialToolbar_logoAdjustViewBounds, false);
        }
        a.recycle();
        this.initBackground(context);
    }

    public void inflateMenu(int i) {
        Menu menu = this.getMenu();
        if (menu instanceof MenuBuilder) {
            ((MenuBuilder)menu).stopDispatchingItemsChanged();
        }
        super.inflateMenu(i);
        if (menu instanceof MenuBuilder) {
            ((MenuBuilder)menu).startDispatchingItemsChanged();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.maybeCenterTitleViews();
        this.updateLogoImageView();
    }

    private void maybeCenterTitleViews() {
        if (!this.titleCentered && !this.subtitleCentered) {
            return;
        }
        TextView titleTextView = ToolbarUtils.getTitleTextView(this);
        TextView subtitleTextView = ToolbarUtils.getSubtitleTextView(this);
        if (titleTextView == null && subtitleTextView == null) {
            return;
        }
        Pair<Integer, Integer> titleBoundLimits = this.calculateTitleBoundLimits(titleTextView, subtitleTextView);
        if (this.titleCentered && titleTextView != null) {
            this.layoutTitleCenteredHorizontally((View)titleTextView, titleBoundLimits);
        }
        if (this.subtitleCentered && subtitleTextView != null) {
            this.layoutTitleCenteredHorizontally((View)subtitleTextView, titleBoundLimits);
        }
    }

    private Pair<Integer, Integer> calculateTitleBoundLimits(@Nullable TextView titleTextView, @Nullable TextView subtitleTextView) {
        int width = this.getMeasuredWidth();
        int midpoint = width / 2;
        int leftLimit = this.getPaddingLeft();
        int rightLimit = width - this.getPaddingRight();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || child == titleTextView || child == subtitleTextView) continue;
            if (child.getRight() < midpoint && child.getRight() > leftLimit) {
                leftLimit = child.getRight();
            }
            if (child.getLeft() <= midpoint || child.getLeft() >= rightLimit) continue;
            rightLimit = child.getLeft();
        }
        return new Pair((Object)leftLimit, (Object)rightLimit);
    }

    private void layoutTitleCenteredHorizontally(View titleView, Pair<Integer, Integer> titleBoundLimits) {
        int rightOverlap;
        int width = this.getMeasuredWidth();
        int titleWidth = titleView.getMeasuredWidth();
        int titleLeft = width / 2 - titleWidth / 2;
        int titleRight = titleLeft + titleWidth;
        int leftOverlap = Math.max((Integer)titleBoundLimits.first - titleLeft, 0);
        int overlap = Math.max(leftOverlap, rightOverlap = Math.max(titleRight - (Integer)titleBoundLimits.second, 0));
        if (overlap > 0) {
            titleWidth = (titleRight -= overlap) - (titleLeft += overlap);
            titleView.measure(View.MeasureSpec.makeMeasureSpec((int)titleWidth, (int)0x40000000), titleView.getMeasuredHeightAndState());
        }
        titleView.layout(titleLeft, titleView.getTop(), titleRight, titleView.getBottom());
    }

    private void updateLogoImageView() {
        ImageView logoImageView = ToolbarUtils.getLogoImageView(this);
        if (logoImageView != null) {
            if (this.logoAdjustViewBounds != null) {
                logoImageView.setAdjustViewBounds(this.logoAdjustViewBounds.booleanValue());
            }
            if (this.logoScaleType != null) {
                logoImageView.setScaleType(this.logoScaleType);
            }
        }
    }

    @Nullable
    public ImageView.ScaleType getLogoScaleType() {
        return this.logoScaleType;
    }

    public void setLogoScaleType(@NonNull ImageView.ScaleType logoScaleType) {
        if (this.logoScaleType != logoScaleType) {
            this.logoScaleType = logoScaleType;
            this.requestLayout();
        }
    }

    public boolean isLogoAdjustViewBounds() {
        return this.logoAdjustViewBounds != null && this.logoAdjustViewBounds != false;
    }

    public void setLogoAdjustViewBounds(boolean logoAdjustViewBounds) {
        if (this.logoAdjustViewBounds == null || this.logoAdjustViewBounds != logoAdjustViewBounds) {
            this.logoAdjustViewBounds = logoAdjustViewBounds;
            this.requestLayout();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        MaterialShapeUtils.setElevation((View)this, elevation);
    }

    public void setNavigationIcon(@Nullable Drawable drawable) {
        super.setNavigationIcon(this.maybeTintNavigationIcon(drawable));
    }

    public void setNavigationIconTint(@ColorInt int navigationIconTint) {
        this.navigationIconTint = navigationIconTint;
        Drawable navigationIcon = this.getNavigationIcon();
        if (navigationIcon != null) {
            this.setNavigationIcon(navigationIcon);
        }
    }

    public void clearNavigationIconTint() {
        this.navigationIconTint = null;
        Drawable navigationIcon = this.getNavigationIcon();
        if (navigationIcon != null) {
            Drawable wrappedNavigationIcon = DrawableCompat.wrap((Drawable)navigationIcon.mutate());
            DrawableCompat.setTintList((Drawable)wrappedNavigationIcon, null);
            this.setNavigationIcon(navigationIcon);
        }
    }

    @ColorInt
    @Nullable
    public Integer getNavigationIconTint() {
        return this.navigationIconTint;
    }

    public void setTitleCentered(boolean titleCentered) {
        if (this.titleCentered != titleCentered) {
            this.titleCentered = titleCentered;
            this.requestLayout();
        }
    }

    public boolean isTitleCentered() {
        return this.titleCentered;
    }

    public void setSubtitleCentered(boolean subtitleCentered) {
        if (this.subtitleCentered != subtitleCentered) {
            this.subtitleCentered = subtitleCentered;
            this.requestLayout();
        }
    }

    public boolean isSubtitleCentered() {
        return this.subtitleCentered;
    }

    private void initBackground(Context context) {
        Drawable background = this.getBackground();
        if (background != null && !(background instanceof ColorDrawable)) {
            return;
        }
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
        int backgroundColor = background != null ? ((ColorDrawable)background).getColor() : 0;
        materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)backgroundColor));
        materialShapeDrawable.initializeElevationOverlay(context);
        materialShapeDrawable.setElevation(ViewCompat.getElevation((View)this));
        ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
    }

    @Nullable
    private Drawable maybeTintNavigationIcon(@Nullable Drawable navigationIcon) {
        if (navigationIcon != null && this.navigationIconTint != null) {
            Drawable wrappedNavigationIcon = DrawableCompat.wrap((Drawable)navigationIcon.mutate());
            DrawableCompat.setTint((Drawable)wrappedNavigationIcon, (int)this.navigationIconTint);
            return wrappedNavigationIcon;
        }
        return navigationIcon;
    }
}

