/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;
import androidx.core.math.MathUtils;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.KeylineState;
import com.google.android.material.carousel.KeylineStateList;
import com.google.android.material.carousel.Maskable;
import com.google.android.material.carousel.MultiBrowseCarouselStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CarouselLayoutManager
extends RecyclerView.LayoutManager
implements Carousel {
    private static final String TAG = "CarouselLayoutManager";
    private int horizontalScrollOffset;
    private int minHorizontalScroll;
    private int maxHorizontalScroll;
    private boolean isDebuggingEnabled = false;
    private final DebugItemDecoration debugItemDecoration = new DebugItemDecoration();
    @NonNull
    private CarouselStrategy carouselStrategy;
    @Nullable
    private KeylineStateList keylineStateList;
    @Nullable
    private KeylineState currentKeylineState;
    private int currentFillStartPosition = 0;

    public CarouselLayoutManager() {
        this.setCarouselStrategy(new MultiBrowseCarouselStrategy());
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void setCarouselStrategy(@NonNull CarouselStrategy carouselStrategy) {
        this.carouselStrategy = carouselStrategy;
        this.keylineStateList = null;
        this.requestLayout();
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        boolean isInitialLoad;
        if (state.getItemCount() <= 0) {
            this.removeAndRecycleAllViews(recycler);
            this.currentFillStartPosition = 0;
            return;
        }
        boolean isRtl = this.isLayoutRtl();
        boolean bl = isInitialLoad = this.keylineStateList == null;
        if (isInitialLoad) {
            View firstChild = recycler.getViewForPosition(0);
            this.measureChildWithMargins(firstChild, 0, 0);
            KeylineState keylineState = this.carouselStrategy.onFirstChildMeasuredWithMargins(this, firstChild);
            this.keylineStateList = KeylineStateList.from(this, isRtl ? KeylineState.reverse(keylineState) : keylineState);
        }
        int startHorizontalScroll = this.calculateStartHorizontalScroll(this.keylineStateList);
        int endHorizontalScroll = this.calculateEndHorizontalScroll(state, this.keylineStateList);
        this.minHorizontalScroll = isRtl ? endHorizontalScroll : startHorizontalScroll;
        int n = this.maxHorizontalScroll = isRtl ? startHorizontalScroll : endHorizontalScroll;
        this.horizontalScrollOffset = isInitialLoad ? startHorizontalScroll : (this.horizontalScrollOffset += CarouselLayoutManager.calculateShouldHorizontallyScrollBy(0, this.horizontalScrollOffset, this.minHorizontalScroll, this.maxHorizontalScroll));
        this.currentFillStartPosition = MathUtils.clamp((int)this.currentFillStartPosition, (int)0, (int)state.getItemCount());
        this.updateCurrentKeylineStateForScrollOffset();
        this.detachAndScrapAttachedViews(recycler);
        this.fill(recycler, state);
    }

    private void fill(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.removeAndRecycleOutOfBoundsViews(recycler);
        if (this.getChildCount() == 0) {
            this.addViewsStart(recycler, this.currentFillStartPosition - 1);
            this.addViewsEnd(recycler, state, this.currentFillStartPosition);
        } else {
            int firstPosition = this.getPosition(this.getChildAt(0));
            int lastPosition = this.getPosition(this.getChildAt(this.getChildCount() - 1));
            this.addViewsStart(recycler, firstPosition - 1);
            this.addViewsEnd(recycler, state, lastPosition + 1);
        }
        this.validateChildOrderIfDebugging();
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.currentFillStartPosition = this.getChildCount() == 0 ? 0 : this.getPosition(this.getChildAt(0));
        this.validateChildOrderIfDebugging();
    }

    private void addViewsStart(RecyclerView.Recycler recycler, int startPosition) {
        int start = this.calculateChildStartForFill(startPosition);
        for (int i = startPosition; i >= 0; --i) {
            ChildCalculations calculations = this.makeChildCalculations(recycler, start, i);
            if (this.isLocOffsetOutOfFillBoundsStart(calculations.locOffset, calculations.range)) break;
            start = this.addStart(start, (int)this.currentKeylineState.getItemSize());
            if (this.isLocOffsetOutOfFillBoundsEnd(calculations.locOffset, calculations.range)) continue;
            this.addAndLayoutView(calculations.child, 0, calculations.locOffset);
        }
    }

    private void addViewsEnd(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition) {
        int start = this.calculateChildStartForFill(startPosition);
        for (int i = startPosition; i < state.getItemCount(); ++i) {
            ChildCalculations calculations = this.makeChildCalculations(recycler, start, i);
            if (this.isLocOffsetOutOfFillBoundsEnd(calculations.locOffset, calculations.range)) break;
            start = this.addEnd(start, (int)this.currentKeylineState.getItemSize());
            if (this.isLocOffsetOutOfFillBoundsStart(calculations.locOffset, calculations.range)) continue;
            this.addAndLayoutView(calculations.child, -1, calculations.locOffset);
        }
    }

    private void logChildrenIfDebugging() {
        if (!this.isDebuggingEnabled) {
            return;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"internal representation of views on the screen");
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                float centerX = this.getDecoratedCenterXWithMargins(child);
                Log.d((String)TAG, (String)("item position " + this.getPosition(child) + ", center:" + centerX + ", child index:" + i));
            }
            Log.d((String)TAG, (String)"==============");
        }
    }

    private void validateChildOrderIfDebugging() {
        if (!this.isDebuggingEnabled || this.getChildCount() < 1) {
            return;
        }
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            int nextPos;
            int currPos = this.getPosition(this.getChildAt(i));
            if (currPos <= (nextPos = this.getPosition(this.getChildAt(i + 1)))) continue;
            this.logChildrenIfDebugging();
            throw new IllegalStateException("Detected invalid child order. Child at index [" + i + "] had adapter position [" + currPos + "] and child at index [" + (i + 1) + "] had adapter position [" + nextPos + "].");
        }
    }

    private ChildCalculations makeChildCalculations(RecyclerView.Recycler recycler, float start, int position) {
        float halfItemSize = this.currentKeylineState.getItemSize() / 2.0f;
        View child = recycler.getViewForPosition(position);
        this.measureChildWithMargins(child, 0, 0);
        int centerX = this.addEnd((int)start, (int)halfItemSize);
        KeylineRange range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), centerX, false);
        float offsetCx = this.calculateChildOffsetCenterForLocation(child, centerX, range);
        this.updateChildMaskForLocation(child, centerX, range);
        return new ChildCalculations(child, offsetCx, range);
    }

    private void addAndLayoutView(View child, int index, float offsetCx) {
        float halfItemSize = this.currentKeylineState.getItemSize() / 2.0f;
        this.addView(child, index);
        this.layoutDecoratedWithMargins(child, (int)(offsetCx - halfItemSize), this.getParentTop(), (int)(offsetCx + halfItemSize), this.getParentBottom());
    }

    private boolean isLocOffsetOutOfFillBoundsStart(float locOffset, KeylineRange range) {
        float maskedSize = this.getMaskedItemSizeForLocOffset(locOffset, range);
        int maskedEnd = this.addEnd((int)locOffset, (int)(maskedSize / 2.0f));
        return this.isLayoutRtl() ? maskedEnd > this.getContainerWidth() : maskedEnd < 0;
    }

    private boolean isLocOffsetOutOfFillBoundsEnd(float locOffset, KeylineRange range) {
        float maskedSize = this.getMaskedItemSizeForLocOffset(locOffset, range);
        int maskedStart = this.addStart((int)locOffset, (int)(maskedSize / 2.0f));
        return this.isLayoutRtl() ? maskedStart < 0 : maskedStart > this.getContainerWidth();
    }

    public void getDecoratedBoundsWithMargins(@NonNull View view, @NonNull Rect outBounds) {
        super.getDecoratedBoundsWithMargins(view, outBounds);
        float centerX = outBounds.centerX();
        float maskedSize = this.getMaskedItemSizeForLocOffset(centerX, CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), centerX, true));
        float delta = ((float)outBounds.width() - maskedSize) / 2.0f;
        outBounds.set((int)((float)outBounds.left + delta), outBounds.top, (int)((float)outBounds.right - delta), outBounds.bottom);
    }

    private float getDecoratedCenterXWithMargins(View child) {
        Rect bounds = new Rect();
        super.getDecoratedBoundsWithMargins(child, bounds);
        return bounds.centerX();
    }

    private void removeAndRecycleOutOfBoundsViews(RecyclerView.Recycler recycler) {
        KeylineRange range;
        View child;
        float centerX;
        while (this.getChildCount() > 0 && this.isLocOffsetOutOfFillBoundsStart(centerX = this.getDecoratedCenterXWithMargins(child = this.getChildAt(0)), range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), centerX, true))) {
            this.removeAndRecycleView(child, recycler);
        }
        while (this.getChildCount() - 1 >= 0 && this.isLocOffsetOutOfFillBoundsEnd(centerX = this.getDecoratedCenterXWithMargins(child = this.getChildAt(this.getChildCount() - 1)), range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), centerX, true))) {
            this.removeAndRecycleView(child, recycler);
        }
    }

    private static KeylineRange getSurroundingKeylineRange(List<KeylineState.Keyline> keylines, float location, boolean isOffset) {
        int leftMinDistanceIndex = -1;
        float leftMinDistance = Float.MAX_VALUE;
        int leftMostIndex = -1;
        float leftMostX = Float.MAX_VALUE;
        int rightMinDistanceIndex = -1;
        float rightMinDistance = Float.MAX_VALUE;
        int rightMostIndex = -1;
        float rightMostX = -3.4028235E38f;
        for (int i = 0; i < keylines.size(); ++i) {
            KeylineState.Keyline keyline = keylines.get(i);
            float currentLoc = isOffset ? keyline.locOffset : keyline.loc;
            float delta = Math.abs(currentLoc - location);
            if (currentLoc <= location && delta <= leftMinDistance) {
                leftMinDistance = delta;
                leftMinDistanceIndex = i;
            }
            if (currentLoc > location && delta <= rightMinDistance) {
                rightMinDistance = delta;
                rightMinDistanceIndex = i;
            }
            if (currentLoc <= leftMostX) {
                leftMostIndex = i;
                leftMostX = currentLoc;
            }
            if (!(currentLoc > rightMostX)) continue;
            rightMostIndex = i;
            rightMostX = currentLoc;
        }
        if (leftMinDistanceIndex == -1) {
            leftMinDistanceIndex = leftMostIndex;
        }
        if (rightMinDistanceIndex == -1) {
            rightMinDistanceIndex = rightMostIndex;
        }
        return new KeylineRange(keylines.get(leftMinDistanceIndex), keylines.get(rightMinDistanceIndex));
    }

    private void updateCurrentKeylineStateForScrollOffset() {
        this.currentKeylineState = this.maxHorizontalScroll <= this.minHorizontalScroll ? (this.isLayoutRtl() ? this.keylineStateList.getRightState() : this.keylineStateList.getLeftState()) : this.keylineStateList.getShiftedState(this.horizontalScrollOffset, this.minHorizontalScroll, this.maxHorizontalScroll);
        this.debugItemDecoration.setKeylines(this.currentKeylineState.getKeylines());
    }

    private static int calculateShouldHorizontallyScrollBy(int dx, int currentHorizontalScroll, int minHorizontalScroll, int maxHorizontalScroll) {
        int targetHorizontalScroll = currentHorizontalScroll + dx;
        if (targetHorizontalScroll < minHorizontalScroll) {
            return minHorizontalScroll - currentHorizontalScroll;
        }
        if (targetHorizontalScroll > maxHorizontalScroll) {
            return maxHorizontalScroll - currentHorizontalScroll;
        }
        return dx;
    }

    private int calculateStartHorizontalScroll(KeylineStateList stateList) {
        boolean isRtl = this.isLayoutRtl();
        KeylineState startState = isRtl ? stateList.getRightState() : stateList.getLeftState();
        KeylineState.Keyline startFocalKeyline = isRtl ? startState.getLastFocalKeyline() : startState.getFirstFocalKeyline();
        float firstItemDistanceFromStart = this.getPaddingStart() * (isRtl ? 1 : -1);
        int firstItemStart = this.addStart((int)startFocalKeyline.loc, (int)(startState.getItemSize() / 2.0f));
        return (int)(firstItemDistanceFromStart + (float)this.getParentStart() - (float)firstItemStart);
    }

    private int calculateEndHorizontalScroll(RecyclerView.State state, KeylineStateList stateList) {
        boolean isRtl = this.isLayoutRtl();
        KeylineState endState = isRtl ? stateList.getLeftState() : stateList.getRightState();
        KeylineState.Keyline endFocalKeyline = isRtl ? endState.getFirstFocalKeyline() : endState.getLastFocalKeyline();
        float lastItemDistanceFromFirstItem = ((float)(state.getItemCount() - 1) * endState.getItemSize() + (float)this.getPaddingEnd()) * (isRtl ? -1.0f : 1.0f);
        float endFocalLocDistanceFromStart = endFocalKeyline.loc - (float)this.getParentStart();
        float endFocalLocDistanceFromEnd = (float)this.getParentEnd() - endFocalKeyline.loc;
        if (Math.abs(endFocalLocDistanceFromStart) > Math.abs(lastItemDistanceFromFirstItem)) {
            return 0;
        }
        return (int)(lastItemDistanceFromFirstItem - endFocalLocDistanceFromStart + endFocalLocDistanceFromEnd);
    }

    private int calculateChildStartForFill(int startPosition) {
        float scrollOffset = this.getParentStart() - this.horizontalScrollOffset;
        float positionOffset = this.currentKeylineState.getItemSize() * (float)startPosition;
        return this.addEnd((int)scrollOffset, (int)positionOffset);
    }

    private float calculateChildOffsetCenterForLocation(View child, float childCenterLocation, KeylineRange range) {
        float offsetCx = AnimationUtils.lerp(range.left.locOffset, range.right.locOffset, range.left.loc, range.right.loc, childCenterLocation);
        if (range.right == this.currentKeylineState.getFirstKeyline() || range.left == this.currentKeylineState.getLastKeyline()) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            float horizontalMarginMask = (float)(lp.rightMargin + lp.leftMargin) / this.currentKeylineState.getItemSize();
            float outOfBoundOffset = (childCenterLocation - range.right.loc) * (1.0f - range.right.mask + horizontalMarginMask);
            offsetCx += outOfBoundOffset;
        }
        return offsetCx;
    }

    private float getMaskedItemSizeForLocOffset(float locOffset, KeylineRange range) {
        return AnimationUtils.lerp(range.left.maskedItemSize, range.right.maskedItemSize, range.left.locOffset, range.right.locOffset, locOffset);
    }

    private void updateChildMaskForLocation(View child, float childCenterLocation, KeylineRange range) {
        if (child instanceof Maskable) {
            float maskProgress = AnimationUtils.lerp(range.left.mask, range.right.mask, range.left.loc, range.right.loc, childCenterLocation);
            ((Maskable)child).setMaskXPercentage(maskProgress);
        }
    }

    public void measureChildWithMargins(@NonNull View child, int widthUsed, int heightUsed) {
        if (!(child instanceof Maskable)) {
            throw new IllegalStateException("All children of a RecyclerView using CarouselLayoutManager must use MaskableFrameLayout as their root ViewGroup.");
        }
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
        Rect insets = new Rect();
        this.calculateItemDecorationsForChild(child, insets);
        float childWidthDimension = this.keylineStateList != null ? this.keylineStateList.getDefaultState().getItemSize() : (float)lp.width;
        int widthSpec = CarouselLayoutManager.getChildMeasureSpec((int)this.getWidth(), (int)this.getWidthMode(), (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right)), (int)((int)childWidthDimension), (boolean)this.canScrollHorizontally());
        int heightSpec = CarouselLayoutManager.getChildMeasureSpec((int)this.getHeight(), (int)this.getHeightMode(), (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom)), (int)lp.height, (boolean)this.canScrollVertically());
        child.measure(widthSpec, heightSpec);
    }

    private int getParentStart() {
        return this.isLayoutRtl() ? this.getWidth() : 0;
    }

    private int getParentEnd() {
        return this.isLayoutRtl() ? 0 : this.getWidth();
    }

    private int getParentTop() {
        return this.getPaddingTop();
    }

    private int getParentBottom() {
        return this.getHeight() - this.getPaddingBottom();
    }

    @Override
    public int getContainerWidth() {
        return this.getWidth();
    }

    private boolean isLayoutRtl() {
        return this.getLayoutDirection() == 1;
    }

    private int addStart(int value, int amount) {
        return this.isLayoutRtl() ? value + amount : value - amount;
    }

    private int addEnd(int value, int amount) {
        return this.isLayoutRtl() ? value - amount : value + amount;
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.getChildCount() > 0) {
            event.setFromIndex(this.getPosition(this.getChildAt(0)));
            event.setToIndex(this.getPosition(this.getChildAt(this.getChildCount() - 1)));
        }
    }

    private int getScrollOffsetForPosition(KeylineState keylineState, int position) {
        if (this.isLayoutRtl()) {
            return (int)((float)this.getContainerWidth() - keylineState.getLastFocalKeyline().loc - (float)position * keylineState.getItemSize() - keylineState.getItemSize() / 2.0f);
        }
        return (int)((float)position * keylineState.getItemSize() - keylineState.getFirstFocalKeyline().loc + keylineState.getItemSize() / 2.0f);
    }

    public void scrollToPosition(int position) {
        if (this.keylineStateList == null) {
            return;
        }
        this.horizontalScrollOffset = this.getScrollOffsetForPosition(this.keylineStateList.getDefaultState(), position);
        this.currentFillStartPosition = MathUtils.clamp((int)position, (int)0, (int)Math.max(0, this.getItemCount() - 1));
        this.updateCurrentKeylineStateForScrollOffset();
        this.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            @Nullable
            public PointF computeScrollVectorForPosition(int targetPosition) {
                if (CarouselLayoutManager.this.keylineStateList == null) {
                    return null;
                }
                float targetScrollOffset = CarouselLayoutManager.this.getScrollOffsetForPosition(CarouselLayoutManager.this.keylineStateList.getDefaultState(), targetPosition);
                return new PointF(targetScrollOffset - (float)CarouselLayoutManager.this.horizontalScrollOffset, 0.0f);
            }

            public int calculateDxToMakeVisible(View view, int snapPreference) {
                float targetScrollOffset = CarouselLayoutManager.this.getScrollOffsetForPosition(CarouselLayoutManager.this.keylineStateList.getDefaultState(), CarouselLayoutManager.this.getPosition(view));
                return (int)((float)CarouselLayoutManager.this.horizontalScrollOffset - targetScrollOffset);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    public boolean canScrollHorizontally() {
        return true;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.scrollBy(dx, recycler, state) : 0;
    }

    public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
        if (this.keylineStateList == null) {
            return false;
        }
        int offsetForChild = this.getScrollOffsetForPosition(this.keylineStateList.getDefaultState(), this.getPosition(child));
        int dx = offsetForChild - this.horizontalScrollOffset;
        if (!focusedChildVisible && dx != 0) {
            parent.scrollBy(dx, 0);
            return true;
        }
        return false;
    }

    private int scrollBy(int distance, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || distance == 0) {
            return 0;
        }
        int scrolledBy = CarouselLayoutManager.calculateShouldHorizontallyScrollBy(distance, this.horizontalScrollOffset, this.minHorizontalScroll, this.maxHorizontalScroll);
        this.horizontalScrollOffset += scrolledBy;
        this.updateCurrentKeylineStateForScrollOffset();
        float halfItemSize = this.currentKeylineState.getItemSize() / 2.0f;
        int startPosition = this.getPosition(this.getChildAt(0));
        int start = this.calculateChildStartForFill(startPosition);
        Rect boundsRect = new Rect();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            this.offsetChildLeftAndRight(child, start, halfItemSize, boundsRect);
            start = this.addEnd(start, (int)this.currentKeylineState.getItemSize());
        }
        this.fill(recycler, state);
        return scrolledBy;
    }

    private void offsetChildLeftAndRight(View child, float startOffset, float halfItemSize, Rect boundsRect) {
        int centerX = this.addEnd((int)startOffset, (int)halfItemSize);
        KeylineRange range = CarouselLayoutManager.getSurroundingKeylineRange(this.currentKeylineState.getKeylines(), centerX, false);
        float offsetCx = this.calculateChildOffsetCenterForLocation(child, centerX, range);
        this.updateChildMaskForLocation(child, centerX, range);
        super.getDecoratedBoundsWithMargins(child, boundsRect);
        float actualCx = (float)boundsRect.left + halfItemSize;
        child.offsetLeftAndRight((int)(offsetCx - actualCx));
    }

    public int computeHorizontalScrollOffset(@NonNull RecyclerView.State state) {
        return this.horizontalScrollOffset;
    }

    public int computeHorizontalScrollExtent(@NonNull RecyclerView.State state) {
        return (int)this.keylineStateList.getDefaultState().getItemSize();
    }

    public int computeHorizontalScrollRange(@NonNull RecyclerView.State state) {
        return this.maxHorizontalScroll - this.minHorizontalScroll;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDebuggingEnabled(@NonNull RecyclerView recyclerView, boolean enabled) {
        this.isDebuggingEnabled = enabled;
        recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.debugItemDecoration);
        if (enabled) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.debugItemDecoration);
        }
        recyclerView.invalidateItemDecorations();
    }

    private static class DebugItemDecoration
    extends RecyclerView.ItemDecoration {
        private final Paint linePaint = new Paint();
        private List<KeylineState.Keyline> keylines = Collections.unmodifiableList(new ArrayList());

        DebugItemDecoration() {
            this.linePaint.setStrokeWidth(5.0f);
            this.linePaint.setColor(-65281);
        }

        void setKeylines(List<KeylineState.Keyline> keylines) {
            this.keylines = Collections.unmodifiableList(keylines);
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            super.onDrawOver(c, parent, state);
            this.linePaint.setStrokeWidth(parent.getResources().getDimension(R.dimen.m3_carousel_debug_keyline_width));
            for (KeylineState.Keyline keyline : this.keylines) {
                this.linePaint.setColor(ColorUtils.blendARGB((int)-65281, (int)-16776961, (float)keyline.mask));
                c.drawLine(keyline.locOffset, (float)((CarouselLayoutManager)parent.getLayoutManager()).getParentTop(), keyline.locOffset, (float)((CarouselLayoutManager)parent.getLayoutManager()).getParentBottom(), this.linePaint);
            }
        }
    }

    private static class KeylineRange {
        final KeylineState.Keyline left;
        final KeylineState.Keyline right;

        KeylineRange(KeylineState.Keyline left, KeylineState.Keyline right) {
            Preconditions.checkArgument((left.loc <= right.loc ? 1 : 0) != 0);
            this.left = left;
            this.right = right;
        }
    }

    private static final class ChildCalculations {
        View child;
        float locOffset;
        KeylineRange range;

        ChildCalculations(View child, float locOffset, KeylineRange range) {
            this.child = child;
            this.locOffset = locOffset;
            this.range = range;
        }
    }
}

