/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.KeylineState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class KeylineStateList {
    private static final int NO_INDEX = -1;
    private final KeylineState defaultState;
    private final List<KeylineState> leftStateSteps;
    private final List<KeylineState> rightStateSteps;
    private final float[] leftStateStepsInterpolationPoints;
    private final float[] rightStateStepsInterpolationPoints;
    private final float leftShiftRange;
    private final float rightShiftRange;

    private KeylineStateList(KeylineState defaultState, List<KeylineState> leftStateSteps, List<KeylineState> rightStateSteps) {
        this.defaultState = defaultState;
        this.leftStateSteps = Collections.unmodifiableList(leftStateSteps);
        this.rightStateSteps = Collections.unmodifiableList(rightStateSteps);
        this.leftShiftRange = leftStateSteps.get((int)(leftStateSteps.size() - 1)).getFirstKeyline().loc - defaultState.getFirstKeyline().loc;
        this.rightShiftRange = defaultState.getLastKeyline().loc - rightStateSteps.get((int)(rightStateSteps.size() - 1)).getLastKeyline().loc;
        this.leftStateStepsInterpolationPoints = KeylineStateList.getStateStepInterpolationPoints(this.leftShiftRange, leftStateSteps, true);
        this.rightStateStepsInterpolationPoints = KeylineStateList.getStateStepInterpolationPoints(this.rightShiftRange, rightStateSteps, false);
    }

    static KeylineStateList from(Carousel carousel, KeylineState state) {
        return new KeylineStateList(state, KeylineStateList.getStateStepsLeft(state), KeylineStateList.getStateStepsRight(carousel, state));
    }

    KeylineState getDefaultState() {
        return this.defaultState;
    }

    KeylineState getLeftState() {
        return this.leftStateSteps.get(this.leftStateSteps.size() - 1);
    }

    KeylineState getRightState() {
        return this.rightStateSteps.get(this.rightStateSteps.size() - 1);
    }

    public KeylineState getShiftedState(float scrollOffset, float minScrollOffset, float maxScrollOffset) {
        float leftShiftOffset = minScrollOffset + this.leftShiftRange;
        float rightShiftOffset = maxScrollOffset - this.rightShiftRange;
        if (scrollOffset < leftShiftOffset) {
            float interpolation = AnimationUtils.lerp(1.0f, 0.0f, minScrollOffset, leftShiftOffset, scrollOffset);
            return KeylineStateList.lerp(this.leftStateSteps, interpolation, this.leftStateStepsInterpolationPoints);
        }
        if (scrollOffset > rightShiftOffset) {
            float interpolation = AnimationUtils.lerp(0.0f, 1.0f, rightShiftOffset, maxScrollOffset, scrollOffset);
            return KeylineStateList.lerp(this.rightStateSteps, interpolation, this.rightStateStepsInterpolationPoints);
        }
        return this.defaultState;
    }

    private static KeylineState lerp(List<KeylineState> stateSteps, float interpolation, float[] stateStepsInterpolationPoints) {
        int numberOfSteps = stateSteps.size();
        float lowerBounds = stateStepsInterpolationPoints[0];
        for (int i = 1; i < numberOfSteps; ++i) {
            float upperBounds = stateStepsInterpolationPoints[i];
            if (interpolation <= upperBounds) {
                int fromIndex = i - 1;
                int toIndex = i;
                float steppedProgress = AnimationUtils.lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation);
                return KeylineState.lerp(stateSteps.get(fromIndex), stateSteps.get(toIndex), steppedProgress);
            }
            lowerBounds = upperBounds;
        }
        return stateSteps.get(0);
    }

    private static float[] getStateStepInterpolationPoints(float shiftRange, List<KeylineState> stateSteps, boolean isShiftingLeft) {
        int numberOfSteps = stateSteps.size();
        float[] stateStepsInterpolationPoints = new float[numberOfSteps];
        for (int i = 1; i < numberOfSteps; ++i) {
            KeylineState prevState = stateSteps.get(i - 1);
            KeylineState currState = stateSteps.get(i);
            float distanceShifted = isShiftingLeft ? currState.getFirstKeyline().loc - prevState.getFirstKeyline().loc : prevState.getLastKeyline().loc - currState.getLastKeyline().loc;
            float stepProgress = distanceShifted / shiftRange;
            stateStepsInterpolationPoints[i] = i == numberOfSteps - 1 ? 1.0f : stateStepsInterpolationPoints[i - 1] + stepProgress;
        }
        return stateStepsInterpolationPoints;
    }

    private static boolean isFirstFocalItemAtLeftOfContainer(KeylineState state) {
        float firstFocalItemLeft = state.getFirstFocalKeyline().locOffset - state.getFirstFocalKeyline().maskedItemSize / 2.0f;
        return firstFocalItemLeft <= 0.0f || state.getFirstFocalKeyline() == state.getFirstKeyline();
    }

    private static List<KeylineState> getStateStepsLeft(KeylineState defaultState) {
        ArrayList<KeylineState> steps = new ArrayList<KeylineState>();
        steps.add(defaultState);
        int firstInBoundsKeylineIndex = KeylineStateList.findFirstInBoundsKeylineIndex(defaultState);
        if (KeylineStateList.isFirstFocalItemAtLeftOfContainer(defaultState) || firstInBoundsKeylineIndex == -1) {
            return steps;
        }
        int start = firstInBoundsKeylineIndex;
        int end = defaultState.getFirstFocalKeylineIndex() - 1;
        int numberOfSteps = end - start;
        float originalStart = defaultState.getFirstKeyline().locOffset - defaultState.getFirstKeyline().maskedItemSize / 2.0f;
        for (int i = 0; i <= numberOfSteps; ++i) {
            KeylineState prevStepState = (KeylineState)steps.get(steps.size() - 1);
            int itemOrigIndex = start + i;
            int dstIndex = defaultState.getKeylines().size() - 1;
            if (itemOrigIndex - 1 >= 0) {
                float originalAdjacentMaskLeft = defaultState.getKeylines().get((int)(itemOrigIndex - 1)).mask;
                dstIndex = KeylineStateList.findFirstIndexAfterLastFocalKeylineWithMask(prevStepState, originalAdjacentMaskLeft) - 1;
            }
            int newFirstFocalIndex = defaultState.getFirstFocalKeylineIndex() - i - 1;
            int newLastFocalIndex = defaultState.getLastFocalKeylineIndex() - i - 1;
            KeylineState shifted = KeylineStateList.moveKeylineAndCreateKeylineState(prevStepState, firstInBoundsKeylineIndex, dstIndex, originalStart, newFirstFocalIndex, newLastFocalIndex);
            steps.add(shifted);
        }
        return steps;
    }

    private static boolean isLastFocalItemAtRightOfContainer(Carousel carousel, KeylineState state) {
        float firstFocalItemRight = state.getLastFocalKeyline().locOffset + state.getLastFocalKeyline().maskedItemSize / 2.0f;
        return firstFocalItemRight >= (float)carousel.getContainerWidth() || state.getLastFocalKeyline() == state.getLastKeyline();
    }

    private static List<KeylineState> getStateStepsRight(Carousel carousel, KeylineState defaultState) {
        ArrayList<KeylineState> steps = new ArrayList<KeylineState>();
        steps.add(defaultState);
        int lastInBoundsKeylineIndex = KeylineStateList.findLastInBoundsKeylineIndex(carousel, defaultState);
        if (KeylineStateList.isLastFocalItemAtRightOfContainer(carousel, defaultState) || lastInBoundsKeylineIndex == -1) {
            return steps;
        }
        int start = defaultState.getLastFocalKeylineIndex();
        int end = lastInBoundsKeylineIndex;
        int numberOfSteps = end - start;
        float originalStart = defaultState.getFirstKeyline().locOffset - defaultState.getFirstKeyline().maskedItemSize / 2.0f;
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineState prevStepState = (KeylineState)steps.get(steps.size() - 1);
            int itemOrigIndex = end - i;
            int dstIndex = 0;
            if (itemOrigIndex + 1 < defaultState.getKeylines().size()) {
                float originalAdjacentMaskRight = defaultState.getKeylines().get((int)(itemOrigIndex + 1)).mask;
                dstIndex = KeylineStateList.findLastIndexBeforeFirstFocalKeylineWithMask(prevStepState, originalAdjacentMaskRight) + 1;
            }
            int newFirstFocalIndex = defaultState.getFirstFocalKeylineIndex() + i + 1;
            int newLastFocalIndex = defaultState.getLastFocalKeylineIndex() + i + 1;
            KeylineState shifted = KeylineStateList.moveKeylineAndCreateKeylineState(prevStepState, lastInBoundsKeylineIndex, dstIndex, originalStart, newFirstFocalIndex, newLastFocalIndex);
            steps.add(shifted);
        }
        return steps;
    }

    private static KeylineState moveKeylineAndCreateKeylineState(KeylineState state, int keylineSrcIndex, int keylineDstIndex, float startOffset, int newFirstFocalIndex, int newLastFocalIndex) {
        ArrayList<KeylineState.Keyline> tmpKeylines = new ArrayList<KeylineState.Keyline>(state.getKeylines());
        KeylineState.Keyline item = (KeylineState.Keyline)tmpKeylines.remove(keylineSrcIndex);
        tmpKeylines.add(keylineDstIndex, item);
        KeylineState.Builder builder = new KeylineState.Builder(state.getItemSize());
        for (int j = 0; j < tmpKeylines.size(); ++j) {
            KeylineState.Keyline k = (KeylineState.Keyline)tmpKeylines.get(j);
            float offset = startOffset + k.maskedItemSize / 2.0f;
            boolean isFocal = j >= newFirstFocalIndex && j <= newLastFocalIndex;
            builder.addKeyline(offset, k.mask, k.maskedItemSize, isFocal);
            startOffset += k.maskedItemSize;
        }
        return builder.build();
    }

    private static int findFirstIndexAfterLastFocalKeylineWithMask(KeylineState state, float mask) {
        int focalEndIndex;
        for (int i = focalEndIndex = state.getLastFocalKeylineIndex(); i < state.getKeylines().size(); ++i) {
            if (mask != state.getKeylines().get((int)i).mask) continue;
            return i;
        }
        return state.getKeylines().size() - 1;
    }

    private static int findLastIndexBeforeFirstFocalKeylineWithMask(KeylineState state, float mask) {
        int focalStartIndex;
        for (int i = focalStartIndex = state.getFirstFocalKeylineIndex() - 1; i >= 0; --i) {
            if (mask != state.getKeylines().get((int)i).mask) continue;
            return i;
        }
        return 0;
    }

    private static int findFirstInBoundsKeylineIndex(KeylineState state) {
        for (int i = 0; i < state.getKeylines().size(); ++i) {
            if (!(state.getKeylines().get((int)i).locOffset >= 0.0f)) continue;
            return i;
        }
        return -1;
    }

    private static int findLastInBoundsKeylineIndex(Carousel carousel, KeylineState state) {
        for (int i = state.getKeylines().size() - 1; i >= 0; --i) {
            if (!(state.getKeylines().get((int)i).locOffset <= (float)carousel.getContainerWidth())) continue;
            return i;
        }
        return -1;
    }
}

