/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.math.MathUtils;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.canvas.CanvasCompat;
import com.google.android.material.carousel.Maskable;
import com.google.android.material.carousel.OnMaskChangedListener;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.ClampedCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.shape.Shapeable;

public class MaskableFrameLayout
extends FrameLayout
implements Maskable,
Shapeable {
    private float maskXPercentage = 0.0f;
    private final RectF maskRect = new RectF();
    @Nullable
    private OnMaskChangedListener onMaskChangedListener;
    @NonNull
    private ShapeAppearanceModel shapeAppearanceModel;
    private final MaskableDelegate maskableDelegate = this.createMaskableDelegate();
    @Nullable
    private Boolean savedForceCompatClippingEnabled = null;

    public MaskableFrameLayout(@NonNull Context context) {
        this(context, null);
    }

    public MaskableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setShapeAppearanceModel(ShapeAppearanceModel.builder(context, attrs, defStyleAttr, 0, 0).build());
    }

    private MaskableDelegate createMaskableDelegate() {
        if (Build.VERSION.SDK_INT >= 33) {
            return new MaskableDelegateV33((View)this);
        }
        if (Build.VERSION.SDK_INT >= 22) {
            return new MaskableDelegateV22((View)this);
        }
        return new MaskableDelegateV14();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onMaskChanged();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.savedForceCompatClippingEnabled != null) {
            this.maskableDelegate.setForceCompatClippingEnabled((View)this, this.savedForceCompatClippingEnabled);
        }
    }

    protected void onDetachedFromWindow() {
        this.savedForceCompatClippingEnabled = this.maskableDelegate.isForceCompatClippingEnabled();
        this.maskableDelegate.setForceCompatClippingEnabled((View)this, true);
        super.onDetachedFromWindow();
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel.withTransformedCornerSizes(cornerSize -> {
            if (cornerSize instanceof AbsoluteCornerSize) {
                return ClampedCornerSize.createFromCornerSize((AbsoluteCornerSize)cornerSize);
            }
            return cornerSize;
        });
        this.maskableDelegate.onShapeAppearanceChanged((View)this, this.shapeAppearanceModel);
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    @Override
    public void setMaskXPercentage(float percentage) {
        if (this.maskXPercentage != (percentage = MathUtils.clamp((float)percentage, (float)0.0f, (float)1.0f))) {
            this.maskXPercentage = percentage;
            this.onMaskChanged();
        }
    }

    @Override
    public float getMaskXPercentage() {
        return this.maskXPercentage;
    }

    @Override
    @NonNull
    public RectF getMaskRectF() {
        return this.maskRect;
    }

    @Override
    public void setOnMaskChangedListener(@Nullable OnMaskChangedListener onMaskChangedListener) {
        this.onMaskChangedListener = onMaskChangedListener;
    }

    private void onMaskChanged() {
        if (this.getWidth() == 0) {
            return;
        }
        float maskWidth = AnimationUtils.lerp(0.0f, (float)this.getWidth() / 2.0f, 0.0f, 1.0f, this.maskXPercentage);
        this.maskRect.set(maskWidth, 0.0f, (float)this.getWidth() - maskWidth, (float)this.getHeight());
        this.maskableDelegate.onMaskChanged((View)this, this.maskRect);
        if (this.onMaskChangedListener != null) {
            this.onMaskChangedListener.onMaskChanged(this.maskRect);
        }
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setForceCompatClipping(boolean forceCompatClipping) {
        this.maskableDelegate.setForceCompatClippingEnabled((View)this, forceCompatClipping);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        float y;
        float x;
        if (!this.maskRect.isEmpty() && event.getAction() == 0 && !this.maskRect.contains(x = event.getX(), y = event.getY())) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    protected void dispatchDraw(Canvas canvas) {
        this.maskableDelegate.maybeClip(canvas, x$0 -> super.dispatchDraw(x$0));
    }

    @RequiresApi(value=33)
    private static class MaskableDelegateV33
    extends MaskableDelegate {
        MaskableDelegateV33(View view) {
            this.initMaskOutlineProvider(view);
        }

        @Override
        public boolean shouldUseCompatClipping() {
            return this.forceCompatClippingEnabled;
        }

        @Override
        void invalidateClippingMethod(View view) {
            view.setClipToOutline(!this.shouldUseCompatClipping());
            if (this.shouldUseCompatClipping()) {
                view.invalidate();
            } else {
                view.invalidateOutline();
            }
        }

        @DoNotInline
        private void initMaskOutlineProvider(View view) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (!shapePath.isEmpty()) {
                        outline.setPath(shapePath);
                    }
                }
            });
        }
    }

    @RequiresApi(value=22)
    private static class MaskableDelegateV22
    extends MaskableDelegate {
        private boolean isShapeRoundRect = false;

        MaskableDelegateV22(View view) {
            this.initMaskOutlineProvider(view);
        }

        @Override
        public boolean shouldUseCompatClipping() {
            return !this.isShapeRoundRect || this.forceCompatClippingEnabled;
        }

        @Override
        void invalidateClippingMethod(View view) {
            this.updateIsShapeRoundRect();
            view.setClipToOutline(!this.shouldUseCompatClipping());
            if (this.shouldUseCompatClipping()) {
                view.invalidate();
            } else {
                view.invalidateOutline();
            }
        }

        private void updateIsShapeRoundRect() {
            if (!this.maskBounds.isEmpty() && this.shapeAppearanceModel != null) {
                this.isShapeRoundRect = this.shapeAppearanceModel.isRoundRect(this.maskBounds);
            }
        }

        private float getCornerRadiusFromShapeAppearance(@NonNull ShapeAppearanceModel shapeAppearanceModel, @NonNull RectF bounds) {
            return shapeAppearanceModel.getTopRightCornerSize().getCornerSize(bounds);
        }

        @DoNotInline
        private void initMaskOutlineProvider(View view) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (shapeAppearanceModel != null && !maskBounds.isEmpty()) {
                        outline.setRoundRect((int)maskBounds.left, (int)maskBounds.top, (int)maskBounds.right, (int)maskBounds.bottom, this.getCornerRadiusFromShapeAppearance(shapeAppearanceModel, maskBounds));
                    }
                }
            });
        }
    }

    private static class MaskableDelegateV14
    extends MaskableDelegate {
        private MaskableDelegateV14() {
        }

        @Override
        boolean shouldUseCompatClipping() {
            return true;
        }

        @Override
        void invalidateClippingMethod(View view) {
            if (this.shapeAppearanceModel == null || this.maskBounds.isEmpty()) {
                return;
            }
            if (this.shouldUseCompatClipping()) {
                view.invalidate();
            }
        }
    }

    private static abstract class MaskableDelegate {
        boolean forceCompatClippingEnabled = false;
        @Nullable
        ShapeAppearanceModel shapeAppearanceModel;
        RectF maskBounds = new RectF();
        final Path shapePath = new Path();

        private MaskableDelegate() {
        }

        abstract void invalidateClippingMethod(View var1);

        abstract boolean shouldUseCompatClipping();

        boolean isForceCompatClippingEnabled() {
            return this.forceCompatClippingEnabled;
        }

        void setForceCompatClippingEnabled(View view, boolean enabled) {
            if (enabled != this.forceCompatClippingEnabled) {
                this.forceCompatClippingEnabled = enabled;
                this.invalidateClippingMethod(view);
            }
        }

        void onShapeAppearanceChanged(View view, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.updateShapePath();
            this.invalidateClippingMethod(view);
        }

        void onMaskChanged(View view, RectF maskBounds) {
            this.maskBounds = maskBounds;
            this.updateShapePath();
            this.invalidateClippingMethod(view);
        }

        private void updateShapePath() {
            if (!this.maskBounds.isEmpty() && this.shapeAppearanceModel != null) {
                ShapeAppearancePathProvider.getInstance().calculatePath(this.shapeAppearanceModel, 1.0f, this.maskBounds, this.shapePath);
            }
        }

        void maybeClip(Canvas canvas, CanvasCompat.CanvasOperation op) {
            if (this.shouldUseCompatClipping() && !this.shapePath.isEmpty()) {
                canvas.save();
                canvas.clipPath(this.shapePath);
                op.run(canvas);
                canvas.restore();
            } else {
                op.run(canvas);
            }
        }
    }
}

