/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.app.Activity;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.google.android.material.color.DynamicColors;
import com.google.android.material.color.utilities.QuantizerCelebi;
import com.google.android.material.color.utilities.Score;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public class DynamicColorsOptions {
    private static final DynamicColors.Precondition ALWAYS_ALLOW = new DynamicColors.Precondition(){

        @Override
        public boolean shouldApplyDynamicColors(@NonNull Activity activity, int theme) {
            return true;
        }
    };
    private static final DynamicColors.OnAppliedCallback NO_OP_CALLBACK = new DynamicColors.OnAppliedCallback(){

        @Override
        public void onApplied(@NonNull Activity activity) {
        }
    };
    @StyleRes
    private final int themeOverlay;
    @NonNull
    private final DynamicColors.Precondition precondition;
    @NonNull
    private final DynamicColors.OnAppliedCallback onAppliedCallback;
    @Nullable
    private Integer contentBasedSeedColor;

    private DynamicColorsOptions(Builder builder) {
        this.themeOverlay = builder.themeOverlay;
        this.precondition = builder.precondition;
        this.onAppliedCallback = builder.onAppliedCallback;
        if (builder.contentBasedSource != null) {
            this.contentBasedSeedColor = DynamicColorsOptions.extractSeedColorFromImage(builder.contentBasedSource);
        }
    }

    @StyleRes
    public int getThemeOverlay() {
        return this.themeOverlay;
    }

    @NonNull
    public DynamicColors.Precondition getPrecondition() {
        return this.precondition;
    }

    @NonNull
    public DynamicColors.OnAppliedCallback getOnAppliedCallback() {
        return this.onAppliedCallback;
    }

    @Nullable
    public Integer getContentBasedSeedColor() {
        return this.contentBasedSeedColor;
    }

    private static int extractSeedColorFromImage(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] bitmapPixels = new int[width * height];
        bitmap.getPixels(bitmapPixels, 0, width, 0, 0, width, height);
        return Score.score(QuantizerCelebi.quantize(bitmapPixels, 128)).get(0);
    }

    static /* synthetic */ DynamicColors.Precondition access$400() {
        return ALWAYS_ALLOW;
    }

    static /* synthetic */ DynamicColors.OnAppliedCallback access$500() {
        return NO_OP_CALLBACK;
    }

    public static class Builder {
        @StyleRes
        private int themeOverlay;
        @NonNull
        private DynamicColors.Precondition precondition = DynamicColorsOptions.access$400();
        @NonNull
        private DynamicColors.OnAppliedCallback onAppliedCallback = DynamicColorsOptions.access$500();
        @Nullable
        private Bitmap contentBasedSource;

        @NonNull
        @CanIgnoreReturnValue
        public Builder setThemeOverlay(@StyleRes int themeOverlay) {
            this.themeOverlay = themeOverlay;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setPrecondition(@NonNull DynamicColors.Precondition precondition) {
            this.precondition = precondition;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setOnAppliedCallback(@NonNull DynamicColors.OnAppliedCallback onAppliedCallback) {
            this.onAppliedCallback = onAppliedCallback;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        @CanIgnoreReturnValue
        public Builder setContentBasedSource(@NonNull Bitmap contentBasedSource) {
            this.contentBasedSource = contentBasedSource;
            return this;
        }

        @NonNull
        public DynamicColorsOptions build() {
            return new DynamicColorsOptions(this);
        }
    }
}

