/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.DislikeAnalyzer;
import com.google.android.material.color.utilities.DynamicColor;
import com.google.android.material.color.utilities.DynamicScheme;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.ToneDeltaConstraint;
import com.google.android.material.color.utilities.TonePolarity;
import com.google.android.material.color.utilities.Variant;
import com.google.android.material.color.utilities.ViewingConditions;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialDynamicColors {
    private static final double CONTAINER_ACCENT_TONE_DELTA = 15.0;
    public static final DynamicColor background = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 6.0 : 98.0);
    public static final DynamicColor onBackground = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 90.0 : 10.0, s -> background);
    public static final DynamicColor surface = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 6.0 : 98.0);
    public static final DynamicColor surfaceInverse = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 90.0 : 20.0);
    public static final DynamicColor surfaceBright = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 24.0 : 98.0);
    public static final DynamicColor surfaceDim = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 6.0 : 87.0);
    public static final DynamicColor surfaceSub2 = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 4.0 : 100.0);
    public static final DynamicColor surfaceSub1 = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 10.0 : 96.0);
    public static final DynamicColor surfaceContainer = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 12.0 : 94.0);
    public static final DynamicColor surfaceAdd1 = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 17.0 : 92.0);
    public static final DynamicColor surfaceAdd2 = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 22.0 : 90.0);
    public static final DynamicColor onSurface = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 90.0 : 10.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onSurfaceInverse = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 20.0 : 95.0, s -> surfaceInverse);
    public static final DynamicColor surfaceVariant = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> s.isDark ? 30.0 : 90.0);
    public static final DynamicColor onSurfaceVariant = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> s.isDark ? 80.0 : 30.0, s -> surfaceVariant);
    public static final DynamicColor outline = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> 50.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor outlineVariant = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> 80.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor primaryContainer = DynamicColor.fromPalette(s -> s.primaryPalette, s -> {
        if (!MaterialDynamicColors.isFidelity(s)) {
            return s.isDark ? 30.0 : 90.0;
        }
        return MaterialDynamicColors.performAlbers(s.sourceColorHct, s);
    }, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onPrimaryContainer = DynamicColor.fromPalette(s -> s.primaryPalette, s -> {
        if (!MaterialDynamicColors.isFidelity(s)) {
            return s.isDark ? 90.0 : 10.0;
        }
        return DynamicColor.contrastingTone(primaryContainer.getTone((DynamicScheme)s), 4.5);
    }, s -> primaryContainer, null);
    public static final DynamicColor primary = DynamicColor.fromPalette(s -> s.primaryPalette, s -> s.isDark ? 80.0 : 40.0, s -> MaterialDynamicColors.highestSurface(s), s -> new ToneDeltaConstraint(15.0, primaryContainer, s.isDark ? TonePolarity.DARKER : TonePolarity.LIGHTER));
    public static final DynamicColor primaryInverse = DynamicColor.fromPalette(s -> s.primaryPalette, s -> s.isDark ? 40.0 : 80.0, s -> surfaceInverse);
    public static final DynamicColor onPrimary = DynamicColor.fromPalette(s -> s.primaryPalette, s -> s.isDark ? 20.0 : 100.0, s -> primary);
    public static final DynamicColor secondaryContainer = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> {
        double initialTone;
        double d = initialTone = s.isDark ? 30.0 : 90.0;
        if (!MaterialDynamicColors.isFidelity(s)) {
            return initialTone;
        }
        double answer = MaterialDynamicColors.findDesiredChromaByTone(s.secondaryPalette.getHue(), s.secondaryPalette.getChroma(), initialTone, !s.isDark);
        answer = MaterialDynamicColors.performAlbers(s.secondaryPalette.getHct(answer), s);
        return answer;
    }, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onSecondaryContainer = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> {
        if (!MaterialDynamicColors.isFidelity(s)) {
            return s.isDark ? 90.0 : 10.0;
        }
        return DynamicColor.contrastingTone(secondaryContainer.getTone((DynamicScheme)s), 4.5);
    }, s -> secondaryContainer);
    public static final DynamicColor secondary = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> s.isDark ? 80.0 : 40.0, s -> MaterialDynamicColors.highestSurface(s), s -> new ToneDeltaConstraint(15.0, secondaryContainer, s.isDark ? TonePolarity.DARKER : TonePolarity.LIGHTER));
    public static final DynamicColor onSecondary = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> s.isDark ? 20.0 : 100.0, s -> secondary);
    public static final DynamicColor tertiaryContainer = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> {
        if (!MaterialDynamicColors.isFidelity(s)) {
            return s.isDark ? 30.0 : 90.0;
        }
        double albersTone = MaterialDynamicColors.performAlbers(s.tertiaryPalette.getHct(s.sourceColorHct.getTone()), s);
        Hct proposedHct = s.tertiaryPalette.getHct(albersTone);
        return DislikeAnalyzer.fixIfDisliked(proposedHct).getTone();
    }, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onTertiaryContainer = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> {
        if (!MaterialDynamicColors.isFidelity(s)) {
            return s.isDark ? 90.0 : 10.0;
        }
        return DynamicColor.contrastingTone(tertiaryContainer.getTone((DynamicScheme)s), 4.5);
    }, s -> tertiaryContainer);
    public static final DynamicColor tertiary = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> s.isDark ? 80.0 : 40.0, s -> MaterialDynamicColors.highestSurface(s), s -> new ToneDeltaConstraint(15.0, tertiaryContainer, s.isDark ? TonePolarity.DARKER : TonePolarity.LIGHTER));
    public static final DynamicColor onTertiary = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> s.isDark ? 20.0 : 100.0, s -> tertiary);
    public static final DynamicColor errorContainer = DynamicColor.fromPalette(s -> s.errorPalette, s -> s.isDark ? 30.0 : 90.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onErrorContainer = DynamicColor.fromPalette(s -> s.errorPalette, s -> s.isDark ? 90.0 : 10.0, s -> errorContainer);
    public static final DynamicColor error = DynamicColor.fromPalette(s -> s.errorPalette, s -> s.isDark ? 80.0 : 40.0, s -> MaterialDynamicColors.highestSurface(s), s -> new ToneDeltaConstraint(15.0, errorContainer, s.isDark ? TonePolarity.DARKER : TonePolarity.LIGHTER));
    public static final DynamicColor onError = DynamicColor.fromPalette(s -> s.errorPalette, s -> s.isDark ? 20.0 : 100.0, s -> error);
    public static final DynamicColor primaryFixed = DynamicColor.fromPalette(s -> s.primaryPalette, s -> 90.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor primaryFixedDarker = DynamicColor.fromPalette(s -> s.primaryPalette, s -> 80.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onPrimaryFixed = DynamicColor.fromPalette(s -> s.primaryPalette, s -> 10.0, s -> primaryFixedDarker);
    public static final DynamicColor onPrimaryFixedVariant = DynamicColor.fromPalette(s -> s.primaryPalette, s -> 30.0, s -> primaryFixedDarker);
    public static final DynamicColor secondaryFixed = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> 90.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor secondaryFixedDarker = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> 80.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onSecondaryFixed = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> 10.0, s -> secondaryFixedDarker);
    public static final DynamicColor onSecondaryFixedVariant = DynamicColor.fromPalette(s -> s.secondaryPalette, s -> 30.0, s -> secondaryFixedDarker);
    public static final DynamicColor tertiaryFixed = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> 90.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor tertiaryFixedDarker = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> 80.0, s -> MaterialDynamicColors.highestSurface(s));
    public static final DynamicColor onTertiaryFixed = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> 10.0, s -> tertiaryFixedDarker);
    public static final DynamicColor onTertiaryFixedVariant = DynamicColor.fromPalette(s -> s.tertiaryPalette, s -> 30.0, s -> tertiaryFixedDarker);
    public static final DynamicColor controlActivated = DynamicColor.fromPalette(s -> s.primaryPalette, s -> s.isDark ? 30.0 : 90.0, null);
    public static final DynamicColor controlNormal = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> s.isDark ? 80.0 : 30.0);
    public static final DynamicColor controlHighlight = new DynamicColor(s -> 0.0, s -> 0.0, s -> s.isDark ? 100.0 : 0.0, s -> s.isDark ? 0.2 : 0.12, null, scheme -> DynamicColor.toneMinContrastDefault(s -> s.isDark ? 100.0 : 0.0, null, scheme, null), scheme -> DynamicColor.toneMaxContrastDefault(s -> s.isDark ? 100.0 : 0.0, null, scheme, null), null);
    public static final DynamicColor textPrimaryInverse = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    public static final DynamicColor textSecondaryAndTertiaryInverse = DynamicColor.fromPalette(s -> s.neutralVariantPalette, s -> s.isDark ? 30.0 : 80.0);
    public static final DynamicColor textPrimaryInverseDisableOnly = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    public static final DynamicColor textSecondaryAndTertiaryInverseDisabled = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);
    public static final DynamicColor textHintInverse = DynamicColor.fromPalette(s -> s.neutralPalette, s -> s.isDark ? 10.0 : 90.0);

    private MaterialDynamicColors() {
    }

    public static DynamicColor highestSurface(DynamicScheme s) {
        return s.isDark ? surfaceBright : surfaceDim;
    }

    private static ViewingConditions viewingConditionsForAlbers(DynamicScheme scheme) {
        return ViewingConditions.defaultWithBackgroundLstar(scheme.isDark ? 30.0 : 80.0);
    }

    private static boolean isFidelity(DynamicScheme scheme) {
        return scheme.variant == Variant.FIDELITY || scheme.variant == Variant.CONTENT;
    }

    static double findDesiredChromaByTone(double hue, double chroma, double tone, boolean byDecreasingTone) {
        double answer = tone;
        Hct closestToChroma = Hct.from(hue, chroma, tone);
        if (closestToChroma.getChroma() < chroma) {
            Hct potentialSolution;
            double chromaPeak = closestToChroma.getChroma();
            while (closestToChroma.getChroma() < chroma && !(chromaPeak > (potentialSolution = Hct.from(hue, chroma, answer += byDecreasingTone ? -1.0 : 1.0)).getChroma()) && !(Math.abs(potentialSolution.getChroma() - chroma) < 0.4)) {
                double currentDelta;
                double potentialDelta = Math.abs(potentialSolution.getChroma() - chroma);
                if (potentialDelta < (currentDelta = Math.abs(closestToChroma.getChroma() - chroma))) {
                    closestToChroma = potentialSolution;
                }
                chromaPeak = Math.max(chromaPeak, potentialSolution.getChroma());
            }
        }
        return answer;
    }

    static double performAlbers(Hct prealbers, DynamicScheme scheme) {
        Hct albersd = prealbers.inViewingConditions(MaterialDynamicColors.viewingConditionsForAlbers(scheme));
        if (DynamicColor.tonePrefersLightForeground(prealbers.getTone()) && !DynamicColor.toneAllowsLightForeground(albersd.getTone())) {
            return DynamicColor.enableLightForeground(prealbers.getTone());
        }
        return DynamicColor.enableLightForeground(albersd.getTone());
    }
}

