/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TonalPalette {
    Map<Integer, Integer> cache = new HashMap<Integer, Integer>();
    double hue;
    double chroma;

    public static final TonalPalette fromInt(int argb) {
        return TonalPalette.fromHct(Hct.fromInt(argb));
    }

    public static final TonalPalette fromHct(Hct hct) {
        return TonalPalette.fromHueAndChroma(hct.getHue(), hct.getChroma());
    }

    public static final TonalPalette fromHueAndChroma(double hue, double chroma) {
        return new TonalPalette(hue, chroma);
    }

    private TonalPalette(double hue, double chroma) {
        this.hue = hue;
        this.chroma = chroma;
    }

    public int tone(int tone) {
        Integer color2 = this.cache.get(tone);
        if (color2 == null) {
            color2 = Hct.from(this.hue, this.chroma, tone).toInt();
            this.cache.put(tone, color2);
        }
        return color2;
    }

    public Hct getHct(double tone) {
        return Hct.from(this.hue, this.chroma, tone);
    }

    public double getChroma() {
        return this.chroma;
    }

    public double getHue() {
        return this.hue;
    }
}

