/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import com.google.android.material.datepicker.DateValidatorPointForward;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Objects;

public final class CalendarConstraints
implements Parcelable {
    @NonNull
    private final Month start;
    @NonNull
    private final Month end;
    @NonNull
    private final DateValidator validator;
    @Nullable
    private Month openAt;
    private final int firstDayOfWeek;
    private final int yearSpan;
    private final int monthSpan;
    public static final Parcelable.Creator<CalendarConstraints> CREATOR = new Parcelable.Creator<CalendarConstraints>(){

        @NonNull
        public CalendarConstraints createFromParcel(@NonNull Parcel source) {
            Month start = (Month)source.readParcelable(Month.class.getClassLoader());
            Month end = (Month)source.readParcelable(Month.class.getClassLoader());
            Month openAt = (Month)source.readParcelable(Month.class.getClassLoader());
            DateValidator validator = (DateValidator)source.readParcelable(DateValidator.class.getClassLoader());
            int firstDayOfWeek = source.readInt();
            return new CalendarConstraints(start, end, validator, openAt, firstDayOfWeek);
        }

        @NonNull
        public CalendarConstraints[] newArray(int size) {
            return new CalendarConstraints[size];
        }
    };

    private CalendarConstraints(@NonNull Month start, @NonNull Month end, @NonNull DateValidator validator, @Nullable Month openAt, int firstDayOfWeek) {
        Objects.requireNonNull(start, "start cannot be null");
        Objects.requireNonNull(end, "end cannot be null");
        Objects.requireNonNull(validator, "validator cannot be null");
        this.start = start;
        this.end = end;
        this.openAt = openAt;
        this.firstDayOfWeek = firstDayOfWeek;
        this.validator = validator;
        if (openAt != null && start.compareTo(openAt) > 0) {
            throw new IllegalArgumentException("start Month cannot be after current Month");
        }
        if (openAt != null && openAt.compareTo(end) > 0) {
            throw new IllegalArgumentException("current Month cannot be after end Month");
        }
        if (firstDayOfWeek < 0 || firstDayOfWeek > UtcDates.getUtcCalendar().getMaximum(7)) {
            throw new IllegalArgumentException("firstDayOfWeek is not valid");
        }
        this.monthSpan = start.monthsUntil(end) + 1;
        this.yearSpan = end.year - start.year + 1;
    }

    boolean isWithinBounds(long date) {
        return this.start.getDay(1) <= date && date <= this.end.getDay(this.end.daysInMonth);
    }

    public DateValidator getDateValidator() {
        return this.validator;
    }

    @NonNull
    Month getStart() {
        return this.start;
    }

    @NonNull
    Month getEnd() {
        return this.end;
    }

    @Nullable
    Month getOpenAt() {
        return this.openAt;
    }

    void setOpenAt(@Nullable Month openAt) {
        this.openAt = openAt;
    }

    int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    int getMonthSpan() {
        return this.monthSpan;
    }

    int getYearSpan() {
        return this.yearSpan;
    }

    public long getStartMs() {
        return this.start.timeInMillis;
    }

    public long getEndMs() {
        return this.end.timeInMillis;
    }

    @Nullable
    public Long getOpenAtMs() {
        return this.openAt == null ? null : Long.valueOf(this.openAt.timeInMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalendarConstraints)) {
            return false;
        }
        CalendarConstraints that = (CalendarConstraints)o;
        return this.start.equals(that.start) && this.end.equals(that.end) && ObjectsCompat.equals((Object)this.openAt, (Object)that.openAt) && this.firstDayOfWeek == that.firstDayOfWeek && this.validator.equals(that.validator);
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.start, this.end, this.openAt, this.firstDayOfWeek, this.validator};
        return Arrays.hashCode(hashedFields);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.start, 0);
        dest.writeParcelable((Parcelable)this.end, 0);
        dest.writeParcelable((Parcelable)this.openAt, 0);
        dest.writeParcelable((Parcelable)this.validator, 0);
        dest.writeInt(this.firstDayOfWeek);
    }

    Month clamp(Month month) {
        if (month.compareTo(this.start) < 0) {
            return this.start;
        }
        if (month.compareTo(this.end) > 0) {
            return this.end;
        }
        return month;
    }

    public static final class Builder {
        static final long DEFAULT_START = UtcDates.canonicalYearMonthDay(Month.create((int)1900, (int)0).timeInMillis);
        static final long DEFAULT_END = UtcDates.canonicalYearMonthDay(Month.create((int)2100, (int)11).timeInMillis);
        private static final String DEEP_COPY_VALIDATOR_KEY = "DEEP_COPY_VALIDATOR_KEY";
        private long start = DEFAULT_START;
        private long end = DEFAULT_END;
        private Long openAt;
        private int firstDayOfWeek;
        private DateValidator validator = DateValidatorPointForward.from(Long.MIN_VALUE);

        public Builder() {
        }

        Builder(@NonNull CalendarConstraints clone) {
            this.start = ((CalendarConstraints)clone).start.timeInMillis;
            this.end = ((CalendarConstraints)clone).end.timeInMillis;
            this.openAt = ((CalendarConstraints)clone).openAt.timeInMillis;
            this.firstDayOfWeek = clone.firstDayOfWeek;
            this.validator = clone.validator;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setStart(long month) {
            this.start = month;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setEnd(long month) {
            this.end = month;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setOpenAt(long month) {
            this.openAt = month;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setFirstDayOfWeek(int firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setValidator(@NonNull DateValidator validator) {
            Objects.requireNonNull(validator, "validator cannot be null");
            this.validator = validator;
            return this;
        }

        @NonNull
        public CalendarConstraints build() {
            Bundle deepCopyBundle = new Bundle();
            deepCopyBundle.putParcelable(DEEP_COPY_VALIDATOR_KEY, (Parcelable)this.validator);
            return new CalendarConstraints(Month.create(this.start), Month.create(this.end), (DateValidator)deepCopyBundle.getParcelable(DEEP_COPY_VALIDATOR_KEY), this.openAt == null ? null : Month.create(this.openAt), this.firstDayOfWeek);
        }
    }

    public static interface DateValidator
    extends Parcelable {
        public boolean isValid(long var1);
    }
}

