/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.ValueAnimator;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.internal.FadeThroughUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FadeThroughUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    @Nullable
    private final View fadeOutView;
    @Nullable
    private final View fadeInView;
    private final float[] alphas;

    public FadeThroughUpdateListener(@Nullable View fadeOutView, @Nullable View fadeInView) {
        this.fadeOutView = fadeOutView;
        this.fadeInView = fadeInView;
        this.alphas = new float[2];
    }

    public void onAnimationUpdate(@NonNull ValueAnimator animation) {
        float progress = ((Float)animation.getAnimatedValue()).floatValue();
        FadeThroughUtils.calculateFadeOutAndInAlphas(progress, this.alphas);
        if (this.fadeOutView != null) {
            this.fadeOutView.setAlpha(this.alphas[0]);
        }
        if (this.fadeInView != null) {
            this.fadeInView.setAlpha(this.alphas[1]);
        }
    }
}

