/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.core.util.Pools;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.internal.TextScale;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarPresenter;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.util.HashSet;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class NavigationBarMenuView
extends ViewGroup
implements MenuView {
    private static final int ITEM_POOL_SIZE = 5;
    private static final int NO_PADDING = -1;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    @Nullable
    private final TransitionSet set;
    @NonNull
    private final View.OnClickListener onClickListener;
    private final Pools.Pool<NavigationBarItemView> itemPool = new Pools.SynchronizedPool(5);
    @NonNull
    private final SparseArray<View.OnTouchListener> onTouchListeners = new SparseArray(5);
    private int labelVisibilityMode;
    @Nullable
    private NavigationBarItemView[] buttons;
    private int selectedItemId = 0;
    private int selectedItemPosition = 0;
    @Nullable
    private ColorStateList itemIconTint;
    @Dimension
    private int itemIconSize;
    private ColorStateList itemTextColorFromUser;
    @Nullable
    private final ColorStateList itemTextColorDefault;
    @StyleRes
    private int itemTextAppearanceInactive;
    @StyleRes
    private int itemTextAppearanceActive;
    private Drawable itemBackground;
    @Nullable
    private ColorStateList itemRippleColor;
    private int itemBackgroundRes;
    @NonNull
    private final SparseArray<BadgeDrawable> badgeDrawables = new SparseArray(5);
    private int itemPaddingTop = -1;
    private int itemPaddingBottom = -1;
    private boolean itemActiveIndicatorEnabled;
    private int itemActiveIndicatorWidth;
    private int itemActiveIndicatorHeight;
    private int itemActiveIndicatorMarginHorizontal;
    private ShapeAppearanceModel itemActiveIndicatorShapeAppearance;
    private boolean itemActiveIndicatorResizeable = false;
    private ColorStateList itemActiveIndicatorColor;
    private NavigationBarPresenter presenter;
    private MenuBuilder menu;

    public NavigationBarMenuView(@NonNull Context context) {
        super(context);
        this.itemTextColorDefault = this.createDefaultColorStateList(16842808);
        if (this.isInEditMode()) {
            this.set = null;
        } else {
            this.set = new AutoTransition();
            this.set.setOrdering(0);
            this.set.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationMedium4, this.getResources().getInteger(R.integer.material_motion_duration_long_1)));
            this.set.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingStandard, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
            this.set.addTransition((Transition)new TextScale());
        }
        this.onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                NavigationBarItemView itemView = (NavigationBarItemView)v;
                MenuItemImpl item = itemView.getItemData();
                if (!NavigationBarMenuView.this.menu.performItemAction((MenuItem)item, (MenuPresenter)NavigationBarMenuView.this.presenter, 0)) {
                    item.setChecked(true);
                }
            }
        };
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    public void initialize(@NonNull MenuBuilder menu) {
        this.menu = menu;
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
        infoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.menu.getVisibleItems().size(), (boolean)false, (int)1));
    }

    public void setIconTintList(@Nullable ColorStateList tint) {
        this.itemIconTint = tint;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setIconTintList(tint);
            }
        }
    }

    @Nullable
    public ColorStateList getIconTintList() {
        return this.itemIconTint;
    }

    public void setItemIconSize(@Dimension int iconSize) {
        this.itemIconSize = iconSize;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setIconSize(iconSize);
            }
        }
    }

    @Dimension
    public int getItemIconSize() {
        return this.itemIconSize;
    }

    public void setItemTextColor(@Nullable ColorStateList color2) {
        this.itemTextColorFromUser = color2;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setTextColor(color2);
            }
        }
    }

    @Nullable
    public ColorStateList getItemTextColor() {
        return this.itemTextColorFromUser;
    }

    public void setItemTextAppearanceInactive(@StyleRes int textAppearanceRes) {
        this.itemTextAppearanceInactive = textAppearanceRes;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setTextAppearanceInactive(textAppearanceRes);
                if (this.itemTextColorFromUser == null) continue;
                item.setTextColor(this.itemTextColorFromUser);
            }
        }
    }

    @StyleRes
    public int getItemTextAppearanceInactive() {
        return this.itemTextAppearanceInactive;
    }

    public void setItemTextAppearanceActive(@StyleRes int textAppearanceRes) {
        this.itemTextAppearanceActive = textAppearanceRes;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setTextAppearanceActive(textAppearanceRes);
                if (this.itemTextColorFromUser == null) continue;
                item.setTextColor(this.itemTextColorFromUser);
            }
        }
    }

    @StyleRes
    public int getItemTextAppearanceActive() {
        return this.itemTextAppearanceActive;
    }

    public void setItemBackgroundRes(int background) {
        this.itemBackgroundRes = background;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setItemBackground(background);
            }
        }
    }

    @Px
    public int getItemPaddingTop() {
        return this.itemPaddingTop;
    }

    public void setItemPaddingTop(@Px int paddingTop) {
        this.itemPaddingTop = paddingTop;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setItemPaddingTop(paddingTop);
            }
        }
    }

    @Px
    public int getItemPaddingBottom() {
        return this.itemPaddingBottom;
    }

    public void setItemPaddingBottom(@Px int paddingBottom) {
        this.itemPaddingBottom = paddingBottom;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setItemPaddingBottom(paddingBottom);
            }
        }
    }

    public boolean getItemActiveIndicatorEnabled() {
        return this.itemActiveIndicatorEnabled;
    }

    public void setItemActiveIndicatorEnabled(boolean enabled) {
        this.itemActiveIndicatorEnabled = enabled;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorEnabled(enabled);
            }
        }
    }

    @Px
    public int getItemActiveIndicatorWidth() {
        return this.itemActiveIndicatorWidth;
    }

    public void setItemActiveIndicatorWidth(@Px int width) {
        this.itemActiveIndicatorWidth = width;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorWidth(width);
            }
        }
    }

    @Px
    public int getItemActiveIndicatorHeight() {
        return this.itemActiveIndicatorHeight;
    }

    public void setItemActiveIndicatorHeight(@Px int height) {
        this.itemActiveIndicatorHeight = height;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorHeight(height);
            }
        }
    }

    @Px
    public int getItemActiveIndicatorMarginHorizontal() {
        return this.itemActiveIndicatorMarginHorizontal;
    }

    public void setItemActiveIndicatorMarginHorizontal(@Px int marginHorizontal) {
        this.itemActiveIndicatorMarginHorizontal = marginHorizontal;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorMarginHorizontal(marginHorizontal);
            }
        }
    }

    @Nullable
    public ShapeAppearanceModel getItemActiveIndicatorShapeAppearance() {
        return this.itemActiveIndicatorShapeAppearance;
    }

    public void setItemActiveIndicatorShapeAppearance(@Nullable ShapeAppearanceModel shapeAppearance) {
        this.itemActiveIndicatorShapeAppearance = shapeAppearance;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            }
        }
    }

    protected boolean isItemActiveIndicatorResizeable() {
        return this.itemActiveIndicatorResizeable;
    }

    protected void setItemActiveIndicatorResizeable(boolean resizeable) {
        this.itemActiveIndicatorResizeable = resizeable;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorResizeable(resizeable);
            }
        }
    }

    @Nullable
    public ColorStateList getItemActiveIndicatorColor() {
        return this.itemActiveIndicatorColor;
    }

    public void setItemActiveIndicatorColor(@Nullable ColorStateList csl) {
        this.itemActiveIndicatorColor = csl;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            }
        }
    }

    @Nullable
    private Drawable createItemActiveIndicatorDrawable() {
        if (this.itemActiveIndicatorShapeAppearance != null && this.itemActiveIndicatorColor != null) {
            MaterialShapeDrawable drawable2 = new MaterialShapeDrawable(this.itemActiveIndicatorShapeAppearance);
            drawable2.setFillColor(this.itemActiveIndicatorColor);
            return drawable2;
        }
        return null;
    }

    @Deprecated
    public int getItemBackgroundRes() {
        return this.itemBackgroundRes;
    }

    public void setItemBackground(@Nullable Drawable background) {
        this.itemBackground = background;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setItemBackground(background);
            }
        }
    }

    public void setItemRippleColor(@Nullable ColorStateList itemRippleColor) {
        this.itemRippleColor = itemRippleColor;
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                item.setItemRippleColor(itemRippleColor);
            }
        }
    }

    @Nullable
    public ColorStateList getItemRippleColor() {
        return this.itemRippleColor;
    }

    @Nullable
    public Drawable getItemBackground() {
        if (this.buttons != null && this.buttons.length > 0) {
            return this.buttons[0].getBackground();
        }
        return this.itemBackground;
    }

    public void setLabelVisibilityMode(int labelVisibilityMode) {
        this.labelVisibilityMode = labelVisibilityMode;
    }

    public int getLabelVisibilityMode() {
        return this.labelVisibilityMode;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void setItemOnTouchListener(int menuItemId, @Nullable View.OnTouchListener onTouchListener) {
        if (onTouchListener == null) {
            this.onTouchListeners.remove(menuItemId);
        } else {
            this.onTouchListeners.put(menuItemId, (Object)onTouchListener);
        }
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                if (item.getItemData().getItemId() != menuItemId) continue;
                item.setOnTouchListener(onTouchListener);
            }
        }
    }

    @Nullable
    public ColorStateList createDefaultColorStateList(int baseColorThemeAttr) {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(baseColorThemeAttr, value, true)) {
            return null;
        }
        ColorStateList baseColor = AppCompatResources.getColorStateList((Context)this.getContext(), (int)value.resourceId);
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, value, true)) {
            return null;
        }
        int colorPrimary = value.data;
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), colorPrimary, defaultColor});
    }

    public void setPresenter(@NonNull NavigationBarPresenter presenter) {
        this.presenter = presenter;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void buildMenuView() {
        this.removeAllViews();
        if (this.buttons != null) {
            for (NavigationBarItemView item : this.buttons) {
                if (item == null) continue;
                this.itemPool.release((Object)item);
                item.clear();
            }
        }
        if (this.menu.size() == 0) {
            this.selectedItemId = 0;
            this.selectedItemPosition = 0;
            this.buttons = null;
            return;
        }
        this.removeUnusedBadges();
        this.buttons = new NavigationBarItemView[this.menu.size()];
        boolean shifting = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
        for (int i = 0; i < this.menu.size(); ++i) {
            NavigationBarItemView child;
            NavigationBarItemView item;
            this.presenter.setUpdateSuspended(true);
            this.menu.getItem(i).setCheckable(true);
            this.presenter.setUpdateSuspended(false);
            this.buttons[i] = child = this.getNewItem();
            child.setIconTintList(this.itemIconTint);
            child.setIconSize(this.itemIconSize);
            child.setTextColor(this.itemTextColorDefault);
            child.setTextAppearanceInactive(this.itemTextAppearanceInactive);
            child.setTextAppearanceActive(this.itemTextAppearanceActive);
            child.setTextColor(this.itemTextColorFromUser);
            if (this.itemPaddingTop != -1) {
                child.setItemPaddingTop(this.itemPaddingTop);
            }
            if (this.itemPaddingBottom != -1) {
                child.setItemPaddingBottom(this.itemPaddingBottom);
            }
            child.setActiveIndicatorWidth(this.itemActiveIndicatorWidth);
            child.setActiveIndicatorHeight(this.itemActiveIndicatorHeight);
            child.setActiveIndicatorMarginHorizontal(this.itemActiveIndicatorMarginHorizontal);
            child.setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            child.setActiveIndicatorResizeable(this.itemActiveIndicatorResizeable);
            child.setActiveIndicatorEnabled(this.itemActiveIndicatorEnabled);
            if (this.itemBackground != null) {
                child.setItemBackground(this.itemBackground);
            } else {
                child.setItemBackground(this.itemBackgroundRes);
            }
            child.setItemRippleColor(this.itemRippleColor);
            child.setShifting(shifting);
            child.setLabelVisibilityMode(this.labelVisibilityMode);
            item = (MenuItemImpl)this.menu.getItem(i);
            child.initialize((MenuItemImpl)item, 0);
            child.setItemPosition(i);
            int itemId = item.getItemId();
            child.setOnTouchListener((View.OnTouchListener)this.onTouchListeners.get(itemId));
            child.setOnClickListener(this.onClickListener);
            if (this.selectedItemId != 0 && itemId == this.selectedItemId) {
                this.selectedItemPosition = i;
            }
            this.setBadgeIfNeeded(child);
            this.addView((View)child);
        }
        this.selectedItemPosition = Math.min(this.menu.size() - 1, this.selectedItemPosition);
        this.menu.getItem(this.selectedItemPosition).setChecked(true);
    }

    public void updateMenuView() {
        if (this.menu == null || this.buttons == null) {
            return;
        }
        int menuSize = this.menu.size();
        if (menuSize != this.buttons.length) {
            this.buildMenuView();
            return;
        }
        int previousSelectedId = this.selectedItemId;
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = this.menu.getItem(i);
            if (!item.isChecked()) continue;
            this.selectedItemId = item.getItemId();
            this.selectedItemPosition = i;
        }
        if (previousSelectedId != this.selectedItemId && this.set != null) {
            TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.set);
        }
        boolean shifting = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
        for (int i = 0; i < menuSize; ++i) {
            this.presenter.setUpdateSuspended(true);
            this.buttons[i].setLabelVisibilityMode(this.labelVisibilityMode);
            this.buttons[i].setShifting(shifting);
            this.buttons[i].initialize((MenuItemImpl)this.menu.getItem(i), 0);
            this.presenter.setUpdateSuspended(false);
        }
    }

    private NavigationBarItemView getNewItem() {
        NavigationBarItemView item = (NavigationBarItemView)((Object)this.itemPool.acquire());
        if (item == null) {
            item = this.createNavigationBarItemView(this.getContext());
        }
        return item;
    }

    public int getSelectedItemId() {
        return this.selectedItemId;
    }

    protected boolean isShifting(int labelVisibilityMode, int childCount) {
        return labelVisibilityMode == -1 ? childCount > 3 : labelVisibilityMode == 0;
    }

    void tryRestoreSelectedItemId(int itemId) {
        int size = this.menu.size();
        for (int i = 0; i < size; ++i) {
            MenuItem item = this.menu.getItem(i);
            if (itemId != item.getItemId()) continue;
            this.selectedItemId = itemId;
            this.selectedItemPosition = i;
            item.setChecked(true);
            break;
        }
    }

    SparseArray<BadgeDrawable> getBadgeDrawables() {
        return this.badgeDrawables;
    }

    void restoreBadgeDrawables(SparseArray<BadgeDrawable> badgeDrawables) {
        for (int i = 0; i < badgeDrawables.size(); ++i) {
            int key = badgeDrawables.keyAt(i);
            if (this.badgeDrawables.indexOfKey(key) >= 0) continue;
            this.badgeDrawables.append(key, (Object)((BadgeDrawable)badgeDrawables.get(key)));
        }
        if (this.buttons != null) {
            for (NavigationBarItemView itemView : this.buttons) {
                itemView.setBadge((BadgeDrawable)this.badgeDrawables.get(itemView.getId()));
            }
        }
    }

    @Nullable
    public BadgeDrawable getBadge(int menuItemId) {
        return (BadgeDrawable)this.badgeDrawables.get(menuItemId);
    }

    BadgeDrawable getOrCreateBadge(int menuItemId) {
        NavigationBarItemView itemView;
        this.validateMenuItemId(menuItemId);
        BadgeDrawable badgeDrawable = (BadgeDrawable)this.badgeDrawables.get(menuItemId);
        if (badgeDrawable == null) {
            badgeDrawable = BadgeDrawable.create(this.getContext());
            this.badgeDrawables.put(menuItemId, (Object)badgeDrawable);
        }
        if ((itemView = this.findItemView(menuItemId)) != null) {
            itemView.setBadge(badgeDrawable);
        }
        return badgeDrawable;
    }

    void removeBadge(int menuItemId) {
        this.validateMenuItemId(menuItemId);
        BadgeDrawable badgeDrawable = (BadgeDrawable)this.badgeDrawables.get(menuItemId);
        NavigationBarItemView itemView = this.findItemView(menuItemId);
        if (itemView != null) {
            itemView.removeBadge();
        }
        if (badgeDrawable != null) {
            this.badgeDrawables.remove(menuItemId);
        }
    }

    private void setBadgeIfNeeded(@NonNull NavigationBarItemView child) {
        int childId = child.getId();
        if (!this.isValidId(childId)) {
            return;
        }
        BadgeDrawable badgeDrawable = (BadgeDrawable)this.badgeDrawables.get(childId);
        if (badgeDrawable != null) {
            child.setBadge(badgeDrawable);
        }
    }

    private void removeUnusedBadges() {
        int i;
        HashSet<Integer> activeKeys = new HashSet<Integer>();
        for (i = 0; i < this.menu.size(); ++i) {
            activeKeys.add(this.menu.getItem(i).getItemId());
        }
        for (i = 0; i < this.badgeDrawables.size(); ++i) {
            int key = this.badgeDrawables.keyAt(i);
            if (activeKeys.contains(key)) continue;
            this.badgeDrawables.delete(key);
        }
    }

    @Nullable
    public NavigationBarItemView findItemView(int menuItemId) {
        this.validateMenuItemId(menuItemId);
        if (this.buttons != null) {
            for (NavigationBarItemView itemView : this.buttons) {
                if (itemView.getId() != menuItemId) continue;
                return itemView;
            }
        }
        return null;
    }

    @NonNull
    protected abstract NavigationBarItemView createNavigationBarItemView(@NonNull Context var1);

    protected int getSelectedItemPosition() {
        return this.selectedItemPosition;
    }

    @Nullable
    protected MenuBuilder getMenu() {
        return this.menu;
    }

    private boolean isValidId(int viewId) {
        return viewId != -1;
    }

    private void validateMenuItemId(int viewId) {
        if (!this.isValidId(viewId)) {
            throw new IllegalArgumentException(viewId + " is not a valid view id");
        }
    }
}

