/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.widget.ProgressBar;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.progressindicator.AnimatorDurationScaleProvider;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public abstract class BaseProgressIndicator<S extends BaseProgressIndicatorSpec>
extends ProgressBar {
    public static final int SHOW_NONE = 0;
    public static final int SHOW_OUTWARD = 1;
    public static final int SHOW_INWARD = 2;
    public static final int HIDE_NONE = 0;
    public static final int HIDE_OUTWARD = 1;
    public static final int HIDE_INWARD = 2;
    static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ProgressIndicator;
    static final float DEFAULT_OPACITY = 0.2f;
    static final int MAX_ALPHA = 255;
    static final int MAX_HIDE_DELAY = 1000;
    S spec;
    private int storedProgress;
    private boolean storedProgressAnimated;
    private boolean isParentDoneInitializing;
    private final int showDelay;
    private final int minHideDelay;
    private long lastShowStartTime = -1L;
    AnimatorDurationScaleProvider animatorDurationScaleProvider;
    private boolean isIndeterminateModeChangeRequested = false;
    private int visibilityAfterHide = 4;
    private final Runnable delayedShow = new Runnable(){

        @Override
        public void run() {
            BaseProgressIndicator.this.internalShow();
        }
    };
    private final Runnable delayedHide = new Runnable(){

        @Override
        public void run() {
            BaseProgressIndicator.this.internalHide();
            BaseProgressIndicator.this.lastShowStartTime = -1L;
        }
    };
    private final Animatable2Compat.AnimationCallback switchIndeterminateModeCallback = new Animatable2Compat.AnimationCallback(){

        public void onAnimationEnd(Drawable drawable2) {
            BaseProgressIndicator.this.setIndeterminate(false);
            BaseProgressIndicator.this.setProgressCompat(BaseProgressIndicator.this.storedProgress, BaseProgressIndicator.this.storedProgressAnimated);
        }
    };
    private final Animatable2Compat.AnimationCallback hideAnimationCallback = new Animatable2Compat.AnimationCallback(){

        public void onAnimationEnd(Drawable drawable2) {
            super.onAnimationEnd(drawable2);
            if (!BaseProgressIndicator.this.isIndeterminateModeChangeRequested) {
                BaseProgressIndicator.this.setVisibility(BaseProgressIndicator.this.visibilityAfterHide);
            }
        }
    };

    protected BaseProgressIndicator(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.spec = this.createSpec(context, attrs);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.BaseProgressIndicator, defStyleAttr, defStyleRes, new int[0]);
        this.showDelay = a.getInt(R.styleable.BaseProgressIndicator_showDelay, -1);
        int minHideDelayUncapped = a.getInt(R.styleable.BaseProgressIndicator_minHideDelay, -1);
        this.minHideDelay = Math.min(minHideDelayUncapped, 1000);
        a.recycle();
        this.animatorDurationScaleProvider = new AnimatorDurationScaleProvider();
        this.isParentDoneInitializing = true;
    }

    abstract S createSpec(@NonNull Context var1, @NonNull AttributeSet var2);

    private void registerAnimationCallbacks() {
        if (this.getProgressDrawable() != null && this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().getAnimatorDelegate().registerAnimatorsCompleteCallback(this.switchIndeterminateModeCallback);
        }
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().registerAnimationCallback(this.hideAnimationCallback);
        }
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().registerAnimationCallback(this.hideAnimationCallback);
        }
    }

    private void unregisterAnimationCallbacks() {
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().unregisterAnimationCallback(this.hideAnimationCallback);
            this.getIndeterminateDrawable().getAnimatorDelegate().unregisterAnimatorsCompleteCallback();
        }
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().unregisterAnimationCallback(this.hideAnimationCallback);
        }
    }

    public void show() {
        if (this.showDelay > 0) {
            this.removeCallbacks(this.delayedShow);
            this.postDelayed(this.delayedShow, this.showDelay);
        } else {
            this.delayedShow.run();
        }
    }

    private void internalShow() {
        if (this.minHideDelay > 0) {
            this.lastShowStartTime = SystemClock.uptimeMillis();
        }
        this.setVisibility(0);
    }

    public void hide() {
        boolean enoughTimeElapsed;
        if (this.getVisibility() != 0) {
            this.removeCallbacks(this.delayedShow);
            return;
        }
        this.removeCallbacks(this.delayedHide);
        long timeElapsedSinceShowStart = SystemClock.uptimeMillis() - this.lastShowStartTime;
        boolean bl = enoughTimeElapsed = timeElapsedSinceShowStart >= (long)this.minHideDelay;
        if (enoughTimeElapsed) {
            this.delayedHide.run();
            return;
        }
        this.postDelayed(this.delayedHide, (long)this.minHideDelay - timeElapsedSinceShowStart);
    }

    private void internalHide() {
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).setVisible(false, false, true);
        if (this.isNoLongerNeedToBeVisible()) {
            this.setVisibility(4);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.applyNewVisibility(visibility == 0);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.applyNewVisibility(false);
    }

    protected void applyNewVisibility(boolean animate) {
        if (!this.isParentDoneInitializing) {
            return;
        }
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).setVisible(this.visibleToUser(), false, animate);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerAnimationCallbacks();
        if (this.visibleToUser()) {
            this.internalShow();
        }
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.delayedHide);
        this.removeCallbacks(this.delayedShow);
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).hideNow();
        this.unregisterAnimationCallbacks();
        super.onDetachedFromWindow();
    }

    protected synchronized void onDraw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        if (this.getPaddingLeft() != 0 || this.getPaddingTop() != 0) {
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        }
        if (this.getPaddingRight() != 0 || this.getPaddingBottom() != 0) {
            int w = this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
            int h = this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
            canvas.clipRect(0, 0, w, h);
        }
        this.getCurrentDrawable().draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        DrawingDelegate<S> drawingDelegate = this.getCurrentDrawingDelegate();
        if (drawingDelegate == null) {
            return;
        }
        int measuredWidth = drawingDelegate.getPreferredWidth() < 0 ? BaseProgressIndicator.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec) : drawingDelegate.getPreferredWidth() + this.getPaddingLeft() + this.getPaddingRight();
        int measuredHeight = drawingDelegate.getPreferredHeight() < 0 ? BaseProgressIndicator.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec) : drawingDelegate.getPreferredHeight() + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void invalidate() {
        super.invalidate();
        if (this.getCurrentDrawable() != null) {
            this.getCurrentDrawable().invalidateSelf();
        }
    }

    @Nullable
    public Drawable getCurrentDrawable() {
        return this.isIndeterminate() ? this.getIndeterminateDrawable() : this.getProgressDrawable();
    }

    @Nullable
    private DrawingDelegate<S> getCurrentDrawingDelegate() {
        if (this.isIndeterminate()) {
            return this.getIndeterminateDrawable() == null ? null : this.getIndeterminateDrawable().getDrawingDelegate();
        }
        return this.getProgressDrawable() == null ? null : this.getProgressDrawable().getDrawingDelegate();
    }

    public void setProgressDrawable(@Nullable Drawable drawable2) {
        if (drawable2 == null) {
            super.setProgressDrawable(null);
            return;
        }
        if (!(drawable2 instanceof DeterminateDrawable)) {
            throw new IllegalArgumentException("Cannot set framework drawable as progress drawable.");
        }
        DeterminateDrawable determinateDrawable = (DeterminateDrawable)drawable2;
        determinateDrawable.hideNow();
        super.setProgressDrawable((Drawable)determinateDrawable);
        determinateDrawable.setLevelByFraction((float)this.getProgress() / (float)this.getMax());
    }

    public void setIndeterminateDrawable(@Nullable Drawable drawable2) {
        if (drawable2 == null) {
            super.setIndeterminateDrawable(null);
            return;
        }
        if (!(drawable2 instanceof IndeterminateDrawable)) {
            throw new IllegalArgumentException("Cannot set framework drawable as indeterminate drawable.");
        }
        ((DrawableWithAnimatedVisibilityChange)drawable2).hideNow();
        super.setIndeterminateDrawable(drawable2);
    }

    @Nullable
    public DeterminateDrawable<S> getProgressDrawable() {
        return (DeterminateDrawable)super.getProgressDrawable();
    }

    @Nullable
    public IndeterminateDrawable<S> getIndeterminateDrawable() {
        return (IndeterminateDrawable)super.getIndeterminateDrawable();
    }

    boolean visibleToUser() {
        return ViewCompat.isAttachedToWindow((View)this) && this.getWindowVisibility() == 0 && this.isEffectivelyVisible();
    }

    boolean isEffectivelyVisible() {
        BaseProgressIndicator current = this;
        while (current.getVisibility() == 0) {
            ViewParent parent = current.getParent();
            if (parent == null) {
                return this.getWindowVisibility() == 0;
            }
            if (!(parent instanceof View)) {
                return true;
            }
            current = (View)parent;
        }
        return false;
    }

    private boolean isNoLongerNeedToBeVisible() {
        return !(this.getProgressDrawable() != null && this.getProgressDrawable().isVisible() || this.getIndeterminateDrawable() != null && this.getIndeterminateDrawable().isVisible());
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        if (indeterminate == this.isIndeterminate()) {
            return;
        }
        DrawableWithAnimatedVisibilityChange oldDrawable = (DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable();
        if (oldDrawable != null) {
            oldDrawable.hideNow();
        }
        super.setIndeterminate(indeterminate);
        DrawableWithAnimatedVisibilityChange newDrawable = (DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable();
        if (newDrawable != null) {
            newDrawable.setVisible(this.visibleToUser(), false, false);
        }
        if (newDrawable instanceof IndeterminateDrawable && this.visibleToUser()) {
            ((IndeterminateDrawable)newDrawable).getAnimatorDelegate().startAnimator();
        }
        this.isIndeterminateModeChangeRequested = false;
    }

    @Px
    public int getTrackThickness() {
        return ((BaseProgressIndicatorSpec)this.spec).trackThickness;
    }

    public void setTrackThickness(@Px int trackThickness) {
        if (((BaseProgressIndicatorSpec)this.spec).trackThickness != trackThickness) {
            ((BaseProgressIndicatorSpec)this.spec).trackThickness = trackThickness;
            this.requestLayout();
        }
    }

    @NonNull
    public int[] getIndicatorColor() {
        return ((BaseProgressIndicatorSpec)this.spec).indicatorColors;
    }

    public void setIndicatorColor(int ... indicatorColors) {
        if (indicatorColors.length == 0) {
            indicatorColors = new int[]{MaterialColors.getColor(this.getContext(), R.attr.colorPrimary, -1)};
        }
        if (!Arrays.equals(this.getIndicatorColor(), indicatorColors)) {
            ((BaseProgressIndicatorSpec)this.spec).indicatorColors = indicatorColors;
            this.getIndeterminateDrawable().getAnimatorDelegate().invalidateSpecValues();
            this.invalidate();
        }
    }

    @ColorInt
    public int getTrackColor() {
        return ((BaseProgressIndicatorSpec)this.spec).trackColor;
    }

    public void setTrackColor(@ColorInt int trackColor) {
        if (((BaseProgressIndicatorSpec)this.spec).trackColor != trackColor) {
            ((BaseProgressIndicatorSpec)this.spec).trackColor = trackColor;
            this.invalidate();
        }
    }

    @Px
    public int getTrackCornerRadius() {
        return ((BaseProgressIndicatorSpec)this.spec).trackCornerRadius;
    }

    public void setTrackCornerRadius(@Px int trackCornerRadius) {
        if (((BaseProgressIndicatorSpec)this.spec).trackCornerRadius != trackCornerRadius) {
            ((BaseProgressIndicatorSpec)this.spec).trackCornerRadius = Math.min(trackCornerRadius, ((BaseProgressIndicatorSpec)this.spec).trackThickness / 2);
        }
    }

    public int getShowAnimationBehavior() {
        return ((BaseProgressIndicatorSpec)this.spec).showAnimationBehavior;
    }

    public void setShowAnimationBehavior(int showAnimationBehavior) {
        ((BaseProgressIndicatorSpec)this.spec).showAnimationBehavior = showAnimationBehavior;
        this.invalidate();
    }

    public int getHideAnimationBehavior() {
        return ((BaseProgressIndicatorSpec)this.spec).hideAnimationBehavior;
    }

    public void setHideAnimationBehavior(int hideAnimationBehavior) {
        ((BaseProgressIndicatorSpec)this.spec).hideAnimationBehavior = hideAnimationBehavior;
        this.invalidate();
    }

    public synchronized void setProgress(int progress) {
        if (this.isIndeterminate()) {
            return;
        }
        this.setProgressCompat(progress, false);
    }

    public void setProgressCompat(int progress, boolean animated) {
        if (this.isIndeterminate()) {
            if (this.getProgressDrawable() != null) {
                this.storedProgress = progress;
                this.storedProgressAnimated = animated;
                this.isIndeterminateModeChangeRequested = true;
                if (!this.getIndeterminateDrawable().isVisible() || this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.getContext().getContentResolver()) == 0.0f) {
                    this.switchIndeterminateModeCallback.onAnimationEnd(this.getIndeterminateDrawable());
                } else {
                    this.getIndeterminateDrawable().getAnimatorDelegate().requestCancelAnimatorAfterCurrentCycle();
                }
            }
        } else {
            super.setProgress(progress);
            if (this.getProgressDrawable() != null && !animated) {
                this.getProgressDrawable().jumpToCurrentState();
            }
        }
    }

    public void setVisibilityAfterHide(int visibility) {
        if (visibility != 0 && visibility != 4 && visibility != 8) {
            throw new IllegalArgumentException("The component's visibility must be one of VISIBLE, INVISIBLE, and GONE defined in View.");
        }
        this.visibilityAfterHide = visibility;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public void setAnimatorDurationScaleProvider(@NonNull AnimatorDurationScaleProvider animatorDurationScaleProvider) {
        this.animatorDurationScaleProvider = animatorDurationScaleProvider;
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().animatorDurationScaleProvider = animatorDurationScaleProvider;
        }
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().animatorDurationScaleProvider = animatorDurationScaleProvider;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface HideAnimationBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ShowAnimationBehavior {
    }
}

