/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.search;

import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityManagerCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.search.SearchBarAnimationHelper;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public class SearchBar
extends Toolbar {
    private static final int DEF_STYLE_RES = R.style.Widget_Material3_SearchBar;
    private static final int DEFAULT_SCROLL_FLAGS = 53;
    private static final String NAMESPACE_APP = "http://schemas.android.com/apk/res-auto";
    private final TextView textView;
    private final boolean layoutInflated;
    private final boolean defaultMarginsEnabled;
    private final SearchBarAnimationHelper searchBarAnimationHelper;
    private final Drawable defaultNavigationIcon;
    private final boolean tintNavigationIcon;
    private final boolean forceDefaultNavigationOnClickListener;
    @Nullable
    private View centerView;
    @Nullable
    private Integer navigationIconTint;
    @Nullable
    private Drawable originalNavigationIconBackground;
    private int menuResId = -1;
    private boolean defaultScrollFlagsEnabled;
    private MaterialShapeDrawable backgroundShape;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    private final AccessibilityManagerCompat.TouchExplorationStateChangeListener touchExplorationStateChangeListener = enabled -> this.setFocusableInTouchMode(enabled);

    public SearchBar(@NonNull Context context) {
        this(context, null);
    }

    public SearchBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialSearchBarStyle);
    }

    public SearchBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.validateAttributes(attrs);
        this.defaultNavigationIcon = AppCompatResources.getDrawable((Context)context, (int)R.drawable.ic_search_black_24);
        this.searchBarAnimationHelper = new SearchBarAnimationHelper();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.SearchBar, defStyleAttr, DEF_STYLE_RES, new int[0]);
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES).build();
        float elevation = a.getDimension(R.styleable.SearchBar_elevation, 0.0f);
        this.defaultMarginsEnabled = a.getBoolean(R.styleable.SearchBar_defaultMarginsEnabled, true);
        this.defaultScrollFlagsEnabled = a.getBoolean(R.styleable.SearchBar_defaultScrollFlagsEnabled, true);
        boolean hideNavigationIcon = a.getBoolean(R.styleable.SearchBar_hideNavigationIcon, false);
        this.forceDefaultNavigationOnClickListener = a.getBoolean(R.styleable.SearchBar_forceDefaultNavigationOnClickListener, false);
        this.tintNavigationIcon = a.getBoolean(R.styleable.SearchBar_tintNavigationIcon, true);
        if (a.hasValue(R.styleable.SearchBar_navigationIconTint)) {
            this.navigationIconTint = a.getColor(R.styleable.SearchBar_navigationIconTint, -1);
        }
        int textAppearanceResId = a.getResourceId(R.styleable.SearchBar_android_textAppearance, -1);
        String text = a.getString(R.styleable.SearchBar_android_text);
        String hint = a.getString(R.styleable.SearchBar_android_hint);
        float strokeWidth = a.getDimension(R.styleable.SearchBar_strokeWidth, -1.0f);
        int strokeColor = a.getColor(R.styleable.SearchBar_strokeColor, 0);
        a.recycle();
        if (!hideNavigationIcon) {
            this.initNavigationIcon();
        }
        this.setClickable(true);
        this.setFocusable(true);
        LayoutInflater.from((Context)context).inflate(R.layout.mtrl_search_bar, (ViewGroup)this);
        this.layoutInflated = true;
        this.textView = (TextView)this.findViewById(R.id.search_bar_text_view);
        ViewCompat.setElevation((View)this, (float)elevation);
        this.initTextView(textAppearanceResId, text, hint);
        this.initBackground(shapeAppearanceModel, elevation, strokeWidth, strokeColor);
        this.accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setupTouchExplorationStateChangeListener();
    }

    private void setupTouchExplorationStateChangeListener() {
        if (this.accessibilityManager != null) {
            if (this.accessibilityManager.isEnabled() && this.accessibilityManager.isTouchExplorationEnabled()) {
                this.setFocusableInTouchMode(true);
            }
            this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View ignored) {
                    AccessibilityManagerCompat.addTouchExplorationStateChangeListener((AccessibilityManager)SearchBar.this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)SearchBar.this.touchExplorationStateChangeListener);
                }

                public void onViewDetachedFromWindow(View ignored) {
                    AccessibilityManagerCompat.removeTouchExplorationStateChangeListener((AccessibilityManager)SearchBar.this.accessibilityManager, (AccessibilityManagerCompat.TouchExplorationStateChangeListener)SearchBar.this.touchExplorationStateChangeListener);
                }
            });
        }
    }

    private void validateAttributes(@Nullable AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (attributeSet.getAttributeValue(NAMESPACE_APP, "title") != null) {
            throw new UnsupportedOperationException("SearchBar does not support title. Use hint or text instead.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_APP, "subtitle") != null) {
            throw new UnsupportedOperationException("SearchBar does not support subtitle. Use hint or text instead.");
        }
    }

    private void initNavigationIcon() {
        this.setNavigationIcon(this.getNavigationIcon() == null ? this.defaultNavigationIcon : this.getNavigationIcon());
        this.setNavigationIconDecorative(true);
    }

    private void initTextView(@StyleRes int textAppearanceResId, String text, String hint) {
        if (textAppearanceResId != -1) {
            TextViewCompat.setTextAppearance((TextView)this.textView, (int)textAppearanceResId);
        }
        this.setText(text);
        this.setHint(hint);
        if (this.getNavigationIcon() == null) {
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)this.textView.getLayoutParams()), (int)this.getResources().getDimensionPixelSize(R.dimen.m3_searchbar_text_margin_start_no_navigation_icon));
        }
    }

    private void initBackground(ShapeAppearanceModel shapeAppearance, float elevation, float strokeWidth, @ColorInt int strokeColor) {
        MaterialShapeDrawable background;
        this.backgroundShape = new MaterialShapeDrawable(shapeAppearance);
        this.backgroundShape.initializeElevationOverlay(this.getContext());
        this.backgroundShape.setElevation(elevation);
        if (strokeWidth >= 0.0f) {
            this.backgroundShape.setStroke(strokeWidth, strokeColor);
        }
        int backgroundColor = MaterialColors.getColor((View)this, R.attr.colorSurface);
        int rippleColor = MaterialColors.getColor((View)this, R.attr.colorControlHighlight);
        if (Build.VERSION.SDK_INT >= 21) {
            this.backgroundShape.setFillColor(ColorStateList.valueOf((int)backgroundColor));
            background = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), (Drawable)this.backgroundShape, (Drawable)this.backgroundShape);
        } else {
            this.backgroundShape.setFillColor(this.getCompatBackgroundColorStateList(backgroundColor, rippleColor));
            background = this.backgroundShape;
        }
        ViewCompat.setBackground((View)this, (Drawable)background);
    }

    private ColorStateList getCompatBackgroundColorStateList(@ColorInt int backgroundColor, @ColorInt int rippleColor) {
        int[][] states = new int[][]{{16842919}, {16842908}, new int[0]};
        int pressedBackgroundColor = MaterialColors.layer(backgroundColor, rippleColor);
        int[] colors = new int[]{pressedBackgroundColor, pressedBackgroundColor, backgroundColor};
        return new ColorStateList((int[][])states, colors);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.layoutInflated && this.centerView == null && !(child instanceof ActionMenuView)) {
            this.centerView = child;
            this.centerView.setAlpha(0.0f);
        }
        super.addView(child, index, params);
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        if (this.backgroundShape != null) {
            this.backgroundShape.setElevation(elevation);
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)EditText.class.getCanonicalName());
        CharSequence text = this.getText();
        boolean isTextEmpty = TextUtils.isEmpty((CharSequence)text);
        if (Build.VERSION.SDK_INT >= 26) {
            info.setHintText(this.getHint());
            info.setShowingHintText(isTextEmpty);
        }
        if (isTextEmpty) {
            text = this.getHint();
        }
        info.setText(text);
    }

    public void setNavigationOnClickListener(View.OnClickListener listener) {
        if (this.forceDefaultNavigationOnClickListener) {
            return;
        }
        super.setNavigationOnClickListener(listener);
        this.setNavigationIconDecorative(listener == null);
    }

    public void setNavigationIcon(@Nullable Drawable navigationIcon) {
        super.setNavigationIcon(this.maybeTintNavigationIcon(navigationIcon));
    }

    @Nullable
    private Drawable maybeTintNavigationIcon(@Nullable Drawable navigationIcon) {
        int navigationIconColor;
        if (!this.tintNavigationIcon || navigationIcon == null) {
            return navigationIcon;
        }
        if (this.navigationIconTint != null) {
            navigationIconColor = this.navigationIconTint;
        } else {
            int navigationIconColorAttr = navigationIcon == this.defaultNavigationIcon ? R.attr.colorOnSurfaceVariant : R.attr.colorOnSurface;
            navigationIconColor = MaterialColors.getColor((View)this, navigationIconColorAttr);
        }
        Drawable wrappedNavigationIcon = DrawableCompat.wrap((Drawable)navigationIcon.mutate());
        DrawableCompat.setTint((Drawable)wrappedNavigationIcon, (int)navigationIconColor);
        return wrappedNavigationIcon;
    }

    private void setNavigationIconDecorative(boolean decorative) {
        ImageButton navigationIconButton = ToolbarUtils.getNavigationIconButton(this);
        if (navigationIconButton == null) {
            return;
        }
        navigationIconButton.setClickable(!decorative);
        navigationIconButton.setFocusable(!decorative);
        Drawable navigationIconBackground = navigationIconButton.getBackground();
        if (navigationIconBackground != null) {
            this.originalNavigationIconBackground = navigationIconBackground;
        }
        navigationIconButton.setBackgroundDrawable(decorative ? null : this.originalNavigationIconBackground);
    }

    public void inflateMenu(@MenuRes int resId) {
        super.inflateMenu(resId);
        this.menuResId = resId;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureCenterView(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layoutCenterView();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.backgroundShape);
        this.setDefaultMargins();
        this.setOrClearDefaultScrollFlags();
    }

    public void setTitle(CharSequence title) {
    }

    public void setSubtitle(CharSequence subtitle) {
    }

    private void setDefaultMargins() {
        if (this.defaultMarginsEnabled && this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            Resources resources = this.getResources();
            int marginHorizontal = resources.getDimensionPixelSize(R.dimen.m3_searchbar_margin_horizontal);
            int marginVertical = resources.getDimensionPixelSize(R.dimen.m3_searchbar_margin_vertical);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            lp.leftMargin = this.defaultIfZero(lp.leftMargin, marginHorizontal);
            lp.topMargin = this.defaultIfZero(lp.topMargin, marginVertical);
            lp.rightMargin = this.defaultIfZero(lp.rightMargin, marginHorizontal);
            lp.bottomMargin = this.defaultIfZero(lp.bottomMargin, marginVertical);
        }
    }

    private int defaultIfZero(int value, int defValue) {
        return value == 0 ? defValue : value;
    }

    private void setOrClearDefaultScrollFlags() {
        if (this.getLayoutParams() instanceof AppBarLayout.LayoutParams) {
            AppBarLayout.LayoutParams lp = (AppBarLayout.LayoutParams)this.getLayoutParams();
            if (this.defaultScrollFlagsEnabled) {
                if (lp.getScrollFlags() == 0) {
                    lp.setScrollFlags(53);
                }
            } else if (lp.getScrollFlags() == 53) {
                lp.setScrollFlags(0);
            }
        }
    }

    private void measureCenterView(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.centerView != null) {
            this.centerView.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void layoutCenterView() {
        if (this.centerView == null) {
            return;
        }
        int centerViewWidth = this.centerView.getMeasuredWidth();
        int left = this.getMeasuredWidth() / 2 - centerViewWidth / 2;
        int right = left + centerViewWidth;
        int centerViewHeight = this.centerView.getMeasuredHeight();
        int top = this.getMeasuredHeight() / 2 - centerViewHeight / 2;
        int bottom = top + centerViewHeight;
        this.layoutChild(this.centerView, left, top, right, bottom);
    }

    private void layoutChild(View child, int left, int top, int right, int bottom) {
        if (ViewCompat.getLayoutDirection((View)this) == 1) {
            child.layout(this.getMeasuredWidth() - right, top, this.getMeasuredWidth() - left, bottom);
        } else {
            child.layout(left, top, right, bottom);
        }
    }

    @Nullable
    public View getCenterView() {
        return this.centerView;
    }

    public void setCenterView(@Nullable View view) {
        if (this.centerView != null) {
            this.removeView(this.centerView);
            this.centerView = null;
        }
        if (view != null) {
            this.addView(view);
        }
    }

    @NonNull
    public TextView getTextView() {
        return this.textView;
    }

    @Nullable
    public CharSequence getText() {
        return this.textView.getText();
    }

    public void setText(@Nullable CharSequence text) {
        this.textView.setText(text);
    }

    public void setText(@StringRes int textResId) {
        this.textView.setText(textResId);
    }

    public void clearText() {
        this.textView.setText((CharSequence)"");
    }

    @Nullable
    public CharSequence getHint() {
        return this.textView.getHint();
    }

    public void setHint(@Nullable CharSequence hint) {
        this.textView.setHint(hint);
    }

    public void setHint(@StringRes int hintResId) {
        this.textView.setHint(hintResId);
    }

    @ColorInt
    public int getStrokeColor() {
        return this.backgroundShape.getStrokeColor().getDefaultColor();
    }

    public void setStrokeColor(@ColorInt int strokeColor) {
        if (this.getStrokeColor() != strokeColor) {
            this.backgroundShape.setStrokeColor(ColorStateList.valueOf((int)strokeColor));
        }
    }

    @Dimension
    public float getStrokeWidth() {
        return this.backgroundShape.getStrokeWidth();
    }

    public void setStrokeWidth(@Dimension float strokeWidth) {
        if (this.getStrokeWidth() != strokeWidth) {
            this.backgroundShape.setStrokeWidth(strokeWidth);
        }
    }

    public float getCornerSize() {
        return this.backgroundShape.getTopLeftCornerResolvedSize();
    }

    public boolean isDefaultScrollFlagsEnabled() {
        return this.defaultScrollFlagsEnabled;
    }

    public void setDefaultScrollFlagsEnabled(boolean defaultScrollFlagsEnabled) {
        this.defaultScrollFlagsEnabled = defaultScrollFlagsEnabled;
        this.setOrClearDefaultScrollFlags();
    }

    public void startOnLoadAnimation() {
        this.post(() -> this.searchBarAnimationHelper.startOnLoadAnimation(this));
    }

    public void stopOnLoadAnimation() {
        this.searchBarAnimationHelper.stopOnLoadAnimation(this);
    }

    public boolean isOnLoadAnimationFadeInEnabled() {
        return this.searchBarAnimationHelper.isOnLoadAnimationFadeInEnabled();
    }

    public void setOnLoadAnimationFadeInEnabled(boolean onLoadAnimationFadeInEnabled) {
        this.searchBarAnimationHelper.setOnLoadAnimationFadeInEnabled(onLoadAnimationFadeInEnabled);
    }

    public void addOnLoadAnimationCallback(@NonNull OnLoadAnimationCallback onLoadAnimationCallback) {
        this.searchBarAnimationHelper.addOnLoadAnimationCallback(onLoadAnimationCallback);
    }

    public boolean removeOnLoadAnimationCallback(@NonNull OnLoadAnimationCallback onLoadAnimationCallback) {
        return this.searchBarAnimationHelper.removeOnLoadAnimationCallback(onLoadAnimationCallback);
    }

    public boolean isExpanding() {
        return this.searchBarAnimationHelper.isExpanding();
    }

    @CanIgnoreReturnValue
    public boolean expand(@NonNull View expandedView) {
        return this.expand(expandedView, null);
    }

    @CanIgnoreReturnValue
    public boolean expand(@NonNull View expandedView, @Nullable AppBarLayout appBarLayout) {
        return this.expand(expandedView, appBarLayout, false);
    }

    @CanIgnoreReturnValue
    public boolean expand(@NonNull View expandedView, @Nullable AppBarLayout appBarLayout, boolean skipAnimation) {
        if (expandedView.getVisibility() != 0 && !this.isExpanding() || this.isCollapsing()) {
            this.searchBarAnimationHelper.startExpandAnimation(this, expandedView, appBarLayout, skipAnimation);
            return true;
        }
        return false;
    }

    public void addExpandAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        this.searchBarAnimationHelper.addExpandAnimationListener(listener);
    }

    public boolean removeExpandAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        return this.searchBarAnimationHelper.removeExpandAnimationListener(listener);
    }

    public boolean isCollapsing() {
        return this.searchBarAnimationHelper.isCollapsing();
    }

    @CanIgnoreReturnValue
    public boolean collapse(@NonNull View expandedView) {
        return this.collapse(expandedView, null);
    }

    @CanIgnoreReturnValue
    public boolean collapse(@NonNull View expandedView, @Nullable AppBarLayout appBarLayout) {
        return this.collapse(expandedView, appBarLayout, false);
    }

    @CanIgnoreReturnValue
    public boolean collapse(@NonNull View expandedView, @Nullable AppBarLayout appBarLayout, boolean skipAnimation) {
        if (expandedView.getVisibility() == 0 && !this.isCollapsing() || this.isExpanding()) {
            this.searchBarAnimationHelper.startCollapseAnimation(this, expandedView, appBarLayout, skipAnimation);
            return true;
        }
        return false;
    }

    public void addCollapseAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        this.searchBarAnimationHelper.addCollapseAnimationListener(listener);
    }

    public boolean removeCollapseAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        return this.searchBarAnimationHelper.removeCollapseAnimationListener(listener);
    }

    int getMenuResId() {
        return this.menuResId;
    }

    float getCompatElevation() {
        return this.backgroundShape != null ? this.backgroundShape.getElevation() : ViewCompat.getElevation((View)this);
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        CharSequence text = this.getText();
        savedState.text = text == null ? null : text.toString();
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setText(savedState.text);
    }

    static class SavedState
    extends AbsSavedState {
        String text;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            this(source, null);
        }

        public SavedState(Parcel source, @Nullable ClassLoader classLoader) {
            super(source, classLoader);
            this.text = source.readString();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.text);
        }
    }

    public static abstract class OnLoadAnimationCallback {
        public void onAnimationStart() {
        }

        public void onAnimationEnd() {
        }
    }

    public static class ScrollingViewBehavior
    extends AppBarLayout.ScrollingViewBehavior {
        private boolean initialized = false;

        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
        }

        @Override
        public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
            boolean changed = super.onDependentViewChanged(parent, child, dependency);
            if (!this.initialized && dependency instanceof AppBarLayout) {
                this.initialized = true;
                AppBarLayout appBarLayout = (AppBarLayout)dependency;
                this.setAppBarLayoutTransparent(appBarLayout);
            }
            return changed;
        }

        private void setAppBarLayoutTransparent(AppBarLayout appBarLayout) {
            appBarLayout.setBackgroundColor(0);
            if (Build.VERSION.SDK_INT == 21) {
                appBarLayout.setOutlineProvider(null);
            } else {
                appBarLayout.setTargetElevation(0.0f);
            }
        }

        @Override
        protected boolean shouldHeaderOverlapScrollingChild() {
            return true;
        }
    }
}

