/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.search;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.graphics.drawable.DrawerArrowDrawable;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.appbar.MaterialToolbar;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.elevation.ElevationOverlayProvider;
import com.google.android.material.internal.ClippableRoundedCornerLayout;
import com.google.android.material.internal.ContextUtils;
import com.google.android.material.internal.FadeThroughDrawable;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.internal.TouchObserverFrameLayout;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.search.SearchBar;
import com.google.android.material.search.SearchViewAnimationHelper;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SearchView
extends FrameLayout
implements CoordinatorLayout.AttachedBehavior {
    private static final long TALKBACK_FOCUS_CHANGE_DELAY_MS = 100L;
    private static final int DEF_STYLE_RES = R.style.Widget_Material3_SearchView;
    final View scrim;
    final ClippableRoundedCornerLayout rootView;
    final View backgroundView;
    final View statusBarSpacer;
    final FrameLayout headerContainer;
    final FrameLayout toolbarContainer;
    final MaterialToolbar toolbar;
    final Toolbar dummyToolbar;
    final TextView searchPrefix;
    final EditText editText;
    final ImageButton clearButton;
    final View divider;
    final TouchObserverFrameLayout contentContainer;
    private final boolean layoutInflated;
    private final SearchViewAnimationHelper searchViewAnimationHelper;
    private final ElevationOverlayProvider elevationOverlayProvider;
    private final Set<TransitionListener> transitionListeners = new LinkedHashSet<TransitionListener>();
    @Nullable
    private SearchBar searchBar;
    private int softInputMode = 16;
    private boolean animatedNavigationIcon;
    private boolean animatedMenuItems;
    private boolean autoShowKeyboard;
    private boolean useWindowInsetsController;
    private boolean statusBarSpacerEnabledOverride;
    @NonNull
    private TransitionState currentTransitionState = TransitionState.HIDDEN;
    private Map<View, Integer> childImportantForAccessibilityMap;

    public SearchView(@NonNull Context context) {
        this(context, null);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialSearchViewStyle);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.SearchView, defStyleAttr, DEF_STYLE_RES, new int[0]);
        int headerLayoutResId = a.getResourceId(R.styleable.SearchView_headerLayout, -1);
        int textAppearanceResId = a.getResourceId(R.styleable.SearchView_android_textAppearance, -1);
        String text = a.getString(R.styleable.SearchView_android_text);
        String hint = a.getString(R.styleable.SearchView_android_hint);
        String searchPrefixText = a.getString(R.styleable.SearchView_searchPrefixText);
        boolean useDrawerArrowDrawable = a.getBoolean(R.styleable.SearchView_useDrawerArrowDrawable, false);
        this.animatedNavigationIcon = a.getBoolean(R.styleable.SearchView_animateNavigationIcon, true);
        this.animatedMenuItems = a.getBoolean(R.styleable.SearchView_animateMenuItems, true);
        boolean hideNavigationIcon = a.getBoolean(R.styleable.SearchView_hideNavigationIcon, false);
        this.autoShowKeyboard = a.getBoolean(R.styleable.SearchView_autoShowKeyboard, true);
        a.recycle();
        LayoutInflater.from((Context)context).inflate(R.layout.mtrl_search_view, (ViewGroup)this);
        this.layoutInflated = true;
        this.scrim = this.findViewById(R.id.search_view_scrim);
        this.rootView = (ClippableRoundedCornerLayout)this.findViewById(R.id.search_view_root);
        this.backgroundView = this.findViewById(R.id.search_view_background);
        this.statusBarSpacer = this.findViewById(R.id.search_view_status_bar_spacer);
        this.headerContainer = (FrameLayout)this.findViewById(R.id.search_view_header_container);
        this.toolbarContainer = (FrameLayout)this.findViewById(R.id.search_view_toolbar_container);
        this.toolbar = (MaterialToolbar)this.findViewById(R.id.search_view_toolbar);
        this.dummyToolbar = (Toolbar)this.findViewById(R.id.search_view_dummy_toolbar);
        this.searchPrefix = (TextView)this.findViewById(R.id.search_view_search_prefix);
        this.editText = (EditText)this.findViewById(R.id.search_view_edit_text);
        this.clearButton = (ImageButton)this.findViewById(R.id.search_view_clear_button);
        this.divider = this.findViewById(R.id.search_view_divider);
        this.contentContainer = (TouchObserverFrameLayout)this.findViewById(R.id.search_view_content_container);
        this.searchViewAnimationHelper = new SearchViewAnimationHelper(this);
        this.elevationOverlayProvider = new ElevationOverlayProvider(context);
        this.setUpRootView();
        this.setUpBackgroundViewElevationOverlay();
        this.setUpHeaderLayout(headerLayoutResId);
        this.setSearchPrefixText(searchPrefixText);
        this.setUpEditText(textAppearanceResId, text, hint);
        this.setUpBackButton(useDrawerArrowDrawable, hideNavigationIcon);
        this.setUpClearButton();
        this.setUpContentOnTouchListener();
        this.setUpInsetListeners();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.layoutInflated) {
            this.contentContainer.addView(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateSoftInputMode();
    }

    @RequiresApi(value=21)
    public void setElevation(float elevation) {
        super.setElevation(elevation);
        this.setUpBackgroundViewElevationOverlay(elevation);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    @NonNull
    public CoordinatorLayout.Behavior<SearchView> getBehavior() {
        return new Behavior();
    }

    @Nullable
    private Window getActivityWindow() {
        Activity activity = ContextUtils.getActivity(this.getContext());
        return activity == null ? null : activity.getWindow();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setUpRootView() {
        this.rootView.setOnTouchListener((v, event) -> true);
    }

    private void setUpBackgroundViewElevationOverlay() {
        this.setUpBackgroundViewElevationOverlay(this.getOverlayElevation());
    }

    private void setUpBackgroundViewElevationOverlay(float elevation) {
        if (this.elevationOverlayProvider == null || this.backgroundView == null) {
            return;
        }
        int backgroundColor = this.elevationOverlayProvider.compositeOverlayWithThemeSurfaceColorIfNeeded(elevation);
        this.backgroundView.setBackgroundColor(backgroundColor);
    }

    private float getOverlayElevation() {
        if (this.searchBar != null) {
            return this.searchBar.getCompatElevation();
        }
        return this.getResources().getDimension(R.dimen.m3_searchview_elevation);
    }

    private void setUpHeaderLayout(int headerLayoutResId) {
        if (headerLayoutResId != -1) {
            View headerView = LayoutInflater.from((Context)this.getContext()).inflate(headerLayoutResId, (ViewGroup)this.headerContainer, false);
            this.addHeaderView(headerView);
        }
    }

    private void setUpEditText(@StyleRes int textAppearanceResId, String text, String hint) {
        if (textAppearanceResId != -1) {
            TextViewCompat.setTextAppearance((TextView)this.editText, (int)textAppearanceResId);
        }
        this.editText.setText((CharSequence)text);
        this.editText.setHint((CharSequence)hint);
    }

    private void setUpBackButton(boolean useDrawerArrowDrawable, boolean hideNavigationIcon) {
        if (hideNavigationIcon) {
            this.toolbar.setNavigationIcon(null);
            return;
        }
        this.toolbar.setNavigationOnClickListener(v -> this.hide());
        if (useDrawerArrowDrawable) {
            DrawerArrowDrawable drawerArrowDrawable = new DrawerArrowDrawable(this.getContext());
            drawerArrowDrawable.setColor(MaterialColors.getColor((View)this, R.attr.colorOnSurface));
            this.toolbar.setNavigationIcon((Drawable)drawerArrowDrawable);
        }
    }

    private void setUpClearButton() {
        this.clearButton.setOnClickListener(v -> {
            this.clearText();
            this.requestFocusAndShowKeyboardIfNeeded();
        });
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                SearchView.this.clearButton.setVisibility(s.length() > 0 ? 0 : 8);
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setUpContentOnTouchListener() {
        this.contentContainer.setOnTouchListener((v, event) -> {
            if (this.isAdjustNothingSoftInputMode()) {
                this.clearFocusAndHideKeyboard();
            }
            return false;
        });
    }

    private void setUpStatusBarSpacer(@Px int height) {
        if (this.statusBarSpacer.getLayoutParams().height != height) {
            this.statusBarSpacer.getLayoutParams().height = height;
            this.statusBarSpacer.requestLayout();
        }
    }

    @Px
    private int getStatusBarHeight() {
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return this.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private void updateNavigationIconIfNeeded() {
        if (this.toolbar == null) {
            return;
        }
        if (this.isNavigationIconDrawerArrowDrawable(this.toolbar)) {
            return;
        }
        int navigationIcon = R.drawable.ic_arrow_back_black_24;
        if (this.searchBar == null) {
            this.toolbar.setNavigationIcon(navigationIcon);
        } else {
            Drawable navigationIconDrawable = DrawableCompat.wrap((Drawable)AppCompatResources.getDrawable((Context)this.getContext(), (int)navigationIcon).mutate());
            if (this.toolbar.getNavigationIconTint() != null) {
                DrawableCompat.setTint((Drawable)navigationIconDrawable, (int)this.toolbar.getNavigationIconTint());
            }
            this.toolbar.setNavigationIcon(new FadeThroughDrawable(this.searchBar.getNavigationIcon(), navigationIconDrawable));
            this.updateNavigationIconProgressIfNeeded();
        }
    }

    private boolean isNavigationIconDrawerArrowDrawable(@NonNull Toolbar toolbar) {
        return DrawableCompat.unwrap((Drawable)toolbar.getNavigationIcon()) instanceof DrawerArrowDrawable;
    }

    private void setUpInsetListeners() {
        this.setUpToolbarInsetListener();
        this.setUpDividerInsetListener();
        this.setUpStatusBarSpacerInsetListener();
    }

    private void setUpToolbarInsetListener() {
        ViewUtils.doOnApplyWindowInsets((View)this.toolbar, (view, insets, initialPadding) -> {
            boolean isRtl = ViewUtils.isLayoutRtl((View)this.toolbar);
            int paddingLeft = isRtl ? initialPadding.end : initialPadding.start;
            int paddingRight = isRtl ? initialPadding.start : initialPadding.end;
            this.toolbar.setPadding(paddingLeft + insets.getSystemWindowInsetLeft(), initialPadding.top, paddingRight + insets.getSystemWindowInsetRight(), initialPadding.bottom);
            return insets;
        });
    }

    private void setUpStatusBarSpacerInsetListener() {
        this.setUpStatusBarSpacer(this.getStatusBarHeight());
        ViewCompat.setOnApplyWindowInsetsListener((View)this.statusBarSpacer, (v, insets) -> {
            int systemWindowInsetTop = insets.getSystemWindowInsetTop();
            this.setUpStatusBarSpacer(systemWindowInsetTop);
            if (!this.statusBarSpacerEnabledOverride) {
                this.setStatusBarSpacerEnabledInternal(systemWindowInsetTop > 0);
            }
            return insets;
        });
    }

    private void setUpDividerInsetListener() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.divider.getLayoutParams();
        int leftMargin = layoutParams.leftMargin;
        int rightMargin = layoutParams.rightMargin;
        ViewCompat.setOnApplyWindowInsetsListener((View)this.divider, (v, insets) -> {
            layoutParams.leftMargin = leftMargin + insets.getSystemWindowInsetLeft();
            layoutParams.rightMargin = rightMargin + insets.getSystemWindowInsetRight();
            return insets;
        });
    }

    public boolean isSetupWithSearchBar() {
        return this.searchBar != null;
    }

    public void setupWithSearchBar(@Nullable SearchBar searchBar) {
        this.searchBar = searchBar;
        this.searchViewAnimationHelper.setSearchBar(searchBar);
        if (searchBar != null) {
            searchBar.setOnClickListener(v -> this.show());
        }
        this.updateNavigationIconIfNeeded();
        this.setUpBackgroundViewElevationOverlay();
    }

    public void addHeaderView(@NonNull View headerView) {
        this.headerContainer.addView(headerView);
        this.headerContainer.setVisibility(0);
    }

    public void removeHeaderView(@NonNull View headerView) {
        this.headerContainer.removeView(headerView);
        if (this.headerContainer.getChildCount() == 0) {
            this.headerContainer.setVisibility(8);
        }
    }

    public void removeAllHeaderViews() {
        this.headerContainer.removeAllViews();
        this.headerContainer.setVisibility(8);
    }

    public void setAnimatedNavigationIcon(boolean animatedNavigationIcon) {
        this.animatedNavigationIcon = animatedNavigationIcon;
    }

    public boolean isAnimatedNavigationIcon() {
        return this.animatedNavigationIcon;
    }

    public void setMenuItemsAnimated(boolean menuItemsAnimated) {
        this.animatedMenuItems = menuItemsAnimated;
    }

    public boolean isMenuItemsAnimated() {
        return this.animatedMenuItems;
    }

    public void setAutoShowKeyboard(boolean autoShowKeyboard) {
        this.autoShowKeyboard = autoShowKeyboard;
    }

    public boolean isAutoShowKeyboard() {
        return this.autoShowKeyboard;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setUseWindowInsetsController(boolean useWindowInsetsController) {
        this.useWindowInsetsController = useWindowInsetsController;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isUseWindowInsetsController() {
        return this.useWindowInsetsController;
    }

    public void addTransitionListener(@NonNull TransitionListener transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    public void removeTransitionListener(@NonNull TransitionListener transitionListener) {
        this.transitionListeners.remove(transitionListener);
    }

    public void inflateMenu(@MenuRes int menuResId) {
        this.toolbar.inflateMenu(menuResId);
    }

    public void setOnMenuItemClickListener(@Nullable Toolbar.OnMenuItemClickListener onMenuItemClickListener) {
        this.toolbar.setOnMenuItemClickListener(onMenuItemClickListener);
    }

    @NonNull
    public TextView getSearchPrefix() {
        return this.searchPrefix;
    }

    public void setSearchPrefixText(@Nullable CharSequence searchPrefixText) {
        this.searchPrefix.setText(searchPrefixText);
        this.searchPrefix.setVisibility(TextUtils.isEmpty((CharSequence)searchPrefixText) ? 8 : 0);
    }

    @Nullable
    public CharSequence getSearchPrefixText() {
        return this.searchPrefix.getText();
    }

    @NonNull
    public Toolbar getToolbar() {
        return this.toolbar;
    }

    @NonNull
    public EditText getEditText() {
        return this.editText;
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    @Nullable
    public Editable getText() {
        return this.editText.getText();
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    public void setText(@Nullable CharSequence text) {
        this.editText.setText(text);
    }

    public void setText(@StringRes int textResId) {
        this.editText.setText(textResId);
    }

    public void clearText() {
        this.editText.setText((CharSequence)"");
    }

    @Nullable
    public CharSequence getHint() {
        return this.editText.getHint();
    }

    public void setHint(@Nullable CharSequence hint) {
        this.editText.setHint(hint);
    }

    public void setHint(@StringRes int hintResId) {
        this.editText.setHint(hintResId);
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    public int getSoftInputMode() {
        return this.softInputMode;
    }

    public void updateSoftInputMode() {
        Window window = this.getActivityWindow();
        if (window != null) {
            this.softInputMode = window.getAttributes().softInputMode;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setStatusBarSpacerEnabled(boolean enabled) {
        this.statusBarSpacerEnabledOverride = true;
        this.setStatusBarSpacerEnabledInternal(enabled);
    }

    private void setStatusBarSpacerEnabledInternal(boolean enabled) {
        this.statusBarSpacer.setVisibility(enabled ? 0 : 8);
    }

    @NonNull
    public TransitionState getCurrentTransitionState() {
        return this.currentTransitionState;
    }

    void setTransitionState(@NonNull TransitionState state) {
        if (this.currentTransitionState.equals((Object)state)) {
            return;
        }
        TransitionState previousState = this.currentTransitionState;
        this.currentTransitionState = state;
        LinkedHashSet<TransitionListener> listeners = new LinkedHashSet<TransitionListener>(this.transitionListeners);
        for (TransitionListener listener : listeners) {
            listener.onStateChanged(this, previousState, state);
        }
    }

    public boolean isShowing() {
        return this.currentTransitionState.equals((Object)TransitionState.SHOWN) || this.currentTransitionState.equals((Object)TransitionState.SHOWING);
    }

    public void show() {
        if (this.currentTransitionState.equals((Object)TransitionState.SHOWN) || this.currentTransitionState.equals((Object)TransitionState.SHOWING)) {
            return;
        }
        this.searchViewAnimationHelper.show();
        this.setModalForAccessibility(true);
    }

    public void hide() {
        if (this.currentTransitionState.equals((Object)TransitionState.HIDDEN) || this.currentTransitionState.equals((Object)TransitionState.HIDING)) {
            return;
        }
        this.searchViewAnimationHelper.hide();
        this.setModalForAccessibility(false);
    }

    public void setVisible(boolean visible) {
        boolean wasVisible = this.rootView.getVisibility() == 0;
        this.rootView.setVisibility(visible ? 0 : 8);
        this.updateNavigationIconProgressIfNeeded();
        if (wasVisible != visible) {
            this.setModalForAccessibility(visible);
        }
        this.setTransitionState(visible ? TransitionState.SHOWN : TransitionState.HIDDEN);
    }

    private void updateNavigationIconProgressIfNeeded() {
        ImageButton backButton = ToolbarUtils.getNavigationIconButton(this.toolbar);
        if (backButton == null) {
            return;
        }
        boolean progress = this.rootView.getVisibility() == 0;
        Drawable drawable2 = DrawableCompat.unwrap((Drawable)backButton.getDrawable());
        if (drawable2 instanceof DrawerArrowDrawable) {
            ((DrawerArrowDrawable)drawable2).setProgress((float)progress);
        }
        if (drawable2 instanceof FadeThroughDrawable) {
            ((FadeThroughDrawable)drawable2).setProgress((float)progress);
        }
    }

    void requestFocusAndShowKeyboardIfNeeded() {
        if (this.autoShowKeyboard) {
            this.requestFocusAndShowKeyboard();
        }
    }

    public void requestFocusAndShowKeyboard() {
        this.editText.postDelayed(() -> {
            if (this.editText.requestFocus()) {
                this.editText.sendAccessibilityEvent(8);
            }
            ViewUtils.showKeyboard((View)this.editText, this.useWindowInsetsController);
        }, 100L);
    }

    public void clearFocusAndHideKeyboard() {
        this.editText.post(() -> {
            this.editText.clearFocus();
            if (this.searchBar != null) {
                this.searchBar.requestFocus();
            }
            ViewUtils.hideKeyboard((View)this.editText, this.useWindowInsetsController);
        });
    }

    boolean isAdjustNothingSoftInputMode() {
        return this.softInputMode == 48;
    }

    public void setModalForAccessibility(boolean isSearchViewModal) {
        ViewGroup rootView = (ViewGroup)this.getRootView();
        if (Build.VERSION.SDK_INT >= 16 && isSearchViewModal) {
            this.childImportantForAccessibilityMap = new HashMap<View, Integer>(rootView.getChildCount());
        }
        this.updateChildImportantForAccessibility(rootView, isSearchViewModal);
        if (!isSearchViewModal) {
            this.childImportantForAccessibilityMap = null;
        }
    }

    public void setToolbarTouchscreenBlocksFocus(boolean touchscreenBlocksFocus) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.toolbar.setTouchscreenBlocksFocus(touchscreenBlocksFocus);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void updateChildImportantForAccessibility(ViewGroup parent, boolean isSearchViewModal) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (child == this) continue;
            if (child.findViewById(this.rootView.getId()) != null) {
                this.updateChildImportantForAccessibility((ViewGroup)child, isSearchViewModal);
                continue;
            }
            if (!isSearchViewModal) {
                if (this.childImportantForAccessibilityMap == null || !this.childImportantForAccessibilityMap.containsKey(child)) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)this.childImportantForAccessibilityMap.get(child));
                continue;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.childImportantForAccessibilityMap.put(child, child.getImportantForAccessibility());
            }
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        }
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        Editable text = this.getText();
        savedState.text = text == null ? null : text.toString();
        savedState.visibility = this.rootView.getVisibility();
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setText(savedState.text);
        this.setVisible(savedState.visibility == 0);
    }

    static class SavedState
    extends AbsSavedState {
        String text;
        int visibility;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            this(source, null);
        }

        public SavedState(Parcel source, @Nullable ClassLoader classLoader) {
            super(source, classLoader);
            this.text = source.readString();
            this.visibility = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.text);
            dest.writeInt(this.visibility);
        }
    }

    public static enum TransitionState {
        HIDING,
        HIDDEN,
        SHOWING,
        SHOWN;

    }

    public static interface TransitionListener {
        public void onStateChanged(@NonNull SearchView var1, @NonNull TransitionState var2, @NonNull TransitionState var3);
    }

    public static class Behavior
    extends CoordinatorLayout.Behavior<SearchView> {
        public Behavior() {
        }

        public Behavior(@NonNull Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, @NonNull SearchView child, @NonNull View dependency) {
            if (!child.isSetupWithSearchBar() && dependency instanceof SearchBar) {
                child.setupWithSearchBar((SearchBar)dependency);
            }
            return false;
        }
    }
}

