/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;

class CutoutDrawable
extends MaterialShapeDrawable {
    @NonNull
    CutoutDrawableState drawableState;

    static CutoutDrawable create(@Nullable ShapeAppearanceModel shapeAppearanceModel) {
        return CutoutDrawable.create(new CutoutDrawableState(shapeAppearanceModel != null ? shapeAppearanceModel : new ShapeAppearanceModel(), new RectF()));
    }

    private static CutoutDrawable create(@NonNull CutoutDrawableState drawableState) {
        return Build.VERSION.SDK_INT >= 18 ? new ImplApi18(drawableState) : new ImplApi14(drawableState);
    }

    private CutoutDrawable(@NonNull CutoutDrawableState drawableState) {
        super(drawableState);
        this.drawableState = drawableState;
    }

    @Override
    @NonNull
    public Drawable mutate() {
        this.drawableState = new CutoutDrawableState(this.drawableState);
        return this;
    }

    boolean hasCutout() {
        return !this.drawableState.cutoutBounds.isEmpty();
    }

    void setCutout(float left, float top, float right, float bottom) {
        if (left != ((CutoutDrawableState)this.drawableState).cutoutBounds.left || top != ((CutoutDrawableState)this.drawableState).cutoutBounds.top || right != ((CutoutDrawableState)this.drawableState).cutoutBounds.right || bottom != ((CutoutDrawableState)this.drawableState).cutoutBounds.bottom) {
            this.drawableState.cutoutBounds.set(left, top, right, bottom);
            this.invalidateSelf();
        }
    }

    void setCutout(@NonNull RectF bounds) {
        this.setCutout(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    void removeCutout() {
        this.setCutout(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private static final class CutoutDrawableState
    extends MaterialShapeDrawable.MaterialShapeDrawableState {
        @NonNull
        private final RectF cutoutBounds;

        private CutoutDrawableState(@NonNull ShapeAppearanceModel shapeAppearanceModel, @NonNull RectF cutoutBounds) {
            super(shapeAppearanceModel, null);
            this.cutoutBounds = cutoutBounds;
        }

        private CutoutDrawableState(@NonNull CutoutDrawableState state) {
            super(state);
            this.cutoutBounds = state.cutoutBounds;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            CutoutDrawable drawable2 = CutoutDrawable.create(this);
            drawable2.invalidateSelf();
            return drawable2;
        }
    }

    private static class ImplApi14
    extends CutoutDrawable {
        private Paint cutoutPaint;
        private int savedLayer;

        ImplApi14(@NonNull CutoutDrawableState drawableState) {
            super(drawableState);
        }

        @Override
        public void draw(@NonNull Canvas canvas) {
            this.preDraw(canvas);
            super.draw(canvas);
            this.postDraw(canvas);
        }

        @Override
        protected void drawStrokeShape(@NonNull Canvas canvas) {
            super.drawStrokeShape(canvas);
            canvas.drawRect(this.drawableState.cutoutBounds, this.getCutoutPaint());
        }

        private Paint getCutoutPaint() {
            if (this.cutoutPaint == null) {
                this.cutoutPaint = new Paint(1);
                this.cutoutPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                this.cutoutPaint.setColor(-1);
                this.cutoutPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            }
            return this.cutoutPaint;
        }

        private void preDraw(@NonNull Canvas canvas) {
            Drawable.Callback callback = this.getCallback();
            if (this.useHardwareLayer(callback)) {
                View viewCallback = (View)callback;
                if (viewCallback.getLayerType() != 2) {
                    viewCallback.setLayerType(2, null);
                }
            } else {
                this.saveCanvasLayer(canvas);
            }
        }

        private void saveCanvasLayer(@NonNull Canvas canvas) {
            this.savedLayer = Build.VERSION.SDK_INT >= 21 ? canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null) : canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null, 31);
        }

        private void postDraw(@NonNull Canvas canvas) {
            if (!this.useHardwareLayer(this.getCallback())) {
                canvas.restoreToCount(this.savedLayer);
            }
        }

        private boolean useHardwareLayer(Drawable.Callback callback) {
            return callback instanceof View;
        }
    }

    @TargetApi(value=18)
    private static class ImplApi18
    extends CutoutDrawable {
        ImplApi18(@NonNull CutoutDrawableState drawableState) {
            super(drawableState);
        }

        @Override
        protected void drawStrokeShape(@NonNull Canvas canvas) {
            if (this.drawableState.cutoutBounds.isEmpty()) {
                super.drawStrokeShape(canvas);
            } else {
                canvas.save();
                if (Build.VERSION.SDK_INT >= 26) {
                    canvas.clipOutRect(this.drawableState.cutoutBounds);
                } else {
                    canvas.clipRect(this.drawableState.cutoutBounds, Region.Op.DIFFERENCE);
                }
                super.drawStrokeShape(canvas);
                canvas.restore();
            }
        }
    }
}

