/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.DialogFragment;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.timepicker.TimeModel;
import com.google.android.material.timepicker.TimePickerClockPresenter;
import com.google.android.material.timepicker.TimePickerPresenter;
import com.google.android.material.timepicker.TimePickerTextInputPresenter;
import com.google.android.material.timepicker.TimePickerView;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashSet;
import java.util.Set;

public final class MaterialTimePicker
extends DialogFragment
implements TimePickerView.OnDoubleTapListener {
    private final Set<View.OnClickListener> positiveButtonListeners = new LinkedHashSet<View.OnClickListener>();
    private final Set<View.OnClickListener> negativeButtonListeners = new LinkedHashSet<View.OnClickListener>();
    private final Set<DialogInterface.OnCancelListener> cancelListeners = new LinkedHashSet<DialogInterface.OnCancelListener>();
    private final Set<DialogInterface.OnDismissListener> dismissListeners = new LinkedHashSet<DialogInterface.OnDismissListener>();
    private TimePickerView timePickerView;
    private ViewStub textInputStub;
    @Nullable
    private TimePickerClockPresenter timePickerClockPresenter;
    @Nullable
    private TimePickerTextInputPresenter timePickerTextInputPresenter;
    @Nullable
    private TimePickerPresenter activePresenter;
    @DrawableRes
    private int keyboardIcon;
    @DrawableRes
    private int clockIcon;
    @StringRes
    private int titleResId = 0;
    private CharSequence titleText;
    @StringRes
    private int positiveButtonTextResId = 0;
    private CharSequence positiveButtonText;
    @StringRes
    private int negativeButtonTextResId = 0;
    private CharSequence negativeButtonText;
    public static final int INPUT_MODE_CLOCK = 0;
    public static final int INPUT_MODE_KEYBOARD = 1;
    static final String TIME_MODEL_EXTRA = "TIME_PICKER_TIME_MODEL";
    static final String INPUT_MODE_EXTRA = "TIME_PICKER_INPUT_MODE";
    static final String TITLE_RES_EXTRA = "TIME_PICKER_TITLE_RES";
    static final String TITLE_TEXT_EXTRA = "TIME_PICKER_TITLE_TEXT";
    static final String POSITIVE_BUTTON_TEXT_RES_EXTRA = "TIME_PICKER_POSITIVE_BUTTON_TEXT_RES";
    static final String POSITIVE_BUTTON_TEXT_EXTRA = "TIME_PICKER_POSITIVE_BUTTON_TEXT";
    static final String NEGATIVE_BUTTON_TEXT_RES_EXTRA = "TIME_PICKER_NEGATIVE_BUTTON_TEXT_RES";
    static final String NEGATIVE_BUTTON_TEXT_EXTRA = "TIME_PICKER_NEGATIVE_BUTTON_TEXT";
    static final String OVERRIDE_THEME_RES_ID = "TIME_PICKER_OVERRIDE_THEME_RES_ID";
    private MaterialButton modeButton;
    private Button cancelButton;
    private int inputMode = 0;
    private TimeModel time;
    private int overrideThemeResId = 0;

    @NonNull
    private static MaterialTimePicker newInstance(@NonNull Builder options) {
        MaterialTimePicker fragment = new MaterialTimePicker();
        Bundle args = new Bundle();
        args.putParcelable(TIME_MODEL_EXTRA, (Parcelable)options.time);
        if (options.inputMode != null) {
            args.putInt(INPUT_MODE_EXTRA, options.inputMode.intValue());
        }
        args.putInt(TITLE_RES_EXTRA, options.titleTextResId);
        if (options.titleText != null) {
            args.putCharSequence(TITLE_TEXT_EXTRA, options.titleText);
        }
        args.putInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, options.positiveButtonTextResId);
        if (options.positiveButtonText != null) {
            args.putCharSequence(POSITIVE_BUTTON_TEXT_EXTRA, options.positiveButtonText);
        }
        args.putInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, options.negativeButtonTextResId);
        if (options.negativeButtonText != null) {
            args.putCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA, options.negativeButtonText);
        }
        args.putInt(OVERRIDE_THEME_RES_ID, options.overrideThemeResId);
        fragment.setArguments(args);
        return fragment;
    }

    @IntRange(from=0L, to=59L)
    public int getMinute() {
        return this.time.minute;
    }

    public void setMinute(@IntRange(from=0L, to=59L) int minute) {
        this.time.setMinute(minute);
        if (this.activePresenter != null) {
            this.activePresenter.invalidate();
        }
    }

    @IntRange(from=0L, to=23L)
    public int getHour() {
        return this.time.hour % 24;
    }

    public void setHour(@IntRange(from=0L, to=23L) int hour) {
        this.time.setHour(hour);
        if (this.activePresenter != null) {
            this.activePresenter.invalidate();
        }
    }

    public int getInputMode() {
        return this.inputMode;
    }

    @NonNull
    public final Dialog onCreateDialog(@Nullable Bundle bundle) {
        Dialog dialog = new Dialog(this.requireContext(), this.getThemeResId());
        Context context = dialog.getContext();
        int surfaceColor = MaterialAttributes.resolveOrThrow(context, R.attr.colorSurface, MaterialTimePicker.class.getCanonicalName());
        MaterialShapeDrawable background = new MaterialShapeDrawable(context, null, R.attr.materialTimePickerStyle, R.style.Widget_MaterialComponents_TimePicker);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.MaterialTimePicker, R.attr.materialTimePickerStyle, R.style.Widget_MaterialComponents_TimePicker);
        this.clockIcon = a.getResourceId(R.styleable.MaterialTimePicker_clockIcon, 0);
        this.keyboardIcon = a.getResourceId(R.styleable.MaterialTimePicker_keyboardIcon, 0);
        a.recycle();
        background.initializeElevationOverlay(context);
        background.setFillColor(ColorStateList.valueOf((int)surfaceColor));
        Window window = dialog.getWindow();
        window.setBackgroundDrawable((Drawable)background);
        window.requestFeature(1);
        window.setLayout(-2, -2);
        background.setElevation(ViewCompat.getElevation((View)window.getDecorView()));
        return dialog;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.restoreState(bundle == null ? this.getArguments() : bundle);
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putParcelable(TIME_MODEL_EXTRA, (Parcelable)this.time);
        bundle.putInt(INPUT_MODE_EXTRA, this.inputMode);
        bundle.putInt(TITLE_RES_EXTRA, this.titleResId);
        bundle.putCharSequence(TITLE_TEXT_EXTRA, this.titleText);
        bundle.putInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, this.positiveButtonTextResId);
        bundle.putCharSequence(POSITIVE_BUTTON_TEXT_EXTRA, this.positiveButtonText);
        bundle.putInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, this.negativeButtonTextResId);
        bundle.putCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA, this.negativeButtonText);
        bundle.putInt(OVERRIDE_THEME_RES_ID, this.overrideThemeResId);
    }

    private void restoreState(@Nullable Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.time = (TimeModel)bundle.getParcelable(TIME_MODEL_EXTRA);
        if (this.time == null) {
            this.time = new TimeModel();
        }
        int defaultInputMode = this.time.format == 1 ? 1 : 0;
        this.inputMode = bundle.getInt(INPUT_MODE_EXTRA, defaultInputMode);
        this.titleResId = bundle.getInt(TITLE_RES_EXTRA, 0);
        this.titleText = bundle.getCharSequence(TITLE_TEXT_EXTRA);
        this.positiveButtonTextResId = bundle.getInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, 0);
        this.positiveButtonText = bundle.getCharSequence(POSITIVE_BUTTON_TEXT_EXTRA);
        this.negativeButtonTextResId = bundle.getInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, 0);
        this.negativeButtonText = bundle.getCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA);
        this.overrideThemeResId = bundle.getInt(OVERRIDE_THEME_RES_ID, 0);
    }

    @NonNull
    public final View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        ViewGroup root = (ViewGroup)layoutInflater.inflate(R.layout.material_timepicker_dialog, viewGroup);
        this.timePickerView = (TimePickerView)root.findViewById(R.id.material_timepicker_view);
        this.timePickerView.setOnDoubleTapListener(this);
        this.textInputStub = (ViewStub)root.findViewById(R.id.material_textinput_timepicker);
        this.modeButton = (MaterialButton)root.findViewById(R.id.material_timepicker_mode_button);
        TextView headerTitle = (TextView)root.findViewById(R.id.header_title);
        if (this.titleResId != 0) {
            headerTitle.setText(this.titleResId);
        } else if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
            headerTitle.setText(this.titleText);
        }
        this.updateInputMode(this.modeButton);
        Button okButton = (Button)root.findViewById(R.id.material_timepicker_ok_button);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                for (View.OnClickListener listener : MaterialTimePicker.this.positiveButtonListeners) {
                    listener.onClick(v);
                }
                MaterialTimePicker.this.dismiss();
            }
        });
        if (this.positiveButtonTextResId != 0) {
            okButton.setText(this.positiveButtonTextResId);
        } else if (!TextUtils.isEmpty((CharSequence)this.positiveButtonText)) {
            okButton.setText(this.positiveButtonText);
        }
        this.cancelButton = (Button)root.findViewById(R.id.material_timepicker_cancel_button);
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                for (View.OnClickListener listener : MaterialTimePicker.this.negativeButtonListeners) {
                    listener.onClick(v);
                }
                MaterialTimePicker.this.dismiss();
            }
        });
        if (this.negativeButtonTextResId != 0) {
            this.cancelButton.setText(this.negativeButtonTextResId);
        } else if (!TextUtils.isEmpty((CharSequence)this.negativeButtonText)) {
            this.cancelButton.setText(this.negativeButtonText);
        }
        this.updateCancelButtonVisibility();
        this.modeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MaterialTimePicker.this.inputMode = MaterialTimePicker.this.inputMode == 0 ? 1 : 0;
                MaterialTimePicker.this.updateInputMode(MaterialTimePicker.this.modeButton);
            }
        });
        return root;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (this.activePresenter instanceof TimePickerTextInputPresenter) {
            view.postDelayed(() -> {
                if (this.activePresenter instanceof TimePickerTextInputPresenter) {
                    ((TimePickerTextInputPresenter)this.activePresenter).resetChecked();
                }
            }, 100L);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.activePresenter = null;
        this.timePickerClockPresenter = null;
        this.timePickerTextInputPresenter = null;
        if (this.timePickerView != null) {
            this.timePickerView.setOnDoubleTapListener(null);
            this.timePickerView = null;
        }
    }

    public final void onCancel(@NonNull DialogInterface dialogInterface) {
        for (DialogInterface.OnCancelListener listener : this.cancelListeners) {
            listener.onCancel(dialogInterface);
        }
        super.onCancel(dialogInterface);
    }

    public final void onDismiss(@NonNull DialogInterface dialogInterface) {
        for (DialogInterface.OnDismissListener listener : this.dismissListeners) {
            listener.onDismiss(dialogInterface);
        }
        super.onDismiss(dialogInterface);
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        this.updateCancelButtonVisibility();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDoubleTap() {
        this.inputMode = 1;
        this.updateInputMode(this.modeButton);
        this.timePickerTextInputPresenter.resetChecked();
    }

    private void updateInputMode(MaterialButton modeButton) {
        if (modeButton == null || this.timePickerView == null || this.textInputStub == null) {
            return;
        }
        if (this.activePresenter != null) {
            this.activePresenter.hide();
        }
        this.activePresenter = this.initializeOrRetrieveActivePresenterForMode(this.inputMode, this.timePickerView, this.textInputStub);
        this.activePresenter.show();
        this.activePresenter.invalidate();
        Pair<Integer, Integer> buttonData = this.dataForMode(this.inputMode);
        modeButton.setIconResource((Integer)buttonData.first);
        modeButton.setContentDescription(this.getResources().getString(((Integer)buttonData.second).intValue()));
        modeButton.sendAccessibilityEvent(4);
    }

    private void updateCancelButtonVisibility() {
        if (this.cancelButton != null) {
            this.cancelButton.setVisibility(this.isCancelable() ? 0 : 8);
        }
    }

    private TimePickerPresenter initializeOrRetrieveActivePresenterForMode(int mode, @NonNull TimePickerView timePickerView, @NonNull ViewStub textInputStub) {
        if (mode == 0) {
            this.timePickerClockPresenter = this.timePickerClockPresenter == null ? new TimePickerClockPresenter(timePickerView, this.time) : this.timePickerClockPresenter;
            return this.timePickerClockPresenter;
        }
        if (this.timePickerTextInputPresenter == null) {
            LinearLayout textInputView = (LinearLayout)textInputStub.inflate();
            this.timePickerTextInputPresenter = new TimePickerTextInputPresenter(textInputView, this.time);
        }
        this.timePickerTextInputPresenter.clearCheck();
        return this.timePickerTextInputPresenter;
    }

    private Pair<Integer, Integer> dataForMode(int mode) {
        switch (mode) {
            case 1: {
                return new Pair((Object)this.clockIcon, (Object)R.string.material_timepicker_clock_mode_description);
            }
            case 0: {
                return new Pair((Object)this.keyboardIcon, (Object)R.string.material_timepicker_text_input_mode_description);
            }
        }
        throw new IllegalArgumentException("no icon for mode: " + mode);
    }

    @Nullable
    TimePickerClockPresenter getTimePickerClockPresenter() {
        return this.timePickerClockPresenter;
    }

    @VisibleForTesting
    void setActivePresenter(@Nullable TimePickerPresenter presenter) {
        this.activePresenter = presenter;
    }

    public boolean addOnPositiveButtonClickListener(@NonNull View.OnClickListener listener) {
        return this.positiveButtonListeners.add(listener);
    }

    public boolean removeOnPositiveButtonClickListener(@NonNull View.OnClickListener listener) {
        return this.positiveButtonListeners.remove(listener);
    }

    public void clearOnPositiveButtonClickListeners() {
        this.positiveButtonListeners.clear();
    }

    public boolean addOnNegativeButtonClickListener(@NonNull View.OnClickListener listener) {
        return this.negativeButtonListeners.add(listener);
    }

    public boolean removeOnNegativeButtonClickListener(@NonNull View.OnClickListener listener) {
        return this.negativeButtonListeners.remove(listener);
    }

    public void clearOnNegativeButtonClickListeners() {
        this.negativeButtonListeners.clear();
    }

    public boolean addOnCancelListener(@NonNull DialogInterface.OnCancelListener listener) {
        return this.cancelListeners.add(listener);
    }

    public boolean removeOnCancelListener(@NonNull DialogInterface.OnCancelListener listener) {
        return this.cancelListeners.remove(listener);
    }

    public void clearOnCancelListeners() {
        this.cancelListeners.clear();
    }

    public boolean addOnDismissListener(@NonNull DialogInterface.OnDismissListener listener) {
        return this.dismissListeners.add(listener);
    }

    public boolean removeOnDismissListener(@NonNull DialogInterface.OnDismissListener listener) {
        return this.dismissListeners.remove(listener);
    }

    public void clearOnDismissListeners() {
        this.dismissListeners.clear();
    }

    private int getThemeResId() {
        if (this.overrideThemeResId != 0) {
            return this.overrideThemeResId;
        }
        TypedValue value = MaterialAttributes.resolve(this.requireContext(), R.attr.materialTimePickerTheme);
        return value == null ? 0 : value.data;
    }

    public static final class Builder {
        private TimeModel time = new TimeModel();
        @Nullable
        private Integer inputMode;
        @StringRes
        private int titleTextResId = 0;
        private CharSequence titleText;
        @StringRes
        private int positiveButtonTextResId = 0;
        private CharSequence positiveButtonText;
        @StringRes
        private int negativeButtonTextResId = 0;
        private CharSequence negativeButtonText;
        private int overrideThemeResId = 0;

        @NonNull
        @CanIgnoreReturnValue
        public Builder setInputMode(int inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setHour(@IntRange(from=0L, to=23L) int hour) {
            this.time.setHourOfDay(hour);
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setMinute(@IntRange(from=0L, to=59L) int minute) {
            this.time.setMinute(minute);
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setTimeFormat(int format) {
            int hour = this.time.hour;
            int minute = this.time.minute;
            this.time = new TimeModel(format);
            this.time.setMinute(minute);
            this.time.setHourOfDay(hour);
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setTitleText(@StringRes int titleTextResId) {
            this.titleTextResId = titleTextResId;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setTitleText(@Nullable CharSequence charSequence) {
            this.titleText = charSequence;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setPositiveButtonText(@StringRes int positiveButtonTextResId) {
            this.positiveButtonTextResId = positiveButtonTextResId;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setPositiveButtonText(@Nullable CharSequence positiveButtonText) {
            this.positiveButtonText = positiveButtonText;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setNegativeButtonText(@StringRes int negativeButtonTextResId) {
            this.negativeButtonTextResId = negativeButtonTextResId;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setNegativeButtonText(@Nullable CharSequence negativeButtonText) {
            this.negativeButtonText = negativeButtonText;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setTheme(@StyleRes int themeResId) {
            this.overrideThemeResId = themeResId;
            return this;
        }

        @NonNull
        public MaterialTimePicker build() {
            return MaterialTimePicker.newInstance(this);
        }
    }
}

