/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.window.area.EmptyDecorator;
import androidx.window.area.EmptyWindowAreaControllerImpl;
import androidx.window.area.WindowAreaControllerDecorator;
import androidx.window.area.WindowAreaControllerImpl;
import androidx.window.area.WindowAreaSessionCallback;
import androidx.window.area.WindowAreaStatus;
import androidx.window.core.BuildConfig;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.core.VerificationMode;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.extensions.area.WindowAreaComponent;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \r2\u00020\u0001:\u0001\rJ \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Landroidx/window/area/WindowAreaController;", "", "rearDisplayMode", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "windowAreaSessionCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "rearDisplayStatus", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/window/area/WindowAreaStatus;", "Companion", "window_release"})
@ExperimentalWindowApi
public interface WindowAreaController {
    @NotNull
    public static final Companion Companion = androidx.window.area.WindowAreaController$Companion.$$INSTANCE;

    @NotNull
    public Flow<WindowAreaStatus> rearDisplayStatus();

    public void rearDisplayMode(@NotNull Activity var1, @NotNull Executor var2, @NotNull WindowAreaSessionCallback var3);

    @JvmStatic
    @JvmName(name="getOrCreate")
    @NotNull
    public static WindowAreaController getOrCreate() {
        return Companion.getOrCreate();
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void overrideDecorator(@NotNull WindowAreaControllerDecorator overridingDecorator) {
        Companion.overrideDecorator(overridingDecorator);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void reset() {
        Companion.reset();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\b\u0010\f\u001a\u00020\nH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/window/area/WindowAreaController$Companion;", "", "()V", "TAG", "", "decorator", "Landroidx/window/area/WindowAreaControllerDecorator;", "getOrCreate", "Landroidx/window/area/WindowAreaController;", "overrideDecorator", "", "overridingDecorator", "reset", "window_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Nullable
        private static final String TAG;
        @NotNull
        private static WindowAreaControllerDecorator decorator;

        private Companion() {
        }

        @JvmStatic
        @JvmName(name="getOrCreate")
        @NotNull
        public final WindowAreaController getOrCreate() {
            WindowAreaComponent windowAreaComponentExtensions = null;
            try {
                windowAreaComponentExtensions = WindowExtensionsProvider.getWindowExtensions().getWindowAreaComponent();
            }
            catch (Throwable t) {
                if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.STRICT) {
                    Log.d((String)TAG, (String)"Failed to load WindowExtensions");
                }
                windowAreaComponentExtensions = null;
            }
            WindowAreaController controller = Build.VERSION.SDK_INT < 24 || windowAreaComponentExtensions == null ? (WindowAreaController)new EmptyWindowAreaControllerImpl() : (WindowAreaController)new WindowAreaControllerImpl(windowAreaComponentExtensions);
            return decorator.decorate(controller);
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void overrideDecorator(@NotNull WindowAreaControllerDecorator overridingDecorator) {
            Intrinsics.checkNotNullParameter((Object)overridingDecorator, (String)"overridingDecorator");
            decorator = overridingDecorator;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final void reset() {
            decorator = EmptyDecorator.INSTANCE;
        }

        static {
            $$INSTANCE = new Companion();
            TAG = Reflection.getOrCreateKotlinClass(WindowAreaController.class).getSimpleName();
            decorator = EmptyDecorator.INSTANCE;
        }
    }
}

