/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area;

import android.app.Activity;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.window.area.RearDisplaySessionImpl;
import androidx.window.area.WindowAreaAdapter;
import androidx.window.area.WindowAreaController;
import androidx.window.area.WindowAreaControllerImpl;
import androidx.window.area.WindowAreaSession;
import androidx.window.area.WindowAreaSessionCallback;
import androidx.window.area.WindowAreaStatus;
import androidx.window.core.BuildConfig;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.core.VerificationMode;
import androidx.window.extensions.area.WindowAreaComponent;
import androidx.window.extensions.core.util.function.Consumer;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/window/area/WindowAreaControllerImpl;", "Landroidx/window/area/WindowAreaController;", "windowAreaComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "(Landroidx/window/extensions/area/WindowAreaComponent;)V", "currentStatus", "Landroidx/window/area/WindowAreaStatus;", "rearDisplayMode", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "windowAreaSessionCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "rearDisplayStatus", "Lkotlinx/coroutines/flow/Flow;", "Companion", "RearDisplaySessionConsumer", "window_release"})
@ExperimentalWindowApi
@RequiresApi(value=24)
public final class WindowAreaControllerImpl
implements WindowAreaController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WindowAreaComponent windowAreaComponent;
    @Nullable
    private WindowAreaStatus currentStatus;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(WindowAreaControllerImpl.class).getSimpleName();

    public WindowAreaControllerImpl(@NotNull WindowAreaComponent windowAreaComponent) {
        Intrinsics.checkNotNullParameter((Object)windowAreaComponent, (String)"windowAreaComponent");
        this.windowAreaComponent = windowAreaComponent;
    }

    @Override
    @NotNull
    public Flow<WindowAreaStatus> rearDisplayStatus() {
        return FlowKt.distinctUntilChanged((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super WindowAreaStatus>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WindowAreaControllerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Consumer listener = arg_0 -> rearDisplayStatus.1.invokeSuspend$lambda$0(this.this$0, $this$callbackFlow, arg_0);
                        WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).addRearDisplayStatusListener(listener);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, (Consumer<Integer>)listener){
                            final /* synthetic */ WindowAreaControllerImpl this$0;
                            final /* synthetic */ Consumer<Integer> $listener;
                            {
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                super(0);
                            }

                            public final void invoke() {
                                WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).removeRearDisplayStatusListener(this.$listener);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super WindowAreaStatus>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super WindowAreaStatus> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(WindowAreaControllerImpl this$0, ProducerScope $$this$callbackFlow, Integer status) {
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                WindowAreaControllerImpl.access$setCurrentStatus$p(this$0, WindowAreaAdapter.INSTANCE.translate$window_release(status));
                SendChannel sendChannel = $$this$callbackFlow.getChannel();
                WindowAreaStatus windowAreaStatus = WindowAreaControllerImpl.access$getCurrentStatus$p(this$0);
                if (windowAreaStatus == null) {
                    windowAreaStatus = WindowAreaStatus.UNSUPPORTED;
                }
                sendChannel.trySend-JP2dKIU((Object)windowAreaStatus);
            }
        })));
    }

    @Override
    public void rearDisplayMode(@NotNull Activity activity, @NotNull Executor executor, @NotNull WindowAreaSessionCallback windowAreaSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)windowAreaSessionCallback, (String)"windowAreaSessionCallback");
        if (this.currentStatus != null && !Intrinsics.areEqual((Object)this.currentStatus, (Object)WindowAreaStatus.AVAILABLE)) {
            throw new UnsupportedOperationException("Rear Display mode cannot be enabled currently");
        }
        RearDisplaySessionConsumer rearDisplaySessionConsumer = new RearDisplaySessionConsumer(executor, windowAreaSessionCallback, this.windowAreaComponent);
        this.windowAreaComponent.startRearDisplaySession(activity, (Consumer)rearDisplaySessionConsumer);
    }

    public static final /* synthetic */ WindowAreaComponent access$getWindowAreaComponent$p(WindowAreaControllerImpl $this) {
        return $this.windowAreaComponent;
    }

    public static final /* synthetic */ void access$setCurrentStatus$p(WindowAreaControllerImpl $this, WindowAreaStatus windowAreaStatus) {
        $this.currentStatus = windowAreaStatus;
    }

    public static final /* synthetic */ WindowAreaStatus access$getCurrentStatus$p(WindowAreaControllerImpl $this) {
        return $this.currentStatus;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/window/area/WindowAreaControllerImpl$Companion;", "", "()V", "TAG", "", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/area/WindowAreaControllerImpl$RearDisplaySessionConsumer;", "Landroidx/window/extensions/core/util/function/Consumer;", "", "executor", "Ljava/util/concurrent/Executor;", "appCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "extensionsComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "(Ljava/util/concurrent/Executor;Landroidx/window/area/WindowAreaSessionCallback;Landroidx/window/extensions/area/WindowAreaComponent;)V", "session", "Landroidx/window/area/WindowAreaSession;", "accept", "", "t", "onSessionFinished", "onSessionStarted", "window_release"})
    @SourceDebugExtension(value={"SMAP\nWindowAreaControllerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowAreaControllerImpl.kt\nandroidx/window/area/WindowAreaControllerImpl$RearDisplaySessionConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
    public static final class RearDisplaySessionConsumer
    implements Consumer<Integer> {
        @NotNull
        private final Executor executor;
        @NotNull
        private final WindowAreaSessionCallback appCallback;
        @NotNull
        private final WindowAreaComponent extensionsComponent;
        @Nullable
        private WindowAreaSession session;

        public RearDisplaySessionConsumer(@NotNull Executor executor, @NotNull WindowAreaSessionCallback appCallback, @NotNull WindowAreaComponent extensionsComponent) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)appCallback, (String)"appCallback");
            Intrinsics.checkNotNullParameter((Object)extensionsComponent, (String)"extensionsComponent");
            this.executor = executor;
            this.appCallback = appCallback;
            this.extensionsComponent = extensionsComponent;
        }

        public void accept(int t) {
            switch (t) {
                case 1: {
                    this.onSessionStarted();
                    break;
                }
                case 0: {
                    this.onSessionFinished();
                    break;
                }
                default: {
                    if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.STRICT) {
                        Log.d((String)TAG, (String)("Received an unknown session status value: " + t));
                    }
                    this.onSessionFinished();
                }
            }
        }

        private final void onSessionStarted() {
            block0: {
                WindowAreaSession windowAreaSession = this.session = (WindowAreaSession)new RearDisplaySessionImpl(this.extensionsComponent);
                if (windowAreaSession == null) break block0;
                WindowAreaSession it = windowAreaSession;
                boolean bl = false;
                this.executor.execute(() -> RearDisplaySessionConsumer.onSessionStarted$lambda$1$lambda$0(this, it));
            }
        }

        private final void onSessionFinished() {
            this.session = null;
            this.executor.execute(() -> RearDisplaySessionConsumer.onSessionFinished$lambda$2(this));
        }

        private static final void onSessionStarted$lambda$1$lambda$0(RearDisplaySessionConsumer this$0, WindowAreaSession $it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            this$0.appCallback.onSessionStarted($it);
        }

        private static final void onSessionFinished$lambda$2(RearDisplaySessionConsumer this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.appCallback.onSessionEnded();
        }
    }
}

