/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core;

import android.annotation.SuppressLint;
import android.util.Pair;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JP\u0010\u0005\u001a\u00020\u0001\"\b\b\u0000\u0010\u0006*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\r0\fJ2\u0010\u000e\u001a\u00020\u0001\"\b\b\u0000\u0010\u0006*\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\r0\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/window/core/PredicateAdapter;", "", "loader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "buildPairPredicate", "T", "U", "firstClazz", "Lkotlin/reflect/KClass;", "secondClazz", "predicate", "Lkotlin/Function2;", "", "buildPredicate", "clazz", "Lkotlin/Function1;", "predicateClassOrNull", "Ljava/lang/Class;", "predicateClassOrNull$window_release", "predicateClassOrThrow", "BaseHandler", "PairPredicateStubHandler", "PredicateStubHandler", "window_release"})
@SuppressLint(value={"BanUncheckedReflection"})
public final class PredicateAdapter {
    @NotNull
    private final ClassLoader loader;

    public PredicateAdapter(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader = loader;
    }

    @Nullable
    public final Class<?> predicateClassOrNull$window_release() {
        Class<?> clazz;
        try {
            clazz = this.predicateClassOrThrow();
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return clazz;
    }

    private final Class<?> predicateClassOrThrow() {
        Class<?> clazz = this.loader.loadClass("java.util.function.Predicate");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(\"java.util.function.Predicate\")");
        return clazz;
    }

    @NotNull
    public final <T> Object buildPredicate(@NotNull KClass<T> clazz, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PredicateStubHandler<? super T> predicateHandler = new PredicateStubHandler<T>(clazz, predicate);
        Class[] classArray = new Class[]{this.predicateClassOrThrow()};
        Object object = Proxy.newProxyInstance(this.loader, classArray, (InvocationHandler)predicateHandler);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newProxyInstance(loader,\u2026row()), predicateHandler)");
        return object;
    }

    @NotNull
    public final <T, U> Object buildPairPredicate(@NotNull KClass<T> firstClazz, @NotNull KClass<U> secondClazz, @NotNull Function2<? super T, ? super U, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(firstClazz, (String)"firstClazz");
        Intrinsics.checkNotNullParameter(secondClazz, (String)"secondClazz");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PairPredicateStubHandler<? super T, ? super U> predicateHandler = new PairPredicateStubHandler<T, U>(firstClazz, secondClazz, predicate);
        Class[] classArray = new Class[]{this.predicateClassOrThrow()};
        Object object = Proxy.newProxyInstance(this.loader, classArray, (InvocationHandler)predicateHandler);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newProxyInstance(loader,\u2026row()), predicateHandler)");
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u00020\u000f*\u00020\n2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\fH\u0004\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\u00020\u000f*\u00020\n2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\fH\u0004\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0016\u001a\u00020\u000f*\u00020\n2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\fH\u0004\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0017\u001a\u00020\u000f*\u00020\n2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\fH\u0004\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/window/core/PredicateAdapter$BaseHandler;", "T", "", "Ljava/lang/reflect/InvocationHandler;", "clazz", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "invoke", "obj", "method", "Ljava/lang/reflect/Method;", "parameters", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeTest", "", "parameter", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "isEquals", "args", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Z", "isHashCode", "isTest", "isToString", "window_release"})
    private static abstract class BaseHandler<T>
    implements InvocationHandler {
        @NotNull
        private final KClass<T> clazz;

        public BaseHandler(@NotNull KClass<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            this.clazz = clazz;
        }

        @Override
        @NotNull
        public Object invoke(@NotNull Object obj, @NotNull Method method, @Nullable Object[] parameters) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (this.isTest(method, parameters)) {
                Object argument = KClasses.cast(this.clazz, (Object)(parameters != null ? parameters[0] : null));
                object = this.invokeTest(obj, argument);
            } else if (this.isEquals(method, parameters)) {
                Object object2 = parameters != null ? parameters[0] : null;
                Intrinsics.checkNotNull((Object)object2);
                object = obj == object2;
            } else if (this.isHashCode(method, parameters)) {
                object = this.hashCode();
            } else if (this.isToString(method, parameters)) {
                object = this.toString();
            } else {
                throw new UnsupportedOperationException("Unexpected method call object:" + obj + ", method: " + method + ", args: " + parameters);
            }
            return object;
        }

        public abstract boolean invokeTest(@NotNull Object var1, @NotNull T var2);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final boolean isEquals(@NotNull Method $this$isEquals, @Nullable Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$this$isEquals, (String)"<this>");
            if (!Intrinsics.areEqual((Object)$this$isEquals.getName(), (Object)"equals")) return false;
            if (!$this$isEquals.getReturnType().equals(Boolean.TYPE)) return false;
            if (args == null) return false;
            if (args.length != 1) return false;
            return true;
        }

        protected final boolean isHashCode(@NotNull Method $this$isHashCode, @Nullable Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$this$isHashCode, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isHashCode.getName(), (Object)"hashCode") && $this$isHashCode.getReturnType().equals(Integer.TYPE) && args == null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final boolean isTest(@NotNull Method $this$isTest, @Nullable Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$this$isTest, (String)"<this>");
            if (!Intrinsics.areEqual((Object)$this$isTest.getName(), (Object)"test")) return false;
            if (!$this$isTest.getReturnType().equals(Boolean.TYPE)) return false;
            if (args == null) return false;
            if (args.length != 1) return false;
            return true;
        }

        protected final boolean isToString(@NotNull Method $this$isToString, @Nullable Object[] args) {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)"toString") && $this$isToString.getReturnType().equals(String.class) && args == null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0004B;\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00022\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/window/core/PredicateAdapter$PairPredicateStubHandler;", "T", "", "U", "Landroidx/window/core/PredicateAdapter$BaseHandler;", "Landroid/util/Pair;", "clazzT", "Lkotlin/reflect/KClass;", "clazzU", "predicate", "Lkotlin/Function2;", "", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function2;)V", "hashCode", "", "invokeTest", "obj", "parameter", "toString", "", "window_release"})
    private static final class PairPredicateStubHandler<T, U>
    extends BaseHandler<Pair<?, ?>> {
        @NotNull
        private final KClass<T> clazzT;
        @NotNull
        private final KClass<U> clazzU;
        @NotNull
        private final Function2<T, U, Boolean> predicate;

        public PairPredicateStubHandler(@NotNull KClass<T> clazzT, @NotNull KClass<U> clazzU, @NotNull Function2<? super T, ? super U, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(clazzT, (String)"clazzT");
            Intrinsics.checkNotNullParameter(clazzU, (String)"clazzU");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            super(Reflection.getOrCreateKotlinClass(Pair.class));
            this.clazzT = clazzT;
            this.clazzU = clazzU;
            this.predicate = predicate;
        }

        @Override
        public boolean invokeTest(@NotNull Object obj, @NotNull Pair<?, ?> parameter) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            Object t = KClasses.cast(this.clazzT, (Object)parameter.first);
            Object u = KClasses.cast(this.clazzU, (Object)parameter.second);
            return (Boolean)this.predicate.invoke(t, u);
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        @NotNull
        public String toString() {
            return this.predicate.toString();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/window/core/PredicateAdapter$PredicateStubHandler;", "T", "", "Landroidx/window/core/PredicateAdapter$BaseHandler;", "clazzT", "Lkotlin/reflect/KClass;", "predicate", "Lkotlin/Function1;", "", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)V", "hashCode", "", "invokeTest", "obj", "parameter", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "toString", "", "window_release"})
    private static final class PredicateStubHandler<T>
    extends BaseHandler<T> {
        @NotNull
        private final Function1<T, Boolean> predicate;

        public PredicateStubHandler(@NotNull KClass<T> clazzT, @NotNull Function1<? super T, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(clazzT, (String)"clazzT");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            super(clazzT);
            this.predicate = predicate;
        }

        @Override
        public boolean invokeTest(@NotNull Object obj, @NotNull T parameter) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            return (Boolean)this.predicate.invoke(parameter);
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        @NotNull
        public String toString() {
            return this.predicate.toString();
        }
    }
}

