/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.window.core.BuildConfig;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.core.ExtensionsUtil;
import androidx.window.core.VerificationMode;
import androidx.window.embedding.EmbeddingAdapter;
import androidx.window.embedding.EmbeddingInterfaceCompat;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SafeActivityEmbeddingComponentProvider;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitAttributesCalculatorParams;
import androidx.window.embedding.SplitController;
import androidx.window.embedding.SplitRule;
import androidx.window.extensions.WindowExtensions;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.embedding.ActivityEmbeddingComponent;
import androidx.window.extensions.embedding.SplitInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001c\u0010\u0019\u001a\u00020\f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/window/embedding/EmbeddingCompat;", "Landroidx/window/embedding/EmbeddingInterfaceCompat;", "embeddingExtension", "Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "adapter", "Landroidx/window/embedding/EmbeddingAdapter;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "applicationContext", "Landroid/content/Context;", "(Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;Landroidx/window/embedding/EmbeddingAdapter;Landroidx/window/core/ConsumerAdapter;Landroid/content/Context;)V", "clearSplitAttributesCalculator", "", "isActivityEmbedded", "", "activity", "Landroid/app/Activity;", "isSplitAttributesCalculatorSupported", "setEmbeddingCallback", "embeddingCallback", "Landroidx/window/embedding/EmbeddingInterfaceCompat$EmbeddingCallbackInterface;", "setRules", "rules", "", "Landroidx/window/embedding/EmbeddingRule;", "setSplitAttributesCalculator", "calculator", "Lkotlin/Function1;", "Landroidx/window/embedding/SplitAttributesCalculatorParams;", "Landroidx/window/embedding/SplitAttributes;", "Companion", "window_release"})
public final class EmbeddingCompat
implements EmbeddingInterfaceCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActivityEmbeddingComponent embeddingExtension;
    @NotNull
    private final EmbeddingAdapter adapter;
    @NotNull
    private final ConsumerAdapter consumerAdapter;
    @NotNull
    private final Context applicationContext;
    public static final boolean DEBUG = true;
    @NotNull
    private static final String TAG = "EmbeddingCompat";

    public EmbeddingCompat(@NotNull ActivityEmbeddingComponent embeddingExtension, @NotNull EmbeddingAdapter adapter, @NotNull ConsumerAdapter consumerAdapter, @NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)embeddingExtension, (String)"embeddingExtension");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.embeddingExtension = embeddingExtension;
        this.adapter = adapter;
        this.consumerAdapter = consumerAdapter;
        this.applicationContext = applicationContext;
    }

    @Override
    public void setRules(@NotNull Set<? extends EmbeddingRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        boolean hasSplitRule = false;
        for (EmbeddingRule embeddingRule : rules) {
            if (!(embeddingRule instanceof SplitRule)) continue;
            hasSplitRule = true;
            break;
        }
        if (hasSplitRule && !Intrinsics.areEqual((Object)SplitController.Companion.getInstance(this.applicationContext).getSplitSupportStatus(), (Object)SplitController.SplitSupportStatus.SPLIT_AVAILABLE)) {
            if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                Log.w((String)TAG, (String)"Cannot set SplitRule because ActivityEmbedding Split is not supported or PROPERTY_ACTIVITY_EMBEDDING_SPLITS_ENABLED is not set.");
            }
            return;
        }
        Set<androidx.window.extensions.embedding.EmbeddingRule> r = this.adapter.translate(this.applicationContext, rules);
        this.embeddingExtension.setEmbeddingRules(r);
    }

    @Override
    public void setEmbeddingCallback(@NotNull EmbeddingInterfaceCompat.EmbeddingCallbackInterface embeddingCallback) {
        Intrinsics.checkNotNullParameter((Object)embeddingCallback, (String)"embeddingCallback");
        if (ExtensionsUtil.INSTANCE.getSafeVendorApiLevel() < 2) {
            this.consumerAdapter.addConsumer(this.embeddingExtension, Reflection.getOrCreateKotlinClass(List.class), "setSplitInfoCallback", (Function1)new Function1<List<?>, Unit>(embeddingCallback, this){
                final /* synthetic */ EmbeddingInterfaceCompat.EmbeddingCallbackInterface $embeddingCallback;
                final /* synthetic */ EmbeddingCompat this$0;
                {
                    this.$embeddingCallback = $embeddingCallback;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<?> values) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter(values, (String)"values");
                    Iterable $this$filterIsInstance$iv = values;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof SplitInfo)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List splitInfoList2 = (List)destination$iv$iv;
                    this.$embeddingCallback.onSplitInfoChanged(EmbeddingCompat.access$getAdapter$p(this.this$0).translate(splitInfoList2));
                }
            });
        } else {
            Consumer callback = arg_0 -> EmbeddingCompat.setEmbeddingCallback$lambda$0(embeddingCallback, this, arg_0);
            this.embeddingExtension.setSplitInfoCallback(callback);
        }
    }

    @Override
    public boolean isActivityEmbedded(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return this.embeddingExtension.isActivityEmbedded(activity);
    }

    @Override
    @ExperimentalWindowApi
    public void setSplitAttributesCalculator(@NotNull Function1<? super SplitAttributesCalculatorParams, SplitAttributes> calculator) {
        Intrinsics.checkNotNullParameter(calculator, (String)"calculator");
        if (!this.isSplitAttributesCalculatorSupported()) {
            throw new UnsupportedOperationException("#setSplitAttributesCalculator is not supported on the device.");
        }
        this.embeddingExtension.setSplitAttributesCalculator(this.adapter.translateSplitAttributesCalculator(calculator));
    }

    @Override
    public void clearSplitAttributesCalculator() {
        if (!this.isSplitAttributesCalculatorSupported()) {
            throw new UnsupportedOperationException("#clearSplitAttributesCalculator is not supported on the device.");
        }
        this.embeddingExtension.clearSplitAttributesCalculator();
    }

    @Override
    public boolean isSplitAttributesCalculatorSupported() {
        return ExtensionsUtil.INSTANCE.getSafeVendorApiLevel() >= 2;
    }

    private static final void setEmbeddingCallback$lambda$0(EmbeddingInterfaceCompat.EmbeddingCallbackInterface $embeddingCallback, EmbeddingCompat this$0, List splitInfoList2) {
        Intrinsics.checkNotNullParameter((Object)$embeddingCallback, (String)"$embeddingCallback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EmbeddingAdapter embeddingAdapter = this$0.adapter;
        Intrinsics.checkNotNullExpressionValue((Object)splitInfoList2, (String)"splitInfoList");
        $embeddingCallback.onSplitInfoChanged(embeddingAdapter.translate(splitInfoList2));
    }

    public static final /* synthetic */ EmbeddingAdapter access$getAdapter$p(EmbeddingCompat $this) {
        return $this.adapter;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/window/embedding/EmbeddingCompat$Companion;", "", "()V", "DEBUG", "", "TAG", "", "embeddingComponent", "Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "emptyActivityEmbeddingProxy", "isEmbeddingAvailable", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEmbeddingAvailable() {
            boolean bl;
            try {
                boolean bl2;
                ClassLoader classLoader = EmbeddingCompat.class.getClassLoader();
                if (classLoader != null) {
                    ClassLoader loader = classLoader;
                    boolean bl3 = false;
                    ConsumerAdapter consumerAdapter = new ConsumerAdapter(loader);
                    WindowExtensions windowExtensions = WindowExtensionsProvider.getWindowExtensions();
                    Intrinsics.checkNotNullExpressionValue((Object)windowExtensions, (String)"getWindowExtensions()");
                    bl2 = new SafeActivityEmbeddingComponentProvider(loader, consumerAdapter, windowExtensions).getActivityEmbeddingComponent() != null;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Embedding extension version not found");
                bl = false;
            }
            catch (UnsupportedOperationException e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Stub Extension");
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final ActivityEmbeddingComponent embeddingComponent() {
            Object object;
            block4: {
                block2: {
                    block3: {
                        if (!this.isEmbeddingAvailable()) break block2;
                        object = EmbeddingCompat.class.getClassLoader();
                        if (object == null) break block3;
                        Object loader = object;
                        boolean bl = false;
                        ConsumerAdapter consumerAdapter = new ConsumerAdapter((ClassLoader)loader);
                        WindowExtensions windowExtensions = WindowExtensionsProvider.getWindowExtensions();
                        Intrinsics.checkNotNullExpressionValue((Object)windowExtensions, (String)"getWindowExtensions()");
                        ActivityEmbeddingComponent activityEmbeddingComponent = new SafeActivityEmbeddingComponentProvider((ClassLoader)loader, consumerAdapter, windowExtensions).getActivityEmbeddingComponent();
                        object = activityEmbeddingComponent;
                        if (activityEmbeddingComponent != null) break block4;
                    }
                    object = this.emptyActivityEmbeddingProxy();
                    break block4;
                }
                object = this.emptyActivityEmbeddingProxy();
            }
            return object;
        }

        private final ActivityEmbeddingComponent emptyActivityEmbeddingProxy() {
            Class[] classArray = new Class[]{ActivityEmbeddingComponent.class};
            Object object = Proxy.newProxyInstance(EmbeddingCompat.class.getClassLoader(), classArray, Companion::emptyActivityEmbeddingProxy$lambda$2);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.window.extensions.embedding.ActivityEmbeddingComponent");
            return (ActivityEmbeddingComponent)object;
        }

        private static final Unit emptyActivityEmbeddingProxy$lambda$2(Object object, Method method, Object[] objectArray) {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

