/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.annotation.SuppressLint;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.window.core.SpecificationComputer;
import androidx.window.core.VerificationMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Landroidx/window/embedding/SplitAttributes;", "", "splitType", "Landroidx/window/embedding/SplitAttributes$SplitType;", "layoutDirection", "Landroidx/window/embedding/SplitAttributes$LayoutDirection;", "(Landroidx/window/embedding/SplitAttributes$SplitType;Landroidx/window/embedding/SplitAttributes$LayoutDirection;)V", "getLayoutDirection", "()Landroidx/window/embedding/SplitAttributes$LayoutDirection;", "getSplitType", "()Landroidx/window/embedding/SplitAttributes$SplitType;", "equals", "", "other", "hashCode", "", "toString", "", "Builder", "Companion", "LayoutDirection", "SplitType", "window_release"})
public final class SplitAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SplitType splitType;
    @NotNull
    private final LayoutDirection layoutDirection;
    private static final String TAG = SplitAttributes.class.getSimpleName();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SplitAttributes(@NotNull SplitType splitType, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)splitType, (String)"splitType");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        this.splitType = splitType;
        this.layoutDirection = layoutDirection;
    }

    public /* synthetic */ SplitAttributes(SplitType splitType, LayoutDirection layoutDirection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            splitType = SplitType.SPLIT_TYPE_EQUAL;
        }
        if ((n & 2) != 0) {
            layoutDirection = LayoutDirection.LOCALE;
        }
        this(splitType, layoutDirection);
    }

    @NotNull
    public final SplitType getSplitType() {
        return this.splitType;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public int hashCode() {
        int result = this.splitType.hashCode();
        result = result * 31 + this.layoutDirection.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitAttributes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.splitType, (Object)((SplitAttributes)other).splitType) && Intrinsics.areEqual((Object)this.layoutDirection, (Object)((SplitAttributes)other).layoutDirection);
    }

    @NotNull
    public String toString() {
        return SplitAttributes.class.getSimpleName() + ":{splitType=" + this.splitType + ", layoutDir=" + this.layoutDirection + " }";
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SplitAttributes() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/window/embedding/SplitAttributes$Builder;", "", "()V", "layoutDirection", "Landroidx/window/embedding/SplitAttributes$LayoutDirection;", "splitType", "Landroidx/window/embedding/SplitAttributes$SplitType;", "build", "Landroidx/window/embedding/SplitAttributes;", "setLayoutDirection", "setSplitType", "type", "window_release"})
    @SourceDebugExtension(value={"SMAP\nSplitAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitAttributes.kt\nandroidx/window/embedding/SplitAttributes$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n1#2:440\n*E\n"})
    public static final class Builder {
        @NotNull
        private SplitType splitType = SplitType.SPLIT_TYPE_EQUAL;
        @NotNull
        private LayoutDirection layoutDirection = LayoutDirection.LOCALE;

        @NotNull
        public final Builder setSplitType(@NotNull SplitType type) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Builder $this$setSplitType_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setSplitType_u24lambda_u240.splitType = type;
            return builder;
        }

        @NotNull
        public final Builder setLayoutDirection(@NotNull LayoutDirection layoutDirection) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            Builder $this$setLayoutDirection_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setLayoutDirection_u24lambda_u241.layoutDirection = layoutDirection;
            return builder;
        }

        @NotNull
        public final SplitAttributes build() {
            return new SplitAttributes(this.splitType, this.layoutDirection);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/window/embedding/SplitAttributes$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Landroidx/window/embedding/SplitAttributes$LayoutDirection;", "", "description", "", "value", "", "(Ljava/lang/String;I)V", "getValue$window_release", "()I", "toString", "Companion", "window_release"})
    public static final class LayoutDirection {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String description;
        private final int value;
        @JvmField
        @NotNull
        public static final LayoutDirection LOCALE = new LayoutDirection("LOCALE", 0);
        @JvmField
        @NotNull
        public static final LayoutDirection LEFT_TO_RIGHT = new LayoutDirection("LEFT_TO_RIGHT", 1);
        @JvmField
        @NotNull
        public static final LayoutDirection RIGHT_TO_LEFT = new LayoutDirection("RIGHT_TO_LEFT", 2);
        @JvmField
        @NotNull
        public static final LayoutDirection TOP_TO_BOTTOM = new LayoutDirection("TOP_TO_BOTTOM", 3);
        @JvmField
        @NotNull
        public static final LayoutDirection BOTTOM_TO_TOP = new LayoutDirection("BOTTOM_TO_TOP", 4);

        private LayoutDirection(String description, int value) {
            this.description = description;
            this.value = value;
        }

        public final int getValue$window_release() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.description;
        }

        @JvmStatic
        @NotNull
        public static final LayoutDirection getLayoutDirectionFromValue$window_release(@IntRange(from=0L, to=4L) int value) {
            return Companion.getLayoutDirectionFromValue$window_release(value);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/window/embedding/SplitAttributes$LayoutDirection$Companion;", "", "()V", "BOTTOM_TO_TOP", "Landroidx/window/embedding/SplitAttributes$LayoutDirection;", "LEFT_TO_RIGHT", "LOCALE", "RIGHT_TO_LEFT", "TOP_TO_BOTTOM", "getLayoutDirectionFromValue", "value", "", "getLayoutDirectionFromValue$window_release", "window_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final LayoutDirection getLayoutDirectionFromValue$window_release(@IntRange(from=0L, to=4L) int value) {
                LayoutDirection layoutDirection;
                int n = value;
                if (n == LEFT_TO_RIGHT.getValue$window_release()) {
                    layoutDirection = LEFT_TO_RIGHT;
                } else if (n == RIGHT_TO_LEFT.getValue$window_release()) {
                    layoutDirection = RIGHT_TO_LEFT;
                } else if (n == LOCALE.getValue$window_release()) {
                    layoutDirection = LOCALE;
                } else if (n == TOP_TO_BOTTOM.getValue$window_release()) {
                    layoutDirection = TOP_TO_BOTTOM;
                } else if (n == BOTTOM_TO_TOP.getValue$window_release()) {
                    layoutDirection = BOTTOM_TO_TOP;
                } else {
                    throw new IllegalArgumentException("Undefined value:" + value);
                }
                return layoutDirection;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Landroidx/window/embedding/SplitAttributes$SplitType;", "", "description", "", "value", "", "(Ljava/lang/String;F)V", "getDescription$window_release", "()Ljava/lang/String;", "getValue$window_release", "()F", "equals", "", "other", "hashCode", "", "toString", "Companion", "window_release"})
    public static final class SplitType {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String description;
        private final float value;
        @JvmField
        @NotNull
        public static final SplitType SPLIT_TYPE_EXPAND = new SplitType("expandContainers", 0.0f);
        @JvmField
        @NotNull
        public static final SplitType SPLIT_TYPE_EQUAL = Companion.ratio(0.5f);
        @JvmField
        @NotNull
        public static final SplitType SPLIT_TYPE_HINGE = new SplitType("hinge", -1.0f);

        public SplitType(@NotNull String description, float value) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.description = description;
            this.value = value;
        }

        @NotNull
        public final String getDescription$window_release() {
            return this.description;
        }

        public final float getValue$window_release() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.description;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof SplitType)) {
                return false;
            }
            return this.value == ((SplitType)other).value && Intrinsics.areEqual((Object)this.description, (Object)((SplitType)other).description);
        }

        public int hashCode() {
            return this.description.hashCode() + 31 * Float.hashCode(this.value);
        }

        @JvmStatic
        @NotNull
        public static final SplitType ratio(@FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float ratio2) {
            return Companion.ratio(ratio2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\nJ\u0012\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/window/embedding/SplitAttributes$SplitType$Companion;", "", "()V", "SPLIT_TYPE_EQUAL", "Landroidx/window/embedding/SplitAttributes$SplitType;", "SPLIT_TYPE_EXPAND", "SPLIT_TYPE_HINGE", "buildSplitTypeFromValue", "value", "", "buildSplitTypeFromValue$window_release", "ratio", "window_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final SplitType ratio(@FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float ratio2) {
                Float f = Float.valueOf(ratio2);
                String string = TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Object t = SpecificationComputer.Companion.startSpecification$default(SpecificationComputer.Companion, f, string, VerificationMode.STRICT, null, 4, null).require("Ratio must be in range (0.0, 1.0). Use SplitType.expandContainers() instead of 0 or 1.", (Function1)new Function1<Float, Boolean>(ratio2){
                    final /* synthetic */ float $ratio;
                    {
                        this.$ratio = $ratio;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(float $this$require) {
                        boolean bl;
                        double d = this.$ratio;
                        boolean bl2 = 0.0 <= d ? d <= 1.0 : false;
                        if (bl2) {
                            Object[] objectArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)};
                            if (!ArraysKt.contains((Object[])objectArray, (Object)Float.valueOf(this.$ratio))) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }).compute();
                Intrinsics.checkNotNull(t);
                float checkedRatio2 = ((Number)t).floatValue();
                return new SplitType("ratio:" + checkedRatio2, checkedRatio2);
            }

            @SuppressLint(value={"Range"})
            @NotNull
            public final SplitType buildSplitTypeFromValue$window_release(@FloatRange(from=0.0, to=1.0, toInclusive=false) float value) {
                return value == SPLIT_TYPE_EXPAND.getValue$window_release() ? SPLIT_TYPE_EXPAND : this.ratio(value);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

