/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExtensionsUtil;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u001f"}, d2={"Landroidx/window/layout/SafeWindowLayoutComponentProvider;", "", "loader", "Ljava/lang/ClassLoader;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "(Ljava/lang/ClassLoader;Landroidx/window/core/ConsumerAdapter;)V", "foldingFeatureClass", "Ljava/lang/Class;", "getFoldingFeatureClass", "()Ljava/lang/Class;", "windowExtensionsClass", "getWindowExtensionsClass", "windowExtensionsProviderClass", "getWindowExtensionsProviderClass", "windowLayoutComponent", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "getWindowLayoutComponent", "()Landroidx/window/extensions/layout/WindowLayoutComponent;", "windowLayoutComponentClass", "getWindowLayoutComponentClass", "canUseWindowLayoutComponent", "", "hasValidVendorApiLevel1", "hasValidVendorApiLevel2", "isFoldingFeatureValid", "isMethodWindowLayoutInfoListenerJavaConsumerValid", "isMethodWindowLayoutInfoListenerWindowConsumerValid", "isWindowExtensionsPresent", "isWindowExtensionsValid", "isWindowLayoutProviderValid", "window_release"})
public final class SafeWindowLayoutComponentProvider {
    @NotNull
    private final ClassLoader loader;
    @NotNull
    private final ConsumerAdapter consumerAdapter;

    public SafeWindowLayoutComponentProvider(@NotNull ClassLoader loader, @NotNull ConsumerAdapter consumerAdapter) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        this.loader = loader;
        this.consumerAdapter = consumerAdapter;
    }

    @Nullable
    public final WindowLayoutComponent getWindowLayoutComponent() {
        WindowLayoutComponent windowLayoutComponent;
        if (this.canUseWindowLayoutComponent()) {
            WindowLayoutComponent windowLayoutComponent2;
            try {
                windowLayoutComponent2 = WindowExtensionsProvider.getWindowExtensions().getWindowLayoutComponent();
            }
            catch (UnsupportedOperationException e) {
                windowLayoutComponent2 = null;
            }
            windowLayoutComponent = windowLayoutComponent2;
        } else {
            windowLayoutComponent = null;
        }
        return windowLayoutComponent;
    }

    private final boolean canUseWindowLayoutComponent() {
        if (!(this.isWindowExtensionsPresent() && this.isWindowExtensionsValid() && this.isWindowLayoutProviderValid() && this.isFoldingFeatureValid())) {
            return false;
        }
        int n = ExtensionsUtil.INSTANCE.getSafeVendorApiLevel();
        return n == 1 ? this.hasValidVendorApiLevel1() : ((2 <= n ? n <= Integer.MAX_VALUE : false) ? this.hasValidVendorApiLevel2() : false);
    }

    private final boolean isWindowExtensionsPresent() {
        return ReflectionUtils.INSTANCE.checkIsPresent$window_release((Function0)new Function0<Class<?>>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Class<?> invoke() {
                Class<?> clazz = SafeWindowLayoutComponentProvider.access$getLoader$p(this.this$0).loadClass("androidx.window.extensions.WindowExtensionsProvider");
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WINDOW_EXTENSIONS_PROVIDER_CLASS)");
                return clazz;
            }
        });
    }

    private final boolean hasValidVendorApiLevel1() {
        return this.isMethodWindowLayoutInfoListenerJavaConsumerValid();
    }

    private final boolean hasValidVendorApiLevel2() {
        return this.hasValidVendorApiLevel1() && this.isMethodWindowLayoutInfoListenerWindowConsumerValid();
    }

    private final boolean isWindowExtensionsValid() {
        return ReflectionUtils.validateReflection$window_release("WindowExtensionsProvider#getWindowExtensions is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class providerClass = SafeWindowLayoutComponentProvider.access$getWindowExtensionsProviderClass(this.this$0);
                Method getWindowExtensionsMethod = providerClass.getDeclaredMethod("getWindowExtensions", new Class[0]);
                Class windowExtensionsClass = SafeWindowLayoutComponentProvider.access$getWindowExtensionsClass(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowExtensionsMethod, (String)"getWindowExtensionsMethod");
                return ReflectionUtils.INSTANCE.doesReturn$window_release(getWindowExtensionsMethod, windowExtensionsClass) && ReflectionUtils.INSTANCE.isPublic$window_release(getWindowExtensionsMethod);
            }
        }));
    }

    private final boolean isWindowLayoutProviderValid() {
        return ReflectionUtils.validateReflection$window_release("WindowExtensions#getWindowLayoutComponent is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class extensionsClass = SafeWindowLayoutComponentProvider.access$getWindowExtensionsClass(this.this$0);
                Method getWindowLayoutComponentMethod = extensionsClass.getMethod("getWindowLayoutComponent", new Class[0]);
                Class windowLayoutComponentClass = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowLayoutComponentMethod, (String)"getWindowLayoutComponentMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(getWindowLayoutComponentMethod) && ReflectionUtils.INSTANCE.doesReturn$window_release(getWindowLayoutComponentMethod, windowLayoutComponentClass);
            }
        }));
    }

    private final boolean isFoldingFeatureValid() {
        return ReflectionUtils.validateReflection$window_release("FoldingFeature class is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class foldingFeatureClass = SafeWindowLayoutComponentProvider.access$getFoldingFeatureClass(this.this$0);
                Method getBoundsMethod = foldingFeatureClass.getMethod("getBounds", new Class[0]);
                Method getTypeMethod = foldingFeatureClass.getMethod("getType", new Class[0]);
                Method getStateMethod = foldingFeatureClass.getMethod("getState", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)getBoundsMethod, (String)"getBoundsMethod");
                if (ReflectionUtils.INSTANCE.doesReturn$window_release(getBoundsMethod, Reflection.getOrCreateKotlinClass(Rect.class)) && ReflectionUtils.INSTANCE.isPublic$window_release(getBoundsMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)getTypeMethod, (String)"getTypeMethod");
                    if (ReflectionUtils.INSTANCE.doesReturn$window_release(getTypeMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && ReflectionUtils.INSTANCE.isPublic$window_release(getTypeMethod)) {
                        Intrinsics.checkNotNullExpressionValue((Object)getStateMethod, (String)"getStateMethod");
                        if (ReflectionUtils.INSTANCE.doesReturn$window_release(getStateMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && ReflectionUtils.INSTANCE.isPublic$window_release(getStateMethod)) {
                            bl = true;
                            return bl;
                        }
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isMethodWindowLayoutInfoListenerJavaConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("WindowLayoutComponent#addWindowLayoutInfoListener(" + Activity.class.getName() + ", java.util.function.Consumer) is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class<?> clazz = SafeWindowLayoutComponentProvider.access$getConsumerAdapter$p(this.this$0).consumerClassOrNull$window_release();
                if (clazz == null) {
                    return false;
                }
                Class<?> consumerClass = clazz;
                Class windowLayoutComponent = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Class[] classArray = new Class[]{Activity.class, consumerClass};
                Method addListenerMethod = windowLayoutComponent.getMethod("addWindowLayoutInfoListener", classArray);
                Class[] classArray2 = new Class[]{consumerClass};
                Method removeListenerMethod = windowLayoutComponent.getMethod("removeWindowLayoutInfoListener", classArray2);
                Intrinsics.checkNotNullExpressionValue((Object)addListenerMethod, (String)"addListenerMethod");
                if (ReflectionUtils.INSTANCE.isPublic$window_release(addListenerMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)removeListenerMethod, (String)"removeListenerMethod");
                    if (ReflectionUtils.INSTANCE.isPublic$window_release(removeListenerMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isMethodWindowLayoutInfoListenerWindowConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("WindowLayoutComponent#addWindowLayoutInfoListener(" + Context.class.getName() + ", androidx.window.extensions.core.util.function.Consumer) is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class windowLayoutComponent = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Class[] classArray = new Class[]{Context.class, Consumer.class};
                Method addListenerMethod = windowLayoutComponent.getMethod("addWindowLayoutInfoListener", classArray);
                Class[] classArray2 = new Class[]{Consumer.class};
                Method removeListenerMethod = windowLayoutComponent.getMethod("removeWindowLayoutInfoListener", classArray2);
                Intrinsics.checkNotNullExpressionValue((Object)addListenerMethod, (String)"addListenerMethod");
                if (ReflectionUtils.INSTANCE.isPublic$window_release(addListenerMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)removeListenerMethod, (String)"removeListenerMethod");
                    if (ReflectionUtils.INSTANCE.isPublic$window_release(removeListenerMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final Class<?> getWindowExtensionsProviderClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.WindowExtensionsProvider");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WINDOW_EXTENSIONS_PROVIDER_CLASS)");
        return clazz;
    }

    private final Class<?> getWindowExtensionsClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.WindowExtensions");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WINDOW_EXTENSIONS_CLASS)");
        return clazz;
    }

    private final Class<?> getFoldingFeatureClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.layout.FoldingFeature");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(FOLDING_FEATURE_CLASS)");
        return clazz;
    }

    private final Class<?> getWindowLayoutComponentClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.layout.WindowLayoutComponent");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WINDOW_LAYOUT_COMPONENT_CLASS)");
        return clazz;
    }

    public static final /* synthetic */ ClassLoader access$getLoader$p(SafeWindowLayoutComponentProvider $this) {
        return $this.loader;
    }

    public static final /* synthetic */ Class access$getWindowExtensionsProviderClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getWindowExtensionsProviderClass();
    }

    public static final /* synthetic */ Class access$getWindowExtensionsClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getWindowExtensionsClass();
    }

    public static final /* synthetic */ Class access$getWindowLayoutComponentClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getWindowLayoutComponentClass();
    }

    public static final /* synthetic */ Class access$getFoldingFeatureClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getFoldingFeatureClass();
    }

    public static final /* synthetic */ ConsumerAdapter access$getConsumerAdapter$p(SafeWindowLayoutComponentProvider $this) {
        return $this.consumerAdapter;
    }
}

