/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.core.view.WindowInsetsCompat;
import androidx.window.layout.WindowMetrics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Landroidx/window/layout/util/ContextCompatHelperApi30;", "", "()V", "currentWindowBounds", "Landroid/graphics/Rect;", "context", "Landroid/content/Context;", "currentWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "activity", "Landroid/app/Activity;", "currentWindowMetrics", "Landroidx/window/layout/WindowMetrics;", "maximumWindowBounds", "window_release"})
@RequiresApi(value=30)
public final class ContextCompatHelperApi30 {
    @NotNull
    public static final ContextCompatHelperApi30 INSTANCE = new ContextCompatHelperApi30();

    private ContextCompatHelperApi30() {
    }

    @NotNull
    public final WindowMetrics currentWindowMetrics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)wm.getCurrentWindowMetrics().getWindowInsets());
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(wm.\u2026ndowMetrics.windowInsets)");
        WindowInsetsCompat insets = windowInsetsCompat;
        Rect rect = wm.getCurrentWindowMetrics().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"wm.currentWindowMetrics.bounds");
        return new WindowMetrics(rect, insets);
    }

    @NotNull
    public final Rect currentWindowBounds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        Rect rect = wm.getCurrentWindowMetrics().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"wm.currentWindowMetrics.bounds");
        return rect;
    }

    @NotNull
    public final WindowInsetsCompat currentWindowInsets(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)wm.getCurrentWindowMetrics().getWindowInsets());
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(wm.\u2026ndowMetrics.windowInsets)");
        return windowInsetsCompat;
    }

    @NotNull
    public final Rect maximumWindowBounds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WindowManager wm = (WindowManager)context.getSystemService(WindowManager.class);
        Rect rect = wm.getMaximumWindowMetrics().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"wm.maximumWindowMetrics.bounds");
        return rect;
    }

    @DoNotInline
    @NotNull
    public final WindowInsetsCompat currentWindowInsets(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        WindowInsets windowInsets = activity.getWindowManager().getCurrentWindowMetrics().getWindowInsets();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"activity.windowManager.c\u2026indowMetrics.windowInsets");
        WindowInsets platformInsets = windowInsets;
        WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)platformInsets);
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(platformInsets)");
        return windowInsetsCompat;
    }
}

