/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.reflection;

import android.util.Log;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\u00042\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0000\u00a2\u0006\u0002\b\fJ'\u0010\r\u001a\u00020\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0001\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u0012\u001a\u00020\u0004*\u00020\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0012\u001a\u00020\u0004*\u00020\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0000\u00a2\u0006\u0002\b\u0014R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Landroidx/window/reflection/ReflectionUtils;", "", "()V", "isPublic", "", "Ljava/lang/reflect/Method;", "isPublic$window_release", "(Ljava/lang/reflect/Method;)Z", "checkIsPresent", "classLoader", "Lkotlin/Function0;", "Ljava/lang/Class;", "checkIsPresent$window_release", "validateReflection", "errorMessage", "", "block", "validateReflection$window_release", "doesReturn", "clazz", "doesReturn$window_release", "Lkotlin/reflect/KClass;", "window_release"})
public final class ReflectionUtils {
    @NotNull
    public static final ReflectionUtils INSTANCE = new ReflectionUtils();

    private ReflectionUtils() {
    }

    public final boolean checkIsPresent$window_release(@NotNull Function0<? extends Class<?>> classLoader) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classLoader, (String)"classLoader");
        try {
            classLoader.invoke();
            bl = true;
        }
        catch (ClassNotFoundException noClass) {
            bl = false;
        }
        catch (NoClassDefFoundError noDefinition) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean validateReflection$window_release(@Nullable String errorMessage, @NotNull Function0<Boolean> block) {
        boolean bl;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            boolean result = (Boolean)block.invoke();
            if (!result && errorMessage != null) {
                Log.e((String)"ReflectionGuard", (String)errorMessage);
            }
        }
        catch (ClassNotFoundException noClass) {
            StringBuilder stringBuilder = new StringBuilder().append("ClassNotFound: ");
            String string = errorMessage;
            if (string == null) {
                string = "";
            }
            Log.e((String)"ReflectionGuard", (String)stringBuilder.append(string).toString());
            bl = false;
        }
        catch (NoSuchMethodException noMethod) {
            StringBuilder stringBuilder = new StringBuilder().append("NoSuchMethod: ");
            String string = errorMessage;
            if (string == null) {
                string = "";
            }
            Log.e((String)"ReflectionGuard", (String)stringBuilder.append(string).toString());
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean validateReflection$window_release$default(String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ReflectionUtils.validateReflection$window_release(string, (Function0<Boolean>)function0);
    }

    public final boolean isPublic$window_release(@NotNull Method $this$isPublic) {
        Intrinsics.checkNotNullParameter((Object)$this$isPublic, (String)"<this>");
        return Modifier.isPublic($this$isPublic.getModifiers());
    }

    public final boolean doesReturn$window_release(@NotNull Method $this$doesReturn, @NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$doesReturn, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.doesReturn$window_release($this$doesReturn, JvmClassMappingKt.getJavaClass(clazz));
    }

    public final boolean doesReturn$window_release(@NotNull Method $this$doesReturn, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$doesReturn, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return $this$doesReturn.getReturnType().equals(clazz);
    }
}

