/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.load.resource.drawable.DrawableDecoderCompat;
import com.bumptech.glide.load.resource.drawable.ResourceDrawableDecoder;
import com.bumptech.glide.signature.ObjectKey;
import java.io.IOException;
import java.io.InputStream;

public final class DirectResourceLoader<DataT>
implements ModelLoader<Integer, DataT> {
    private final Context context;
    private final ResourceOpener<DataT> resourceOpener;

    public static ModelLoaderFactory<Integer, InputStream> inputStreamFactory(Context context) {
        return new InputStreamFactory(context);
    }

    public static ModelLoaderFactory<Integer, AssetFileDescriptor> assetFileDescriptorFactory(Context context) {
        return new AssetFileDescriptorFactory(context);
    }

    public static ModelLoaderFactory<Integer, Drawable> drawableFactory(Context context) {
        return new DrawableFactory(context);
    }

    DirectResourceLoader(Context context, ResourceOpener<DataT> resourceOpener) {
        this.context = context.getApplicationContext();
        this.resourceOpener = resourceOpener;
    }

    @Override
    public ModelLoader.LoadData<DataT> buildLoadData(@NonNull Integer resourceId, int width, int height, @NonNull Options options) {
        Resources.Theme theme = options.get(ResourceDrawableDecoder.THEME);
        Resources resources = Build.VERSION.SDK_INT >= 21 && theme != null ? theme.getResources() : this.context.getResources();
        return new ModelLoader.LoadData<DataT>(new ObjectKey(resourceId), new ResourceDataFetcher<DataT>(theme, resources, this.resourceOpener, resourceId));
    }

    @Override
    public boolean handles(@NonNull Integer integer) {
        return true;
    }

    private static final class ResourceDataFetcher<DataT>
    implements DataFetcher<DataT> {
        @Nullable
        private final Resources.Theme theme;
        private final Resources resources;
        private final ResourceOpener<DataT> resourceOpener;
        private final int resourceId;
        @Nullable
        private DataT data;

        ResourceDataFetcher(@Nullable Resources.Theme theme, Resources resources, ResourceOpener<DataT> resourceOpener, int resourceId) {
            this.theme = theme;
            this.resources = resources;
            this.resourceOpener = resourceOpener;
            this.resourceId = resourceId;
        }

        @Override
        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super DataT> callback) {
            try {
                this.data = this.resourceOpener.open(this.theme, this.resources, this.resourceId);
                callback.onDataReady(this.data);
            }
            catch (Resources.NotFoundException e) {
                callback.onLoadFailed((Exception)((Object)e));
            }
        }

        @Override
        public void cleanup() {
            DataT local = this.data;
            if (local != null) {
                try {
                    this.resourceOpener.close(local);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<DataT> getDataClass() {
            return this.resourceOpener.getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }

    private static final class DrawableFactory
    implements ModelLoaderFactory<Integer, Drawable>,
    ResourceOpener<Drawable> {
        private final Context context;

        DrawableFactory(Context context) {
            this.context = context;
        }

        @Override
        public Drawable open(@Nullable Resources.Theme theme, Resources resources, int resourceId) {
            return DrawableDecoderCompat.getDrawable(this.context, resourceId, theme);
        }

        @Override
        public void close(Drawable data) throws IOException {
        }

        @Override
        public Class<Drawable> getDataClass() {
            return Drawable.class;
        }

        @Override
        @NonNull
        public ModelLoader<Integer, Drawable> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new DirectResourceLoader<Drawable>(this.context, this);
        }

        @Override
        public void teardown() {
        }
    }

    private static final class InputStreamFactory
    implements ModelLoaderFactory<Integer, InputStream>,
    ResourceOpener<InputStream> {
        private final Context context;

        InputStreamFactory(Context context) {
            this.context = context;
        }

        @Override
        @NonNull
        public ModelLoader<Integer, InputStream> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new DirectResourceLoader<InputStream>(this.context, this);
        }

        @Override
        public InputStream open(@Nullable Resources.Theme theme, Resources resources, int resourceId) {
            return resources.openRawResource(resourceId);
        }

        @Override
        public void close(InputStream data) throws IOException {
            data.close();
        }

        @Override
        public Class<InputStream> getDataClass() {
            return InputStream.class;
        }

        @Override
        public void teardown() {
        }
    }

    private static final class AssetFileDescriptorFactory
    implements ModelLoaderFactory<Integer, AssetFileDescriptor>,
    ResourceOpener<AssetFileDescriptor> {
        private final Context context;

        AssetFileDescriptorFactory(Context context) {
            this.context = context;
        }

        @Override
        public AssetFileDescriptor open(@Nullable Resources.Theme theme, Resources resources, int resourceId) {
            return resources.openRawResourceFd(resourceId);
        }

        @Override
        public void close(AssetFileDescriptor data) throws IOException {
            data.close();
        }

        @Override
        public Class<AssetFileDescriptor> getDataClass() {
            return AssetFileDescriptor.class;
        }

        @Override
        @NonNull
        public ModelLoader<Integer, AssetFileDescriptor> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new DirectResourceLoader<AssetFileDescriptor>(this.context, this);
        }

        @Override
        public void teardown() {
        }
    }

    private static interface ResourceOpener<DataT> {
        public DataT open(@Nullable Resources.Theme var1, Resources var2, int var3);

        public void close(DataT var1) throws IOException;

        public Class<DataT> getDataClass();
    }
}

