/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.drawable;

import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.DefaultOnHeaderDecodedListener;
import com.bumptech.glide.util.ByteBufferUtil;
import com.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

@RequiresApi(value=28)
public final class AnimatedImageDecoder {
    private final List<ImageHeaderParser> imageHeaderParsers;
    private final ArrayPool arrayPool;

    public static ResourceDecoder<InputStream, Drawable> streamDecoder(List<ImageHeaderParser> imageHeaderParsers, ArrayPool arrayPool) {
        return new StreamAnimatedImageDecoder(new AnimatedImageDecoder(imageHeaderParsers, arrayPool));
    }

    public static ResourceDecoder<ByteBuffer, Drawable> byteBufferDecoder(List<ImageHeaderParser> imageHeaderParsers, ArrayPool arrayPool) {
        return new ByteBufferAnimatedImageDecoder(new AnimatedImageDecoder(imageHeaderParsers, arrayPool));
    }

    private AnimatedImageDecoder(List<ImageHeaderParser> imageHeaderParsers, ArrayPool arrayPool) {
        this.imageHeaderParsers = imageHeaderParsers;
        this.arrayPool = arrayPool;
    }

    boolean handles(ByteBuffer byteBuffer) throws IOException {
        return this.isHandled(ImageHeaderParserUtils.getType(this.imageHeaderParsers, byteBuffer));
    }

    boolean handles(InputStream is) throws IOException {
        return this.isHandled(ImageHeaderParserUtils.getType(this.imageHeaderParsers, is, this.arrayPool));
    }

    private boolean isHandled(ImageHeaderParser.ImageType imageType) {
        return imageType == ImageHeaderParser.ImageType.ANIMATED_WEBP || Build.VERSION.SDK_INT >= 31 && imageType == ImageHeaderParser.ImageType.ANIMATED_AVIF;
    }

    Resource<Drawable> decode(@NonNull ImageDecoder.Source source, int width, int height, @NonNull Options options) throws IOException {
        Drawable decoded = ImageDecoder.decodeDrawable((ImageDecoder.Source)source, (ImageDecoder.OnHeaderDecodedListener)new DefaultOnHeaderDecodedListener(width, height, options));
        if (!(decoded instanceof AnimatedImageDrawable)) {
            throw new IOException("Received unexpected drawable type for animated image, failing: " + decoded);
        }
        return new AnimatedImageDrawableResource((AnimatedImageDrawable)decoded);
    }

    private static final class ByteBufferAnimatedImageDecoder
    implements ResourceDecoder<ByteBuffer, Drawable> {
        private final AnimatedImageDecoder delegate;

        ByteBufferAnimatedImageDecoder(AnimatedImageDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean handles(@NonNull ByteBuffer source, @NonNull Options options) throws IOException {
            return this.delegate.handles(source);
        }

        @Override
        public Resource<Drawable> decode(@NonNull ByteBuffer byteBuffer, int width, int height, @NonNull Options options) throws IOException {
            ImageDecoder.Source source = ImageDecoder.createSource((ByteBuffer)byteBuffer);
            return this.delegate.decode(source, width, height, options);
        }
    }

    private static final class StreamAnimatedImageDecoder
    implements ResourceDecoder<InputStream, Drawable> {
        private final AnimatedImageDecoder delegate;

        StreamAnimatedImageDecoder(AnimatedImageDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean handles(@NonNull InputStream source, @NonNull Options options) throws IOException {
            return this.delegate.handles(source);
        }

        @Override
        public Resource<Drawable> decode(@NonNull InputStream is, int width, int height, @NonNull Options options) throws IOException {
            ImageDecoder.Source source = ImageDecoder.createSource((ByteBuffer)ByteBufferUtil.fromStream(is));
            return this.delegate.decode(source, width, height, options);
        }
    }

    private static final class AnimatedImageDrawableResource
    implements Resource<Drawable> {
        private static final int ESTIMATED_NUMBER_OF_FRAMES = 2;
        private final AnimatedImageDrawable imageDrawable;

        AnimatedImageDrawableResource(AnimatedImageDrawable imageDrawable) {
            this.imageDrawable = imageDrawable;
        }

        @Override
        @NonNull
        public Class<Drawable> getResourceClass() {
            return Drawable.class;
        }

        @Override
        @NonNull
        public AnimatedImageDrawable get() {
            return this.imageDrawable;
        }

        @Override
        public int getSize() {
            return this.imageDrawable.getIntrinsicWidth() * this.imageDrawable.getIntrinsicHeight() * Util.getBytesPerPixel(Bitmap.Config.ARGB_8888) * 2;
        }

        @Override
        public void recycle() {
            this.imageDrawable.stop();
            this.imageDrawable.clearAnimationCallbacks();
        }
    }
}

