/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.LifecycleListener;
import com.bumptech.glide.util.Util;
import java.util.HashSet;
import java.util.Set;

final class LifecycleLifecycle
implements Lifecycle,
LifecycleObserver {
    @NonNull
    private final Set<LifecycleListener> lifecycleListeners = new HashSet<LifecycleListener>();
    @NonNull
    private final androidx.lifecycle.Lifecycle lifecycle;

    LifecycleLifecycle(androidx.lifecycle.Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart(@NonNull LifecycleOwner owner) {
        for (LifecycleListener lifecycleListener : Util.getSnapshot(this.lifecycleListeners)) {
            lifecycleListener.onStart();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop(@NonNull LifecycleOwner owner) {
        for (LifecycleListener lifecycleListener : Util.getSnapshot(this.lifecycleListeners)) {
            lifecycleListener.onStop();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy(@NonNull LifecycleOwner owner) {
        for (LifecycleListener lifecycleListener : Util.getSnapshot(this.lifecycleListeners)) {
            lifecycleListener.onDestroy();
        }
        owner.getLifecycle().removeObserver((LifecycleObserver)this);
    }

    @Override
    public void addListener(@NonNull LifecycleListener listener) {
        this.lifecycleListeners.add(listener);
        if (this.lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            listener.onDestroy();
        } else if (this.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
            listener.onStart();
        } else {
            listener.onStop();
        }
    }

    @Override
    public void removeListener(@NonNull LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }
}

