/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.model.Model;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final int HASH_MULTIPLIER = 31;
    private static final int HASH_ACCUMULATOR = 17;
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_256_CHARS = new char[64];
    @Nullable
    private static volatile Handler mainThreadHandler;

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String sha256BytesToHex(@NonNull byte[] bytes) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(bytes, SHA_256_CHARS);
        }
    }

    @NonNull
    private static String bytesToHex(@NonNull byte[] bytes, @NonNull char[] hexChars) {
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    @Deprecated
    public static int getSize(@NonNull Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @TargetApi(value=19)
    public static int getBitmapByteSize(@NonNull Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new IllegalStateException("Cannot obtain size for recycled Bitmap: " + bitmap + "[" + bitmap.getWidth() + "x" + bitmap.getHeight() + "] " + bitmap.getConfig());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bitmap.getHeight() * bitmap.getRowBytes();
    }

    public static int getBitmapByteSize(int width, int height, @Nullable Bitmap.Config config) {
        return width * height * Util.getBytesPerPixel(config);
    }

    public static int getBytesPerPixel(@Nullable Bitmap.Config config) {
        int bytesPerPixel;
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        switch (config) {
            case ALPHA_8: {
                bytesPerPixel = 1;
                break;
            }
            case RGB_565: 
            case ARGB_4444: {
                bytesPerPixel = 2;
                break;
            }
            case RGBA_F16: {
                bytesPerPixel = 8;
                break;
            }
            default: {
                bytesPerPixel = 4;
            }
        }
        return bytesPerPixel;
    }

    public static boolean isValidDimensions(int width, int height) {
        return Util.isValidDimension(width) && Util.isValidDimension(height);
    }

    public static boolean isValidDimension(int dimen) {
        return dimen > 0 || dimen == Integer.MIN_VALUE;
    }

    public static void postOnUiThread(Runnable runnable) {
        Util.getUiThreadHandler().post(runnable);
    }

    public static void removeCallbacksOnUiThread(Runnable runnable) {
        Util.getUiThreadHandler().removeCallbacks(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler getUiThreadHandler() {
        if (mainThreadHandler != null) return mainThreadHandler;
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            if (mainThreadHandler != null) return mainThreadHandler;
            mainThreadHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mainThreadHandler;
        }
    }

    public static void assertMainThread() {
        if (!Util.isOnMainThread()) {
            throw new IllegalArgumentException("You must call this method on the main thread");
        }
    }

    public static void assertBackgroundThread() {
        if (!Util.isOnBackgroundThread()) {
            throw new IllegalArgumentException("You must call this method on a background thread");
        }
    }

    public static boolean isOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isOnBackgroundThread() {
        return !Util.isOnMainThread();
    }

    @NonNull
    public static <T> Queue<T> createQueue(int size) {
        return new ArrayDeque(size);
    }

    @NonNull
    public static <T> List<T> getSnapshot(@NonNull Collection<T> other) {
        ArrayList<T> result = new ArrayList<T>(other.size());
        for (T item : other) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public static boolean bothNullOrEqual(@Nullable Object a, @Nullable Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static boolean bothModelsNullEquivalentOrEquals(@Nullable Object a, @Nullable Object b) {
        if (a == null) {
            return b == null;
        }
        if (a instanceof Model) {
            return ((Model)a).isEquivalentTo(b);
        }
        return a.equals(b);
    }

    public static int hashCode(int value) {
        return Util.hashCode(value, 17);
    }

    public static int hashCode(int value, int accumulator) {
        return accumulator * 31 + value;
    }

    public static int hashCode(float value) {
        return Util.hashCode(value, 17);
    }

    public static int hashCode(float value, int accumulator) {
        return Util.hashCode(Float.floatToIntBits(value), accumulator);
    }

    public static int hashCode(@Nullable Object object, int accumulator) {
        return Util.hashCode(object == null ? 0 : object.hashCode(), accumulator);
    }

    public static int hashCode(boolean value, int accumulator) {
        return Util.hashCode(value ? 1 : 0, accumulator);
    }

    public static int hashCode(boolean value) {
        return Util.hashCode(value, 17);
    }
}

