/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import com.microsoft.maui.PlatformContentViewGroup;

public abstract class PlatformWrapperView
extends PlatformContentViewGroup {
    private final Rect viewBounds = new Rect();
    private boolean hasShadow;

    public PlatformWrapperView(Context context) {
        super(context);
        this.setClipChildren(false);
        this.setWillNotDraw(true);
    }

    protected final void setHasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        View child = this.getChildAt(0);
        this.viewBounds.set(0, 0, View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        child.measure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.hasShadow) {
            int viewWidth = this.viewBounds.width();
            int viewHeight = this.viewBounds.height();
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                if (viewWidth == 0) {
                    viewWidth = child.getMeasuredWidth();
                }
                if (viewHeight == 0) {
                    viewHeight = child.getMeasuredHeight();
                }
            }
            this.drawShadow(canvas, viewWidth, viewHeight);
        }
        super.dispatchDraw(canvas);
    }

    protected abstract void drawShadow(@NonNull Canvas var1, int var2, int var3);
}

