/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.KeyTemplate;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class KmsEnvelopeAead
implements Aead {
    private static final byte[] EMPTY_AAD = new byte[0];
    private final KeyTemplate dekTemplate;
    private final Aead remote;
    private static final int LENGTH_ENCRYPTED_DEK = 4;
    private static final Set<String> supportedDekKeyTypes = KmsEnvelopeAead.listSupportedDekKeyTypes();

    private static Set<String> listSupportedDekKeyTypes() {
        HashSet<String> dekKeyTypeUrls = new HashSet<String>();
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.AesGcmKey");
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key");
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.XChaCha20Poly1305Key");
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey");
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.AesGcmSivKey");
        dekKeyTypeUrls.add("type.googleapis.com/google.crypto.tink.AesEaxKey");
        return Collections.unmodifiableSet(dekKeyTypeUrls);
    }

    public static boolean isSupportedDekKeyType(String dekKeyTypeUrl) {
        return supportedDekKeyTypes.contains(dekKeyTypeUrl);
    }

    public KmsEnvelopeAead(KeyTemplate dekTemplate, Aead remote) {
        if (!KmsEnvelopeAead.isSupportedDekKeyType(dekTemplate.getTypeUrl())) {
            throw new IllegalArgumentException("Unsupported DEK key type: " + dekTemplate.getTypeUrl() + ". Only Tink AEAD key types are supported.");
        }
        this.dekTemplate = dekTemplate;
        this.remote = remote;
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        byte[] dek = Registry.newKeyData(this.dekTemplate).getValue().toByteArray();
        byte[] encryptedDek = this.remote.encrypt(dek, EMPTY_AAD);
        Aead aead = Registry.getPrimitive(this.dekTemplate.getTypeUrl(), dek, Aead.class);
        byte[] payload = aead.encrypt(plaintext, associatedData);
        return this.buildCiphertext(encryptedDek, payload);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(ciphertext);
            int encryptedDekSize = buffer.getInt();
            if (encryptedDekSize <= 0 || encryptedDekSize > ciphertext.length - 4) {
                throw new GeneralSecurityException("invalid ciphertext");
            }
            byte[] encryptedDek = new byte[encryptedDekSize];
            buffer.get(encryptedDek, 0, encryptedDekSize);
            byte[] payload = new byte[buffer.remaining()];
            buffer.get(payload, 0, buffer.remaining());
            byte[] dek = this.remote.decrypt(encryptedDek, EMPTY_AAD);
            Aead aead = Registry.getPrimitive(this.dekTemplate.getTypeUrl(), dek, Aead.class);
            return aead.decrypt(payload, associatedData);
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | BufferUnderflowException e) {
            throw new GeneralSecurityException("invalid ciphertext", e);
        }
    }

    private byte[] buildCiphertext(byte[] encryptedDek, byte[] payload) {
        return ByteBuffer.allocate(4 + encryptedDek.length + payload.length).putInt(encryptedDek.length).put(encryptedDek).put(payload).array();
    }
}

