/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.KmsEnvelopeAead;
import com.google.crypto.tink.internal.KeyTemplateProtoConverter;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKey;
import com.google.crypto.tink.proto.KmsEnvelopeAeadKeyFormat;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;

public class KmsEnvelopeAeadKeyManager
extends KeyTypeManager<KmsEnvelopeAeadKey> {
    private static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsEnvelopeAeadKey";

    KmsEnvelopeAeadKeyManager() {
        super(KmsEnvelopeAeadKey.class, new PrimitiveFactory<Aead, KmsEnvelopeAeadKey>(Aead.class){

            @Override
            public Aead getPrimitive(KmsEnvelopeAeadKey keyProto) throws GeneralSecurityException {
                String keyUri = keyProto.getParams().getKekUri();
                KmsClient kmsClient = KmsClients.get(keyUri);
                Aead remote = kmsClient.getAead(keyUri);
                return new KmsEnvelopeAead(keyProto.getParams().getDekTemplate(), remote);
            }
        });
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.REMOTE;
    }

    @Override
    public void validateKey(KmsEnvelopeAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (!KmsEnvelopeAead.isSupportedDekKeyType(key.getParams().getDekTemplate().getTypeUrl())) {
            throw new GeneralSecurityException("Unsupported DEK key type: " + key.getParams().getDekTemplate().getTypeUrl() + ". Only Tink AEAD key types are supported.");
        }
    }

    @Override
    public KmsEnvelopeAeadKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return KmsEnvelopeAeadKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<KmsEnvelopeAeadKeyFormat, KmsEnvelopeAeadKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<KmsEnvelopeAeadKeyFormat, KmsEnvelopeAeadKey>(KmsEnvelopeAeadKeyFormat.class){

            @Override
            public void validateKeyFormat(KmsEnvelopeAeadKeyFormat format) throws GeneralSecurityException {
                if (!KmsEnvelopeAead.isSupportedDekKeyType(format.getDekTemplate().getTypeUrl())) {
                    throw new GeneralSecurityException("Unsupported DEK key type: " + format.getDekTemplate().getTypeUrl() + ". Only Tink AEAD key types are supported.");
                }
                if (format.getKekUri().isEmpty() || !format.hasDekTemplate()) {
                    throw new GeneralSecurityException("invalid key format: missing KEK URI or DEK template");
                }
            }

            @Override
            public KmsEnvelopeAeadKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return KmsEnvelopeAeadKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public KmsEnvelopeAeadKey createKey(KmsEnvelopeAeadKeyFormat format) throws GeneralSecurityException {
                return (KmsEnvelopeAeadKey)KmsEnvelopeAeadKey.newBuilder().setParams(format).setVersion(KmsEnvelopeAeadKeyManager.this.getVersion()).build();
            }
        };
    }

    public static KeyTemplate createKeyTemplate(String kekUri, KeyTemplate dekTemplate) {
        try {
            KmsEnvelopeAeadKeyFormat format = KmsEnvelopeAeadKeyManager.createKeyFormat(kekUri, dekTemplate);
            return KeyTemplate.create(TYPE_URL, format.toByteArray(), KeyTemplate.OutputPrefixType.RAW);
        }
        catch (InvalidProtocolBufferException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to serialize key template", e);
        }
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new KmsEnvelopeAeadKeyManager(), newKeyAllowed);
    }

    static KmsEnvelopeAeadKeyFormat createKeyFormat(String kekUri, KeyTemplate dekTemplate) throws GeneralSecurityException, InvalidProtocolBufferException {
        com.google.crypto.tink.proto.KeyTemplate protoDekTemplate = KeyTemplateProtoConverter.toProto(dekTemplate);
        if (!KmsEnvelopeAead.isSupportedDekKeyType(protoDekTemplate.getTypeUrl())) {
            throw new IllegalArgumentException("Unsupported DEK key type: " + protoDekTemplate.getTypeUrl() + ". Only Tink AEAD key types are supported.");
        }
        return (KmsEnvelopeAeadKeyFormat)KmsEnvelopeAeadKeyFormat.newBuilder().setDekTemplate(protoDekTemplate).setKekUri(kekUri).build();
    }
}

