/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.hybrid.EciesParameters;
import com.google.crypto.tink.hybrid.HybridPublicKey;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.util.Bytes;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.RestrictedApi;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Objects;
import javax.annotation.Nullable;

@Immutable
public final class EciesPublicKey
extends HybridPublicKey {
    private final EciesParameters parameters;
    private final Bytes publicPointBytes;
    private final Bytes outputPrefix;
    @Nullable
    private final Integer idRequirement;

    private EciesPublicKey(EciesParameters parameters, Bytes publicPointBytes, Bytes outputPrefix, @Nullable Integer idRequirement) {
        this.parameters = parameters;
        this.publicPointBytes = publicPointBytes;
        this.outputPrefix = outputPrefix;
        this.idRequirement = idRequirement;
    }

    private static void validateIdRequirement(EciesParameters.Variant variant, @Nullable Integer idRequirement) throws GeneralSecurityException {
        if (!variant.equals(EciesParameters.Variant.NO_PREFIX) && idRequirement == null) {
            throw new GeneralSecurityException("'idRequirement' must be non-null for " + variant + " variant.");
        }
        if (variant.equals(EciesParameters.Variant.NO_PREFIX) && idRequirement != null) {
            throw new GeneralSecurityException("'idRequirement' must be null for NO_PREFIX variant.");
        }
    }

    private static EllipticCurve getParameterSpecNistCurve(EciesParameters.CurveType curveType) {
        if (curveType == EciesParameters.CurveType.NIST_P256) {
            return EllipticCurves.getNistP256Params().getCurve();
        }
        if (curveType == EciesParameters.CurveType.NIST_P384) {
            return EllipticCurves.getNistP384Params().getCurve();
        }
        if (curveType == EciesParameters.CurveType.NIST_P521) {
            return EllipticCurves.getNistP521Params().getCurve();
        }
        throw new IllegalArgumentException("Unable to determine NIST curve type for " + curveType);
    }

    private static EllipticCurves.PointFormatType getPointFormatType(EciesParameters.PointFormat pointFormat) {
        if (pointFormat == EciesParameters.PointFormat.COMPRESSED) {
            return EllipticCurves.PointFormatType.COMPRESSED;
        }
        if (pointFormat == EciesParameters.PointFormat.UNCOMPRESSED) {
            return EllipticCurves.PointFormatType.UNCOMPRESSED;
        }
        if (pointFormat == EciesParameters.PointFormat.LEGACY_UNCOMPRESSED) {
            return EllipticCurves.PointFormatType.DO_NOT_USE_CRUNCHY_UNCOMPRESSED;
        }
        throw new IllegalArgumentException("Unable to determine point format type for " + pointFormat);
    }

    private static void validatePublicPoint(EciesParameters.CurveType curveType, EciesParameters.PointFormat pointFormat, Bytes publicPointBytes) throws GeneralSecurityException {
        if (curveType == EciesParameters.CurveType.X25519) {
            if (publicPointBytes.size() != 32) {
                throw new GeneralSecurityException("Encoded public point byte length for X25519 curve must be 32");
            }
            return;
        }
        EllipticCurve curve = EciesPublicKey.getParameterSpecNistCurve(curveType);
        EllipticCurves.PointFormatType pointFormatType = EciesPublicKey.getPointFormatType(pointFormat);
        ECPoint unused = EllipticCurves.pointDecode(curve, pointFormatType, publicPointBytes.toByteArray());
    }

    private static Bytes createOutputPrefix(EciesParameters.Variant variant, @Nullable Integer idRequirement) {
        if (variant == EciesParameters.Variant.NO_PREFIX) {
            return Bytes.copyFrom(new byte[0]);
        }
        if (idRequirement == null) {
            throw new IllegalStateException("idRequirement must be non-null for EciesParameters.Variant: " + variant);
        }
        if (variant == EciesParameters.Variant.CRUNCHY) {
            return Bytes.copyFrom(ByteBuffer.allocate(5).put((byte)0).putInt(idRequirement).array());
        }
        if (variant == EciesParameters.Variant.TINK) {
            return Bytes.copyFrom(ByteBuffer.allocate(5).put((byte)1).putInt(idRequirement).array());
        }
        throw new IllegalStateException("Unknown EciesParameters.Variant: " + variant);
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public static EciesPublicKey create(EciesParameters parameters, Bytes publicPointBytes, @Nullable Integer idRequirement) throws GeneralSecurityException {
        EciesPublicKey.validateIdRequirement(parameters.getVariant(), idRequirement);
        EciesPublicKey.validatePublicPoint(parameters.getCurveType(), parameters.getPointFormat(), publicPointBytes);
        Bytes prefix = EciesPublicKey.createOutputPrefix(parameters.getVariant(), idRequirement);
        return new EciesPublicKey(parameters, publicPointBytes, prefix, idRequirement);
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public Bytes getPublicPointBytes() {
        return this.publicPointBytes;
    }

    @Override
    public Bytes getOutputPrefix() {
        return this.outputPrefix;
    }

    @Override
    public EciesParameters getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public Integer getIdRequirementOrNull() {
        return this.idRequirement;
    }

    @Override
    public boolean equalsKey(Key o) {
        if (!(o instanceof EciesPublicKey)) {
            return false;
        }
        EciesPublicKey other = (EciesPublicKey)o;
        return this.parameters.equals(other.parameters) && this.publicPointBytes.equals(other.publicPointBytes) && Objects.equals(this.idRequirement, other.idRequirement);
    }
}

