/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.prf;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.prf.HmacPrfProtoSerialization;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacPrfKey;
import com.google.crypto.tink.proto.HmacPrfKeyFormat;
import com.google.crypto.tink.proto.HmacPrfParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.subtle.PrfHmacJce;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public final class HmacPrfKeyManager
extends KeyTypeManager<HmacPrfKey> {
    private static final int MIN_KEY_SIZE_IN_BYTES = 16;

    public HmacPrfKeyManager() {
        super(HmacPrfKey.class, new PrimitiveFactory<Prf, HmacPrfKey>(Prf.class){

            @Override
            public Prf getPrimitive(HmacPrfKey key) throws GeneralSecurityException {
                HashType hash = key.getParams().getHash();
                byte[] keyValue = key.getKeyValue().toByteArray();
                SecretKeySpec keySpec = new SecretKeySpec(keyValue, "HMAC");
                switch (hash) {
                    case SHA1: {
                        return new PrfHmacJce("HMACSHA1", keySpec);
                    }
                    case SHA224: {
                        return new PrfHmacJce("HMACSHA224", keySpec);
                    }
                    case SHA256: {
                        return new PrfHmacJce("HMACSHA256", keySpec);
                    }
                    case SHA384: {
                        return new PrfHmacJce("HMACSHA384", keySpec);
                    }
                    case SHA512: {
                        return new PrfHmacJce("HMACSHA512", keySpec);
                    }
                }
                throw new GeneralSecurityException("unknown hash");
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacPrfKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(HmacPrfKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (key.getKeyValue().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        HmacPrfKeyManager.validateParams(key.getParams());
    }

    @Override
    public HmacPrfKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return HmacPrfKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    private static void validateParams(HmacPrfParams params) throws GeneralSecurityException {
        if (params.getHash() != HashType.SHA1 && params.getHash() != HashType.SHA224 && params.getHash() != HashType.SHA256 && params.getHash() != HashType.SHA384 && params.getHash() != HashType.SHA512) {
            throw new GeneralSecurityException("unknown hash type");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<HmacPrfKeyFormat, HmacPrfKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<HmacPrfKeyFormat, HmacPrfKey>(HmacPrfKeyFormat.class){

            @Override
            public void validateKeyFormat(HmacPrfKeyFormat format) throws GeneralSecurityException {
                if (format.getKeySize() < 16) {
                    throw new GeneralSecurityException("key too short");
                }
                HmacPrfKeyManager.validateParams(format.getParams());
            }

            @Override
            public HmacPrfKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return HmacPrfKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public HmacPrfKey createKey(HmacPrfKeyFormat format) {
                return (HmacPrfKey)HmacPrfKey.newBuilder().setVersion(HmacPrfKeyManager.this.getVersion()).setParams(format.getParams()).setKeyValue(ByteString.copyFrom(Random.randBytes(format.getKeySize()))).build();
            }

            @Override
            public HmacPrfKey deriveKey(HmacPrfKeyFormat format, InputStream inputStream) throws GeneralSecurityException {
                Validators.validateVersion(format.getVersion(), HmacPrfKeyManager.this.getVersion());
                byte[] pseudorandomness = new byte[format.getKeySize()];
                try {
                    2.readFully(inputStream, pseudorandomness);
                    return (HmacPrfKey)HmacPrfKey.newBuilder().setVersion(HmacPrfKeyManager.this.getVersion()).setParams(format.getParams()).setKeyValue(ByteString.copyFrom(pseudorandomness)).build();
                }
                catch (IOException e) {
                    throw new GeneralSecurityException("Reading pseudorandomness failed", e);
                }
            }

            @Override
            public Map<String, KeyTypeManager.KeyFactory.KeyFormat<HmacPrfKeyFormat>> keyFormats() throws GeneralSecurityException {
                HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<HmacPrfKeyFormat>> result = new HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<HmacPrfKeyFormat>>();
                result.put("HMAC_SHA256_PRF", new KeyTypeManager.KeyFactory.KeyFormat<HmacPrfKeyFormat>((HmacPrfKeyFormat)HmacPrfKeyFormat.newBuilder().setParams((HmacPrfParams)HmacPrfParams.newBuilder().setHash(HashType.SHA256).build()).setKeySize(32).build(), KeyTemplate.OutputPrefixType.RAW));
                result.put("HMAC_SHA512_PRF", new KeyTypeManager.KeyFactory.KeyFormat<HmacPrfKeyFormat>((HmacPrfKeyFormat)HmacPrfKeyFormat.newBuilder().setParams((HmacPrfParams)HmacPrfParams.newBuilder().setHash(HashType.SHA512).build()).setKeySize(64).build(), KeyTemplate.OutputPrefixType.RAW));
                return Collections.unmodifiableMap(result);
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new HmacPrfKeyManager(), newKeyAllowed);
        HmacPrfProtoSerialization.register();
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    }

    public static final KeyTemplate hmacSha256Template() {
        return HmacPrfKeyManager.createTemplate(32, HashType.SHA256);
    }

    public static final KeyTemplate hmacSha512Template() {
        return HmacPrfKeyManager.createTemplate(64, HashType.SHA512);
    }

    private static KeyTemplate createTemplate(int keySize, HashType hashType) {
        HmacPrfParams params = (HmacPrfParams)HmacPrfParams.newBuilder().setHash(hashType).build();
        HmacPrfKeyFormat format = (HmacPrfKeyFormat)HmacPrfKeyFormat.newBuilder().setParams(params).setKeySize(keySize).build();
        return KeyTemplate.create(new HmacPrfKeyManager().getKeyType(), format.toByteArray(), KeyTemplate.OutputPrefixType.RAW);
    }
}

