/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.proto;

import com.google.crypto.tink.proto.JwtHmacAlgorithm;
import com.google.crypto.tink.proto.JwtHmacKeyFormatOrBuilder;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.CodedInputStream;
import com.google.crypto.tink.shaded.protobuf.ExtensionRegistryLite;
import com.google.crypto.tink.shaded.protobuf.GeneratedMessageLite;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class JwtHmacKeyFormat
extends GeneratedMessageLite<JwtHmacKeyFormat, Builder>
implements JwtHmacKeyFormatOrBuilder {
    public static final int VERSION_FIELD_NUMBER = 1;
    private int version_;
    public static final int ALGORITHM_FIELD_NUMBER = 2;
    private int algorithm_;
    public static final int KEY_SIZE_FIELD_NUMBER = 3;
    private int keySize_;
    private static final JwtHmacKeyFormat DEFAULT_INSTANCE;
    private static volatile Parser<JwtHmacKeyFormat> PARSER;

    private JwtHmacKeyFormat() {
    }

    @Override
    public int getVersion() {
        return this.version_;
    }

    private void setVersion(int value) {
        this.version_ = value;
    }

    private void clearVersion() {
        this.version_ = 0;
    }

    @Override
    public int getAlgorithmValue() {
        return this.algorithm_;
    }

    @Override
    public JwtHmacAlgorithm getAlgorithm() {
        JwtHmacAlgorithm result = JwtHmacAlgorithm.forNumber(this.algorithm_);
        return result == null ? JwtHmacAlgorithm.UNRECOGNIZED : result;
    }

    private void setAlgorithmValue(int value) {
        this.algorithm_ = value;
    }

    private void setAlgorithm(JwtHmacAlgorithm value) {
        this.algorithm_ = value.getNumber();
    }

    private void clearAlgorithm() {
        this.algorithm_ = 0;
    }

    @Override
    public int getKeySize() {
        return this.keySize_;
    }

    private void setKeySize(int value) {
        this.keySize_ = value;
    }

    private void clearKeySize() {
        this.keySize_ = 0;
    }

    public static JwtHmacKeyFormat parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
    }

    public static JwtHmacKeyFormat parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
    }

    public static JwtHmacKeyFormat parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
    }

    public static JwtHmacKeyFormat parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
    }

    public static JwtHmacKeyFormat parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
    }

    public static JwtHmacKeyFormat parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
    }

    public static JwtHmacKeyFormat parseFrom(InputStream input) throws IOException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
    }

    public static JwtHmacKeyFormat parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
    }

    public static JwtHmacKeyFormat parseDelimitedFrom(InputStream input) throws IOException {
        return JwtHmacKeyFormat.parseDelimitedFrom(DEFAULT_INSTANCE, input);
    }

    public static JwtHmacKeyFormat parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return JwtHmacKeyFormat.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
    }

    public static JwtHmacKeyFormat parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
    }

    public static JwtHmacKeyFormat parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(JwtHmacKeyFormat prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new JwtHmacKeyFormat();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"version_", "algorithm_", "keySize_"};
                String info = "\u0000\u0003\u0000\u0000\u0001\u0003\u0003\u0000\u0000\u0000\u0001\u000b\u0002\f\u0003\u000b";
                return JwtHmacKeyFormat.newMessageInfo(DEFAULT_INSTANCE, info, objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                Parser<JwtHmacKeyFormat> parser = PARSER;
                if (parser != null) return parser;
                Class<JwtHmacKeyFormat> clazz = JwtHmacKeyFormat.class;
                synchronized (JwtHmacKeyFormat.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<JwtHmacKeyFormat>(DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static JwtHmacKeyFormat getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<JwtHmacKeyFormat> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        JwtHmacKeyFormat defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new JwtHmacKeyFormat();
        GeneratedMessageLite.registerDefaultInstance(JwtHmacKeyFormat.class, defaultInstance);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<JwtHmacKeyFormat, Builder>
    implements JwtHmacKeyFormatOrBuilder {
        private Builder() {
            super(DEFAULT_INSTANCE);
        }

        @Override
        public int getVersion() {
            return ((JwtHmacKeyFormat)this.instance).getVersion();
        }

        public Builder setVersion(int value) {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).setVersion(value);
            return this;
        }

        public Builder clearVersion() {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).clearVersion();
            return this;
        }

        @Override
        public int getAlgorithmValue() {
            return ((JwtHmacKeyFormat)this.instance).getAlgorithmValue();
        }

        public Builder setAlgorithmValue(int value) {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).setAlgorithmValue(value);
            return this;
        }

        @Override
        public JwtHmacAlgorithm getAlgorithm() {
            return ((JwtHmacKeyFormat)this.instance).getAlgorithm();
        }

        public Builder setAlgorithm(JwtHmacAlgorithm value) {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).setAlgorithm(value);
            return this;
        }

        public Builder clearAlgorithm() {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).clearAlgorithm();
            return this;
        }

        @Override
        public int getKeySize() {
            return ((JwtHmacKeyFormat)this.instance).getKeySize();
        }

        public Builder setKeySize(int value) {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).setKeySize(value);
            return this;
        }

        public Builder clearKeySize() {
            this.copyOnWrite();
            ((JwtHmacKeyFormat)this.instance).clearKeySize();
            return this;
        }
    }
}

